/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.messages;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;

public class SimpleSystemMessage
extends SystemMessage {
    private String _pluginId;
    private String _messageId;

    public SimpleSystemMessage(String pluginId, String messageId, int severity, String msg) {
        this(pluginId, messageId, severity, msg, (String)null);
    }

    public SimpleSystemMessage(String pluginId, String messageId, int severity, String msg, String msgDetails) {
        super("RSE", "G", "-", SimpleSystemMessage.severityToIndicator(severity), msg, msgDetails);
        this._pluginId = pluginId;
        this._messageId = messageId;
    }

    public SimpleSystemMessage(String pluginId, String messageId, int severity, String msg, Throwable e) {
        super("RSE", "G", "-", SimpleSystemMessage.severityToIndicator(severity), msg, SimpleSystemMessage.throwableToDetails(e));
        this._pluginId = pluginId;
        this._messageId = messageId;
    }

    public SimpleSystemMessage(String pluginId, int severity, String msg) {
        this(pluginId, severity, msg, (String)null);
    }

    public SimpleSystemMessage(String pluginId, int severity, String msg, String msgDetails) {
        super("RSE", "G", "-", SimpleSystemMessage.severityToIndicator(severity), msg, msgDetails);
        this._pluginId = pluginId;
    }

    public SimpleSystemMessage(String pluginId, int severity, String msg, Throwable e) {
        super("RSE", "G", "-", SimpleSystemMessage.severityToIndicator(severity), msg, SimpleSystemMessage.throwableToDetails(e));
        this._pluginId = pluginId;
    }

    private static String throwableToDetails(Throwable e) {
        StringWriter excWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(excWriter));
        String dmsg = e.toString();
        if (dmsg == null || e instanceof ClassCastException) {
            dmsg = e.getClass().getName();
        }
        String msgDetails = String.valueOf(dmsg) + "\n" + excWriter.toString();
        return msgDetails;
    }

    private static char severityToIndicator(int severity) {
        int ind = 67;
        if ((severity & 8) != 0) {
            ind = 85;
        } else if ((severity & 4) != 0) {
            ind = 69;
        } else if ((severity & 1) != 0) {
            ind = 73;
        } else if (false) {
            ind = 67;
        } else if ((severity & 2) != 0) {
            ind = 87;
        }
        return (char)ind;
    }

    public String getFullMessageID() {
        if (this._messageId != null) {
            return this._messageId;
        }
        return String.valueOf(this._pluginId) + ":" + this.getIndicator();
    }
}

