/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.RemoteFileException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemBasePlugin;

public class UniFilePlus
extends File {
    private static final long serialVersionUID = -1717648997950319457L;
    public IRemoteFile remoteFile = null;

    public UniFilePlus(IRemoteFile remoteFile) {
        super(remoteFile.getAbsolutePath());
        this.remoteFile = remoteFile;
    }

    public boolean canRead() {
        return this.remoteFile.canRead();
    }

    public boolean canWrite() {
        return this.remoteFile.canWrite();
    }

    public int compareTo(File pathname) {
        if (pathname instanceof UniFilePlus) {
            return this.remoteFile.compareTo((Object)pathname);
        }
        return super.compareTo(pathname);
    }

    public boolean createNewFile() throws IOException {
        IRemoteFile newFile = null;
        try {
            newFile = this.remoteFile.getParentRemoteFileSubSystem().createFile(this.remoteFile, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (RemoteFileException exc) {
            Exception e = exc.getRemoteException();
            if (e != null) {
                if (e instanceof SecurityException) {
                    throw (SecurityException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
            }
            if (exc instanceof RemoteFileSecurityException) {
                throw new SecurityException(exc.getMessage());
            }
            throw new IOException(exc.getMessage());
        }
        catch (SystemMessageException e) {
            throw new IOException(e.getMessage());
        }
        if (newFile != null) {
            this.remoteFile = newFile;
            return true;
        }
        return false;
    }

    public boolean delete() {
        boolean ok = true;
        try {
            this.remoteFile.getParentRemoteFileSubSystem().delete(this.remoteFile, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (RemoteFileException exc) {
            Exception e = exc.getRemoteException();
            if (e != null && e instanceof SecurityException) {
                throw (SecurityException)e;
            }
            throw new SecurityException(exc.getMessage());
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logMessage((SystemMessage)e.getSystemMessage());
            ok = false;
        }
        return ok;
    }

    public void deleteOnExit() {
    }

    public boolean equals(Object obj) {
        return this.remoteFile.equals(obj);
    }

    public boolean exists() {
        return this.remoteFile.exists();
    }

    public File getAbsoluteFile() {
        return this;
    }

    public String getAbsolutePath() {
        return this.remoteFile.getAbsolutePath();
    }

    public File getCanonicalFile() {
        return this;
    }

    public String getCanonicalPath() {
        return this.remoteFile.getAbsolutePathPlusConnection();
    }

    public String getName() {
        return this.remoteFile.getName();
    }

    public String getParent() {
        return this.remoteFile.getParentPath();
    }

    public UniFilePlus getParentFile() {
        throw new Error("Unresolved compilation problem: \n\tThe return type is incompatible with File.getParentFile()\n");
    }

    public String getPath() {
        return this.remoteFile.getAbsolutePath();
    }

    public int hashCode() {
        return this.remoteFile.getAbsolutePathPlusConnection().hashCode();
    }

    public boolean isAbsolute() {
        return true;
    }

    public boolean isDirectory() {
        return this.remoteFile.isDirectory();
    }

    public boolean isFile() {
        return this.remoteFile.isFile();
    }

    public boolean isHidden() {
        return this.remoteFile.isHidden();
    }

    public long lastModified() {
        return this.remoteFile.getLastModified();
    }

    public long length() {
        return this.remoteFile.getLength();
    }

    public IRemoteFile[] listIRemoteFiles() {
        IRemoteFile[] result = null;
        try {
            result = this.remoteFile.getParentRemoteFileSubSystem().list(this.remoteFile, this.getNullMonitor());
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"unexpected exception", (Throwable)e);
        }
        return result;
    }

    public String[] list() {
        IRemoteFile[] files = null;
        try {
            files = this.remoteFile.getParentRemoteFileSubSystem().list(this.remoteFile, this.getNullMonitor());
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"unexpected exception", (Throwable)e);
        }
        if (files != null) {
            String[] fileNames = new String[files.length];
            int idx = 0;
            while (idx < files.length) {
                fileNames[idx] = files[idx].getName();
                ++idx;
            }
            return fileNames;
        }
        return null;
    }

    public File[] listFiles() {
        throw new Error("Unresolved compilation problems: \n\tSyntax error, parameterized types are only available if source level is 1.5\n\tSyntax error, parameterized types are only available if source level is 1.5\n\tType mismatch: cannot convert from Object[] to File[]\n");
    }

    public String[] list(FilenameFilter filter) {
        IRemoteFile[] files = null;
        try {
            files = this.remoteFile.getParentRemoteFileSubSystem().list(this.remoteFile, this.getNullMonitor());
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"unexpected exception", (Throwable)e);
        }
        if (files != null) {
            Vector<String> v = new Vector<String>();
            String fileName = null;
            int idx = 0;
            while (idx < files.length) {
                fileName = files[idx].getName();
                if (fileName != null && filter.accept(this, fileName)) {
                    v.addElement(fileName);
                }
                ++idx;
            }
            String[] fileNames = new String[v.size()];
            int idx2 = 0;
            while (idx2 < v.size()) {
                fileNames[idx2] = (String)v.elementAt(idx2);
                ++idx2;
            }
            return fileNames;
        }
        return null;
    }

    public File[] listFiles(FileFilter filter) {
        IRemoteFile[] files = null;
        try {
            files = this.remoteFile.getParentRemoteFileSubSystem().list(this.remoteFile, this.getNullMonitor());
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"unexpected exception", (Throwable)e);
        }
        if (files != null) {
            Vector<File> v = new Vector<File>();
            int idx = 0;
            while (idx < files.length) {
                File fileObj = new File(files[idx].getAbsolutePath());
                if (filter.accept(fileObj)) {
                    v.addElement(fileObj);
                }
                ++idx;
            }
            File[] fileObjs = new File[v.size()];
            int idx2 = 0;
            while (idx2 < v.size()) {
                fileObjs[idx2] = (File)v.elementAt(idx2);
                ++idx2;
            }
            return fileObjs;
        }
        return null;
    }

    public File[] listFiles(FilenameFilter filter) {
        IRemoteFile[] files = null;
        try {
            files = this.remoteFile.getParentRemoteFileSubSystem().list(this.remoteFile, this.getNullMonitor());
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"unexpected exception", (Throwable)e);
        }
        if (files != null) {
            Vector<IRemoteFile> v = new Vector<IRemoteFile>();
            String fileName = null;
            int idx = 0;
            while (idx < files.length) {
                fileName = files[idx].getName();
                if (fileName != null && filter.accept(this, fileName)) {
                    v.addElement(files[idx]);
                }
                ++idx;
            }
            File[] fileObjs = new File[v.size()];
            int idx2 = 0;
            while (idx2 < v.size()) {
                fileObjs[idx2] = new File(((IRemoteFile)v.elementAt(idx2)).getAbsolutePath());
                ++idx2;
            }
            return fileObjs;
        }
        return null;
    }

    public boolean mkdir() {
        IRemoteFile dir = null;
        try {
            if (!this.remoteFile.exists()) {
                dir = this.remoteFile.getParentRemoteFileSubSystem().createFolder(this.remoteFile, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (RemoteFileException exc) {
            Exception e = exc.getRemoteException();
            if (e != null && e instanceof SecurityException) {
                throw (SecurityException)e;
            }
            throw new SecurityException(exc.getMessage());
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logMessage((SystemMessage)e.getSystemMessage());
        }
        if (dir != null) {
            this.remoteFile = dir;
        }
        return dir != null;
    }

    public boolean mkdirs() {
        IRemoteFile dir = null;
        try {
            if (!this.remoteFile.exists()) {
                dir = this.remoteFile.getParentRemoteFileSubSystem().createFolders(this.remoteFile, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (RemoteFileException exc) {
            Exception e = exc.getRemoteException();
            if (e != null && e instanceof SecurityException) {
                throw (SecurityException)e;
            }
            throw new SecurityException(exc.getMessage());
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logMessage((SystemMessage)e.getSystemMessage());
        }
        if (dir != null) {
            this.remoteFile = dir;
        }
        return dir != null;
    }

    public boolean renameTo(File dest) {
        boolean ok = false;
        try {
            this.remoteFile.getParentRemoteFileSubSystem().rename(this.remoteFile, dest.getName(), (IProgressMonitor)new NullProgressMonitor());
            ok = true;
        }
        catch (RemoteFileException exc) {
            Exception e = exc.getRemoteException();
            if (e != null && e instanceof SecurityException) {
                throw (SecurityException)e;
            }
            throw new SecurityException(exc.getMessage());
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logMessage((SystemMessage)e.getSystemMessage());
        }
        return ok;
    }

    public boolean setLastModified(long time) {
        boolean ok = false;
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            this.remoteFile.getParentRemoteFileSubSystem().setLastModified(this.remoteFile, time, (IProgressMonitor)monitor);
            ok = true;
        }
        catch (RemoteFileException exc) {
            Exception e = exc.getRemoteException();
            if (e != null && e instanceof SecurityException) {
                throw (SecurityException)e;
            }
            throw new SecurityException(exc.getMessage());
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logMessage((SystemMessage)e.getSystemMessage());
        }
        return ok;
    }

    public boolean setReadOnly() {
        boolean ok = false;
        try {
            this.remoteFile.getParentRemoteFileSubSystem().setReadOnly(this.remoteFile, true, (IProgressMonitor)new NullProgressMonitor());
            ok = true;
        }
        catch (RemoteFileException exc) {
            Exception e = exc.getRemoteException();
            if (e != null && e instanceof SecurityException) {
                throw (SecurityException)e;
            }
            throw new SecurityException(exc.getMessage());
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logMessage((SystemMessage)e.getSystemMessage());
        }
        return ok;
    }

    public String toString() {
        return this.getPath();
    }

    public URL toURL() throws MalformedURLException {
        String urlName = "file://" + this.remoteFile.getAbsolutePathPlusConnection().replace('\\', '/');
        if (this.remoteFile.isDirectory() && !urlName.endsWith("/")) {
            urlName = String.valueOf(urlName) + '/';
        }
        return new URL(urlName);
    }

    private IProgressMonitor getNullMonitor() {
        NullProgressMonitor result = new NullProgressMonitor();
        return result;
    }

    public IRemoteFile getRemoteFile() {
        return this.remoteFile;
    }

    public InputStream getInputStream() throws SystemMessageException {
        return this.remoteFile.getParentRemoteFileSubSystem().getInputStream(this.remoteFile.getParentPath(), this.remoteFile.getName(), this.remoteFile.isBinary(), null);
    }

    public void synchRemoteFile() {
        this.remoteFile.markStale(true);
        try {
            this.remoteFile = this.remoteFile.getParentRemoteFileSubSystem().getRemoteFileObject(this.remoteFile.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {}
    }
}

