/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.local.shells;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.internal.services.local.ILocalService;
import org.eclipse.rse.internal.services.local.LocalServiceResources;
import org.eclipse.rse.internal.services.local.shells.LocalHostShell;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.AbstractShellService;
import org.eclipse.rse.services.shells.IHostShell;

public class LocalShellService
extends AbstractShellService
implements ILocalService {
    private static final String SHELL_INVOCATION = ">";
    private String[] _envVars;

    public String getName() {
        return LocalServiceResources.Local_Shell_Service_Name;
    }

    public String getDescription() {
        return LocalServiceResources.Local_Shell_Service_Description;
    }

    public IHostShell launchShell(String initialWorkingDirectory, String encoding, String[] environment, IProgressMonitor monitor) throws SystemMessageException {
        LocalHostShell hostShell = new LocalHostShell(initialWorkingDirectory, SHELL_INVOCATION, encoding, environment);
        hostShell.run(monitor);
        return hostShell;
    }

    public IHostShell runCommand(String initialWorkingDirectory, String command, String encoding, String[] environment, IProgressMonitor monitor) throws SystemMessageException {
        LocalHostShell hostShell = new LocalHostShell(initialWorkingDirectory, command, encoding, environment);
        hostShell.run(monitor);
        return hostShell;
    }

    public String[] getHostEnvironment() throws SystemMessageException {
        if (this._envVars == null) {
            ArrayList<String> envVars;
            block8: {
                envVars = new ArrayList<String>();
                String[] envCommand = new String[3];
                if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                    envCommand[0] = "cmd";
                    envCommand[1] = "/c";
                    envCommand[2] = "set";
                } else {
                    envCommand[0] = "sh";
                    envCommand[1] = "-c";
                    envCommand[2] = "env";
                }
                BufferedReader reader = null;
                try {
                    Process process = Runtime.getRuntime().exec(envCommand);
                    InputStream stdout = process.getInputStream();
                    InputStreamReader ireader = new InputStreamReader(stdout);
                    reader = new BufferedReader(ireader);
                    String curLine = null;
                    while ((curLine = reader.readLine()) != null) {
                        if (curLine.indexOf("=") <= 0) continue;
                        envVars.add(curLine);
                    }
                    reader.close();
                    process.exitValue();
                }
                catch (Exception exception) {
                    if (reader == null) break block8;
                    try {
                        reader.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            this._envVars = envVars.toArray(new String[envVars.size()]);
        }
        return this._envVars;
    }
}

