/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.dsf.events;

import java.util.concurrent.ExecutionException;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.tests.dsf.DsfTestPlugin;
import org.eclipse.dd.tests.dsf.TestDsfExecutor;
import org.eclipse.dd.tests.dsf.events.Service1;
import org.eclipse.dd.tests.dsf.events.Service2;
import org.eclipse.dd.tests.dsf.events.Service3;
import org.eclipse.dd.tests.dsf.events.ShutdownSequence;
import org.eclipse.dd.tests.dsf.events.StartupSequence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EventTest {
    DsfSession fSession;
    TestDsfExecutor fExecutor;
    DsfServicesTracker fTracker;
    Service1 fService1;
    Service2 fService2;
    Service3 fService3;

    @Before
    public void startServices() throws ExecutionException, InterruptedException {
        this.fExecutor = new TestDsfExecutor();
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                EventTest.this.fSession = DsfSession.startSession((DsfExecutor)EventTest.this.fExecutor, (String)"org.eclipse.dd.tests.dsf");
            }
        }).get();
        StartupSequence startupSeq = new StartupSequence(this.fSession);
        this.fExecutor.execute((Runnable)((Object)startupSeq));
        startupSeq.get();
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                EventTest.this.fTracker = new DsfServicesTracker(DsfTestPlugin.getBundleContext(), EventTest.this.fSession.getId());
                EventTest.this.fService1 = (Service1)((Object)EventTest.this.fTracker.getService(Service1.class));
                EventTest.this.fService2 = (Service2)((Object)EventTest.this.fTracker.getService(Service2.class));
                EventTest.this.fService3 = (Service3)((Object)EventTest.this.fTracker.getService(Service3.class));
            }
        }).get();
        Assert.assertNotNull((Object)((Object)this.fService1));
        Assert.assertNotNull((Object)((Object)this.fService2));
        Assert.assertNotNull((Object)((Object)this.fService3));
    }

    @After
    public void shutdownServices() throws ExecutionException, InterruptedException {
        ShutdownSequence shutdownSeq = new ShutdownSequence(this.fSession);
        this.fExecutor.execute((Runnable)((Object)shutdownSeq));
        shutdownSeq.get();
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                EventTest.this.fService1 = null;
                EventTest.this.fService2 = null;
                EventTest.this.fService3 = null;
                EventTest.this.fTracker.dispose();
                EventTest.this.fTracker = null;
                DsfSession.endSession((DsfSession)EventTest.this.fSession);
                EventTest.this.fSession = null;
                EventTest.this.fExecutor.shutdown();
            }
        }).get();
        if (this.fExecutor.exceptionsCaught()) {
            Throwable[] exceptions = this.fExecutor.getExceptions();
            throw new ExecutionException(exceptions[0]);
        }
        this.fExecutor = null;
    }

    @Test
    public void startStopTest() {
    }

    @Test
    public void event1Test() throws ExecutionException, InterruptedException {
        this.fService1.dispatchEvent1();
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                Assert.assertTrue((1 == EventTest.this.fService1.fEvent1RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((2 == EventTest.this.fService2.fEvent1RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((3 == EventTest.this.fService3.fEvent1RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService1.fEvent2RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService2.fEvent2RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService3.fEvent2RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService1.fEvent3RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService2.fEvent3RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService3.fEvent3RecipientNumber ? 1 : 0) != 0);
            }
        }).get();
    }

    @Test
    public void event2Test() throws ExecutionException, InterruptedException {
        this.fService1.dispatchEvent2();
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                Assert.assertTrue((0 == EventTest.this.fService1.fEvent1RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService2.fEvent1RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService3.fEvent1RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((1 == EventTest.this.fService1.fEvent2RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((2 == EventTest.this.fService2.fEvent2RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((3 == EventTest.this.fService3.fEvent2RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService1.fEvent3RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService2.fEvent3RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService3.fEvent3RecipientNumber ? 1 : 0) != 0);
            }
        }).get();
    }

    @Test
    public void event3Test() throws ExecutionException, InterruptedException {
        this.fService1.dispatchEvent3();
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                Assert.assertTrue((1 == EventTest.this.fService1.fEvent1RecipientNumber || 2 == EventTest.this.fService1.fEvent1RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((3 == EventTest.this.fService2.fEvent1RecipientNumber || 4 == EventTest.this.fService2.fEvent1RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((5 == EventTest.this.fService3.fEvent1RecipientNumber || 6 == EventTest.this.fService3.fEvent1RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService1.fEvent2RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService2.fEvent2RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((0 == EventTest.this.fService3.fEvent2RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((1 == EventTest.this.fService1.fEvent3RecipientNumber || 2 == EventTest.this.fService1.fEvent3RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((3 == EventTest.this.fService2.fEvent3RecipientNumber || 4 == EventTest.this.fService2.fEvent3RecipientNumber ? 1 : 0) != 0);
                Assert.assertTrue((5 == EventTest.this.fService3.fEvent3RecipientNumber || 6 == EventTest.this.fService3.fEvent3RecipientNumber ? 1 : 0) != 0);
            }
        }).get();
    }
}

