/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.BusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.Channel;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class CheckChannels {
    public static int checkChannels(DocumentChecker checker) {
        int nErrors = 0;
        SpiritComponentDocument documentNode = (SpiritComponentDocument)checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        SpiritLibrary library = checker.getLibrary();
        List busInterfaces = documentNode.getBusInterfaces();
        NodeList channelNodes = documentNode.getDescendants("channel");
        for (BusInterface busInterface : busInterfaces) {
            SpiritDocument doc = library.get(busInterface.getVlnv());
            if (doc == null) {
                reporter.report(CheckList.CHECK_INFORMATION, (SpiritDocument)documentNode, MessageFormat.format(Messages.CheckChannels_1, busInterface.getVlnv(), busInterface));
                ++nErrors;
                continue;
            }
            if (!(doc instanceof SpiritBusDefinitionDocument)) {
                reporter.report(CheckList.CHECK_ERROR, (SpiritDocument)documentNode, MessageFormat.format(Messages.CheckChannels_2, busInterface.getVlnv()), (SpiritNode)busInterface);
                ++nErrors;
                continue;
            }
            String busIfName = busInterface.getName();
            List signalMap = busInterface.getSignalMap();
            int nMatchingChannels = 0;
            for (int i = 0; i < channelNodes.getLength(); ++i) {
                Channel c = new Channel((Element)channelNodes.item(i));
                List channelBIs = c.getBusInterfaceRefs();
                for (String bi : channelBIs) {
                    if (!bi.equals(busIfName)) continue;
                    ++nMatchingChannels;
                }
            }
            if (nMatchingChannels > 0 && !busInterface.isMirrored()) {
                reporter.report(CheckList.CHECK_26, (SpiritDocument)documentNode, MessageFormat.format(Messages.CheckChannels_6, busIfName), (SpiritNode)busInterface);
                ++nErrors;
            }
            if (nMatchingChannels > 1) {
                reporter.report(CheckList.CHECK_29, (SpiritDocument)documentNode, MessageFormat.format(Messages.CheckChannels_7, busIfName), (SpiritNode)busInterface);
                ++nErrors;
            }
            for (String masterName : busInterface.getMasterRefs()) {
                if (masterName.length() > 0) {
                    BusInterface masterNode = documentNode.getBusInterface(masterName);
                    if (masterNode == null) {
                        reporter.report(CheckList.CHECK_30, (SpiritDocument)documentNode, MessageFormat.format(Messages.CheckChannels_10, busIfName, masterName), (SpiritNode)busInterface);
                        ++nErrors;
                    } else if (!masterNode.isMaster()) {
                        reporter.report(CheckList.CHECK_30, (SpiritDocument)documentNode, MessageFormat.format(Messages.CheckChannels_11, busIfName), (SpiritNode)busInterface);
                        ++nErrors;
                    }
                }
                if (busInterface.isMirrored() && masterName.length() > 0) {
                    reporter.report(CheckList.CHECK_WARNING, (SpiritDocument)documentNode, MessageFormat.format(Messages.CheckChannels_12, busIfName), (SpiritNode)busInterface);
                    ++nErrors;
                }
                if (nMatchingChannels != 0 || masterName.length() != 0 || !signalMap.isEmpty()) continue;
                reporter.report(CheckList.CHECK_WARNING, (SpiritDocument)documentNode, MessageFormat.format(Messages.CheckChannels_13, busIfName), (SpiritNode)busInterface);
                ++nErrors;
            }
        }
        String message = Messages.CheckChannels_43;
        for (int i = 0; i < channelNodes.getLength(); ++i) {
            Element channel = (Element)channelNodes.item(i);
            String ifName = SpiritNode.createSpiritNode((Element)channel).getUniqueDescendantText("busInterfaceRef");
            BusInterface busInterface = documentNode.getBusInterface(ifName);
            if (busInterface != null) continue;
            reporter.report(CheckList.CHECK_WARNING, (SpiritDocument)documentNode, MessageFormat.format(message, ifName, new Channel(channel).getName()), channel);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkChannelConnections(DocumentChecker checker) {
        int nErrors = 0;
        SpiritComponentDocument componentDoc = (SpiritComponentDocument)checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        SpiritLibrary library = checker.getLibrary();
        NodeList nodes = componentDoc.getDescendants("channel");
        for (int index = 0; index < nodes.getLength(); ++index) {
            Element channelNode = (Element)nodes.item(index);
            Channel channel = new Channel(channelNode);
            ArrayList<BusInterface> busInterfaces = new ArrayList<BusInterface>();
            List busInterfaceRefs = channel.getBusInterfaceRefs();
            for (String busInterfaceName : busInterfaceRefs) {
                BusInterface busInterfaceNode = componentDoc.getBusInterface(busInterfaceName);
                if (busInterfaceNode == null) {
                    reporter.report(CheckList.CHECK_25, (SpiritDocument)componentDoc, MessageFormat.format(Messages.CheckChannels_48, channel.getName(), busInterfaceName), channelNode);
                    ++nErrors;
                    continue;
                }
                busInterfaces.add(busInterfaceNode);
            }
            int size = busInterfaces.size();
            for (int index1 = 0; index1 < size; ++index1) {
                BusInterface busType1 = (BusInterface)busInterfaces.get(index1);
                for (int index2 = index1 + 1; index2 < size; ++index2) {
                    BusInterface busType2 = (BusInterface)busInterfaces.get(index2);
                    if (channel.schemaVersion() == SchemaInfo.IpxactVersion.BEFORE_V14) {
                        if (Utilities.areBusesCompatible(checker, busType1.getVlnv(), busType2.getVlnv())) continue;
                        reporter.report(CheckList.CHECK_25, (SpiritDocument)componentDoc, MessageFormat.format(Messages.CheckChannels_49, busType1.getName(), busType1.getVlnv(), busType2.getName(), busType2.getVlnv()), channelNode);
                        ++nErrors;
                        continue;
                    }
                    if (Utilities.areBusesCompatible(checker, busType1.getAbstractionVlnv(), busType2.getAbstractionVlnv())) continue;
                    reporter.report(CheckList.CHECK_25, (SpiritDocument)componentDoc, MessageFormat.format(Messages.CheckChannels_49, busType1.getName(), busType1.getAbstractionVlnv(), busType2.getName(), busType2.getAbstractionVlnv()), channelNode);
                    ++nErrors;
                }
            }
            int masters = 0;
            int slaves = 0;
            int maxMasters = channel.getMaxMasters();
            int maxSlaves = channel.getMaxSlaves();
            for (BusInterface busInterface : busInterfaces) {
                String busDefMaxSlaves;
                int value;
                if (busInterface.isMirroredMaster()) {
                    ++masters;
                } else if (busInterface.isMirroredSlave()) {
                    ++slaves;
                }
                SpiritDocument busDefinition = library.get(busInterface.getVlnv());
                if (busDefinition == null) {
                    reporter.report(CheckList.CHECK_INFORMATION, (SpiritDocument)componentDoc, MessageFormat.format(Messages.CheckChannels_50, busInterface.getVlnv(), channel.getName()), channelNode);
                    ++nErrors;
                    continue;
                }
                String busDefMaxMasters = busDefinition.getUniqueDescendantText("maxMasters");
                if (busDefMaxMasters.length() > 0) {
                    try {
                        value = Integer.parseInt(busDefMaxMasters);
                        maxMasters = Math.min(maxMasters, value);
                    }
                    catch (NumberFormatException nfe) {
                        reporter.report(CheckList.CHECK_ERROR, null, MessageFormat.format(Messages.CheckChannels_52, busInterface.getVlnv()));
                        ++nErrors;
                    }
                }
                if ((busDefMaxSlaves = busDefinition.getUniqueDescendantText("maxSlaves")).length() <= 0) continue;
                try {
                    value = Integer.parseInt(busDefMaxSlaves);
                    maxSlaves = Math.min(maxSlaves, value);
                }
                catch (NumberFormatException nfe) {
                    reporter.report(CheckList.CHECK_ERROR, null, MessageFormat.format(Messages.CheckChannels_54, busInterface.getVlnv()));
                    ++nErrors;
                }
            }
            if (masters > maxMasters) {
                reporter.report(CheckList.CHECK_27, (SpiritDocument)componentDoc, MessageFormat.format(Messages.CheckChannels_55, new Integer(masters)), channelNode);
                ++nErrors;
            }
            if (slaves <= maxSlaves) continue;
            reporter.report(CheckList.CHECK_28, (SpiritDocument)componentDoc, MessageFormat.format(Messages.CheckChannels_56, new Integer(slaves)), channelNode);
            ++nErrors;
        }
        return nErrors;
    }
}

