/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.util.ArrayList;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;

public class MIArg {
    String name;
    String value;

    public MIArg(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static MIArg[] getMIArgs(MIList miList) {
        ArrayList<MIArg> aList = new ArrayList<MIArg>();
        MIValue[] values = miList.getMIValues();
        for (int i = 0; i < values.length; ++i) {
            MIArg arg;
            if (!(values[i] instanceof MITuple) || (arg = MIArg.getMIArg((MITuple)values[i])) == null) continue;
            aList.add(arg);
        }
        MIResult[] results = miList.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            MIValue value = results[i].getMIValue();
            if (!(value instanceof MIConst)) continue;
            String str = ((MIConst)value).getCString();
            aList.add(new MIArg(str, ""));
        }
        return aList.toArray(new MIArg[aList.size()]);
    }

    public static MIArg[] getMIArgs(MITuple miTuple) {
        ArrayList<MIArg> aList = new ArrayList<MIArg>();
        MIValue[] values = miTuple.getMIValues();
        for (int i = 0; i < values.length; ++i) {
            MIArg arg;
            if (!(values[i] instanceof MITuple) || (arg = MIArg.getMIArg((MITuple)values[i])) == null) continue;
            aList.add(arg);
        }
        MIResult[] results = miTuple.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            MIValue value = results[i].getMIValue();
            if (!(value instanceof MIConst)) continue;
            String str = ((MIConst)value).getCString();
            aList.add(new MIArg(str, ""));
        }
        return aList.toArray(new MIArg[aList.size()]);
    }

    public static MIArg getMIArg(MITuple tuple) {
        MIResult[] args = tuple.getMIResults();
        MIArg arg = null;
        if (args.length > 0) {
            String aName = "";
            MIValue value = args[0].getMIValue();
            aName = value != null && value instanceof MIConst ? ((MIConst)value).getCString() : "";
            String aValue = "";
            if (args.length == 2) {
                value = args[1].getMIValue();
                aValue = value != null && value instanceof MIConst ? ((MIConst)value).getCString() : "";
            }
            arg = new MIArg(aName, aValue);
        }
        return arg;
    }

    public String toString() {
        return this.name + "=" + this.value;
    }
}

