/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.dsf.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.tests.dsf.TestDsfExecutor;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DsfSequenceProgressTests {
    private List<Throwable> fExceptions = Collections.synchronizedList(new ArrayList());
    TestDsfExecutor fExecutor;
    final IntegerHolder stepCounter = new IntegerHolder();
    final IntegerHolder rollBackCounter = new IntegerHolder();

    @Before
    public void startExecutor() throws ExecutionException, InterruptedException {
        this.fExecutor = new TestDsfExecutor();
    }

    @After
    public void shutdownExecutor() throws ExecutionException, InterruptedException {
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                DsfSequenceProgressTests.this.fExecutor.shutdown();
            }
        }).get();
        if (this.fExecutor.exceptionsCaught()) {
            Throwable[] exceptions = this.fExecutor.getExceptions();
            throw new ExecutionException(exceptions[0]);
        }
        this.fExecutor = null;
    }

    @Test
    public void sequenceProgressTest() throws InterruptedException, ExecutionException {
        final Sequence.Step[] steps = new Sequence.Step[]{new SleepStepWithProgress(){

            public String getTaskName() {
                return "StepWithProgress #1";
            }
        }, new SleepStepWithProgress(){

            public String getTaskName() {
                return "StepWithProgress #2";
            }
        }, new SleepStep(){

            public String getTaskName() {
                return "Step #3";
            }
        }, new SleepStep(){

            public String getTaskName() {
                return "Step #4";
            }
        }};
        this.fExceptions.clear();
        Job myJob = new Job("Run test sequence"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            protected IStatus run(IProgressMonitor monitor) {
                block18: {
                    Sequence sequence = new Sequence((DsfExecutor)DsfSequenceProgressTests.this.fExecutor, monitor, "Run my sequence", "Rollback my sequence"){

                        public Sequence.Step[] getSteps() {
                            return steps;
                        }
                    };
                    DsfSequenceProgressTests.this.fExecutor.execute((Runnable)sequence);
                    sequence.get();
                    Object var5_3 = null;
                    try {
                        System.out.println("StepCounter: " + DsfSequenceProgressTests.this.stepCounter.fInteger);
                        System.out.println("RollBackCounter: " + DsfSequenceProgressTests.this.rollBackCounter.fInteger);
                        if (sequence.isCancelled()) {
                            Assert.assertTrue((String)"Wrong number of steps were rolled back after cancellation.", (DsfSequenceProgressTests.this.stepCounter.fInteger == DsfSequenceProgressTests.this.rollBackCounter.fInteger ? 1 : 0) != 0);
                        } else {
                            Assert.assertTrue((String)"Wrong number of steps executed.", (DsfSequenceProgressTests.this.stepCounter.fInteger == steps.length ? 1 : 0) != 0);
                            Assert.assertTrue((String)"Some steps are mistakenly rolled back", (DsfSequenceProgressTests.this.rollBackCounter.fInteger == 0 ? 1 : 0) != 0);
                        }
                        Assert.assertTrue((boolean)sequence.isDone());
                    }
                    catch (AssertionFailedError e2) {
                        DsfSequenceProgressTests.this.fExceptions.add(e2);
                    }
                    break block18;
                    {
                        catch (InterruptedException e) {
                            Object var5_4 = null;
                            try {
                                System.out.println("StepCounter: " + DsfSequenceProgressTests.this.stepCounter.fInteger);
                                System.out.println("RollBackCounter: " + DsfSequenceProgressTests.this.rollBackCounter.fInteger);
                                if (sequence.isCancelled()) {
                                    Assert.assertTrue((String)"Wrong number of steps were rolled back after cancellation.", (DsfSequenceProgressTests.this.stepCounter.fInteger == DsfSequenceProgressTests.this.rollBackCounter.fInteger ? 1 : 0) != 0);
                                } else {
                                    Assert.assertTrue((String)"Wrong number of steps executed.", (DsfSequenceProgressTests.this.stepCounter.fInteger == steps.length ? 1 : 0) != 0);
                                    Assert.assertTrue((String)"Some steps are mistakenly rolled back", (DsfSequenceProgressTests.this.rollBackCounter.fInteger == 0 ? 1 : 0) != 0);
                                }
                                Assert.assertTrue((boolean)sequence.isDone());
                            }
                            catch (AssertionFailedError e2) {
                                DsfSequenceProgressTests.this.fExceptions.add(e2);
                            }
                            break block18;
                        }
                        catch (ExecutionException executionException) {
                            Object var5_5 = null;
                            try {
                                System.out.println("StepCounter: " + DsfSequenceProgressTests.this.stepCounter.fInteger);
                                System.out.println("RollBackCounter: " + DsfSequenceProgressTests.this.rollBackCounter.fInteger);
                                if (sequence.isCancelled()) {
                                    Assert.assertTrue((String)"Wrong number of steps were rolled back after cancellation.", (DsfSequenceProgressTests.this.stepCounter.fInteger == DsfSequenceProgressTests.this.rollBackCounter.fInteger ? 1 : 0) != 0);
                                } else {
                                    Assert.assertTrue((String)"Wrong number of steps executed.", (DsfSequenceProgressTests.this.stepCounter.fInteger == steps.length ? 1 : 0) != 0);
                                    Assert.assertTrue((String)"Some steps are mistakenly rolled back", (DsfSequenceProgressTests.this.rollBackCounter.fInteger == 0 ? 1 : 0) != 0);
                                }
                                Assert.assertTrue((boolean)sequence.isDone());
                            }
                            catch (AssertionFailedError e2) {
                                DsfSequenceProgressTests.this.fExceptions.add(e2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        try {
                            System.out.println("StepCounter: " + DsfSequenceProgressTests.this.stepCounter.fInteger);
                            System.out.println("RollBackCounter: " + DsfSequenceProgressTests.this.rollBackCounter.fInteger);
                            if (sequence.isCancelled()) {
                                Assert.assertTrue((String)"Wrong number of steps were rolled back after cancellation.", (DsfSequenceProgressTests.this.stepCounter.fInteger == DsfSequenceProgressTests.this.rollBackCounter.fInteger ? 1 : 0) != 0);
                            } else {
                                Assert.assertTrue((String)"Wrong number of steps executed.", (DsfSequenceProgressTests.this.stepCounter.fInteger == steps.length ? 1 : 0) != 0);
                                Assert.assertTrue((String)"Some steps are mistakenly rolled back", (DsfSequenceProgressTests.this.rollBackCounter.fInteger == 0 ? 1 : 0) != 0);
                            }
                            Assert.assertTrue((boolean)sequence.isDone());
                        }
                        catch (AssertionFailedError e2) {
                            DsfSequenceProgressTests.this.fExceptions.add(e2);
                        }
                        throw throwable;
                    }
                }
                return null;
            }
        };
        myJob.schedule();
        DsfSequenceProgressTests.waitForJob(myJob);
        if (this.fExceptions.size() > 0) {
            throw (AssertionFailedError)this.fExceptions.get(0);
        }
    }

    private static void sleep(int seconds, RequestMonitor rm, IProgressMonitor pm) {
        try {
            for (int i = 0; i < seconds; ++i) {
                if (pm != null) {
                    pm.subTask("subStep - " + (i + 1));
                }
                Thread.sleep(1000L);
                if (pm == null) continue;
                pm.worked(1);
                if (!pm.isCanceled()) continue;
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void waitForJob(Job job) {
        IStatus status;
        Display display = Display.getCurrent();
        while ((status = job.getResult()) == null) {
            if (display != null) {
                while (display.readAndDispatch()) {
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                job.cancel();
                break;
            }
        }
    }

    class SleepStepWithProgress
    extends Sequence.StepWithProgress {
        SleepStepWithProgress() {
        }

        public int getTicks() {
            return 12;
        }

        public void execute(RequestMonitor rm, IProgressMonitor pm) {
            ++DsfSequenceProgressTests.this.stepCounter.fInteger;
            pm.beginTask(this.getTaskName() + ": ", 6);
            DsfSequenceProgressTests.sleep(6, rm, pm);
            rm.done();
            pm.done();
        }

        public void rollBack(RequestMonitor rm) {
            ++DsfSequenceProgressTests.this.rollBackCounter.fInteger;
            DsfSequenceProgressTests.sleep(2, null, null);
            rm.done();
        }
    }

    class SleepStep
    extends Sequence.Step {
        SleepStep() {
        }

        public int getTicks() {
            return 3;
        }

        public void execute(RequestMonitor requestMonitor) {
            ++DsfSequenceProgressTests.this.stepCounter.fInteger;
            DsfSequenceProgressTests.sleep(this.getTicks(), null, null);
            requestMonitor.done();
        }

        public void rollBack(RequestMonitor requestMonitor) {
            ++DsfSequenceProgressTests.this.rollBackCounter.fInteger;
            DsfSequenceProgressTests.sleep(1, null, null);
            requestMonitor.done();
        }
    }

    class IntegerHolder {
        int fInteger;

        IntegerHolder() {
        }
    }
}

