/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.SteppingController;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.StepQueueManager;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContainerVMNode
extends AbstractDMVMNode
implements IElementLabelProvider {
    public AbstractContainerVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IRunControl.IContainerDMContext.class);
    }

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    for (ILabelUpdate update : updates) {
                        AbstractContainerVMNode.this.updateLabelInSessionThread(update);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    protected abstract void updateLabelInSessionThread(ILabelUpdate var1);

    public void getContextsForEvent(VMDelta parentDelta, Object e, DataRequestMonitor<IVMContext[]> rm) {
        super.getContextsForEvent(parentDelta, e, rm);
    }

    public int getDeltaFlags(Object e) {
        IDMContext dmc;
        IDMContext iDMContext = dmc = e instanceof IDMEvent ? ((IDMEvent)e).getDMContext() : null;
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            if (((IRunControl.IContainerResumedDMEvent)e).getReason() != IRunControl.StateChangeReason.STEP) {
                return 1024;
            }
        } else {
            if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
                return 0;
            }
            if (e instanceof FullStackRefreshEvent) {
                if (dmc instanceof IRunControl.IContainerDMContext) {
                    return 1024;
                }
            } else if (e instanceof SteppingController.SteppingTimedOutEvent) {
                if (dmc instanceof IRunControl.IContainerDMContext) {
                    return 1024;
                }
            } else if (e instanceof StepQueueManager.ISteppingTimedOutEvent) {
                if (dmc instanceof IRunControl.IContainerDMContext) {
                    return 1024;
                }
            } else {
                if (e instanceof IRunControl.IExitedDMEvent) {
                    return 1024;
                }
                if (e instanceof IRunControl.IStartedDMEvent) {
                    if (dmc instanceof IRunControl.IContainerDMContext) {
                        return 0x300000;
                    }
                    return 1024;
                }
            }
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        IDMContext dmc;
        IDMContext iDMContext = dmc = e instanceof IDMEvent ? ((IDMEvent)e).getDMContext() : null;
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            if (((IRunControl.IContainerResumedDMEvent)e).getReason() != IRunControl.StateChangeReason.STEP) {
                parentDelta.addNode((Object)this.createVMContext(((IDMEvent)e).getDMContext()), 1024);
            }
        } else if (!(e instanceof IRunControl.IContainerSuspendedDMEvent)) {
            if (e instanceof FullStackRefreshEvent) {
                if (dmc instanceof IRunControl.IContainerDMContext) {
                    parentDelta.addNode((Object)this.createVMContext(dmc), 1024);
                }
            } else if (e instanceof SteppingController.SteppingTimedOutEvent) {
                if (dmc instanceof IRunControl.IContainerDMContext) {
                    parentDelta.addNode((Object)this.createVMContext(dmc), 1024);
                }
            } else if (e instanceof StepQueueManager.ISteppingTimedOutEvent) {
                if (dmc instanceof IRunControl.IContainerDMContext) {
                    parentDelta.addNode((Object)this.createVMContext(dmc), 1024);
                }
            } else if (e instanceof IRunControl.IExitedDMEvent) {
                if (dmc instanceof IRunControl.IContainerDMContext) {
                    parentDelta.setFlags(parentDelta.getFlags() | 0x400);
                } else {
                    IRunControl.IContainerDMContext containerCtx = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IContainerDMContext.class);
                    if (containerCtx != null) {
                        parentDelta.addNode((Object)this.createVMContext((IDMContext)containerCtx), 1024);
                    }
                }
            } else if (e instanceof IRunControl.IStartedDMEvent) {
                if (dmc instanceof IRunControl.IContainerDMContext) {
                    parentDelta.addNode((Object)this.createVMContext(dmc), 0x300000);
                } else {
                    IRunControl.IContainerDMContext containerCtx = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IContainerDMContext.class);
                    if (containerCtx != null) {
                        parentDelta.addNode((Object)this.createVMContext((IDMContext)containerCtx), 1024);
                    }
                }
            }
        }
        requestMonitor.done();
    }
}

