/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.SteppingController;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStepQueueManager;
import org.eclipse.dd.dsf.debug.service.StepQueueManager;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.core.commands.IDebugCommandRequest;

@Immutable
public abstract class DsfCommandRunnable
extends DsfRunnable {
    private final IRunControl.IExecutionDMContext fContext;
    private final DsfServicesTracker fTracker;
    private final IDebugCommandRequest fRequest;

    public IRunControl.IExecutionDMContext getContext() {
        return this.fContext;
    }

    public IRunControl getRunControl() {
        return (IRunControl)this.fTracker.getService(IRunControl.class);
    }

    @Deprecated
    public StepQueueManager getStepQueueMgr() {
        return (StepQueueManager)this.fTracker.getService(StepQueueManager.class);
    }

    public IStepQueueManager getStepQueueManager() {
        StepQueueManager mgr = this.getStepQueueMgr();
        if (mgr != null) {
            return mgr;
        }
        return this.getSteppingController();
    }

    public SteppingController getSteppingController() {
        if (this.fContext != null) {
            return (SteppingController)this.fContext.getAdapter(SteppingController.class);
        }
        return null;
    }

    public IProcesses getProcessService() {
        return (IProcesses)this.fTracker.getService(IProcesses.class);
    }

    public DsfCommandRunnable(DsfServicesTracker servicesTracker, Object element, IDebugCommandRequest request) {
        this.fTracker = servicesTracker;
        if (element instanceof IDMVMContext) {
            IDMVMContext vmc = (IDMVMContext)element;
            this.fContext = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)vmc.getDMContext(), IRunControl.IExecutionDMContext.class);
        } else {
            this.fContext = null;
        }
        this.fRequest = request;
    }

    public final void run() {
        if (this.fRequest.isCanceled()) {
            this.fRequest.done();
            return;
        }
        if (this.getContext() == null) {
            this.fRequest.setStatus(this.makeError("Selected object does not support run control.", null));
        } else if (this.getRunControl() == null || this.getStepQueueManager() == null) {
            this.fRequest.setStatus(this.makeError("Run Control not available", null));
        } else {
            this.doExecute();
        }
        this.fRequest.done();
    }

    protected abstract void doExecute();

    protected IStatus makeError(String message, Throwable e) {
        return new Status(4, "org.eclipse.dd.dsf.debug.ui", -1, message, e);
    }
}

