/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.gdb.framework;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class AsyncCompletionWaitor {
    public static final int WAIT_FOREVER = 0;
    private IStatus fStatus;
    private Object fReturnInfo;
    private boolean fWaitFinished;
    private int fNumWaiting;

    public AsyncCompletionWaitor() {
        this.waitReset();
    }

    public synchronized void waitUntilDone(int timeout) throws InterruptedException {
        if (this.fWaitFinished) {
            return;
        }
        this.wait(timeout);
    }

    public void waitFinished() {
        this.waitFinished((IStatus)new Status(0, "org.eclipse.dd.tests.gdb", ""));
    }

    public synchronized void waitFinished(IStatus status) {
        if (this.fWaitFinished) {
            ((MultiStatus)this.fStatus).merge((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "waitFinished called too many times!", null));
        }
        ((MultiStatus)this.fStatus).merge(status);
        if (this.fNumWaiting == 0 || --this.fNumWaiting == 0) {
            this.fWaitFinished = true;
            this.notifyAll();
        }
    }

    public synchronized void waitReset() {
        this.fWaitFinished = false;
        this.fStatus = new MultiStatus("org.eclipse.dd.tests.gdb", 0, "", null);
        this.fReturnInfo = null;
        this.fNumWaiting = 0;
    }

    public boolean isOK() {
        if (this.fStatus == null) {
            return false;
        }
        return this.fStatus.isOK();
    }

    public String getMessage() {
        if (this.fStatus == null) {
            return "Timed out";
        }
        String fullMessage = "";
        IStatus[] children = this.fStatus.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getMessage().length() <= 0) continue;
            fullMessage = fullMessage + "\"" + children[i].getMessage() + "\", ";
        }
        return fullMessage.length() <= 2 ? fullMessage : fullMessage.substring(0, fullMessage.length() - 2);
    }

    public void setReturnInfo(Object info) {
        this.fReturnInfo = info;
    }

    public Object getReturnInfo() {
        return this.fReturnInfo;
    }

    public void increment() {
        ++this.fNumWaiting;
    }
}

