/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.dsf.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.tests.dsf.TestDsfExecutor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DsfQueryTests {
    TestDsfExecutor fExecutor;

    @Before
    public void startServices() throws ExecutionException, InterruptedException {
        this.fExecutor = new TestDsfExecutor();
    }

    @After
    public void shutdownServices() throws ExecutionException, InterruptedException {
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                DsfQueryTests.this.fExecutor.shutdown();
            }
        }).get();
        if (this.fExecutor.exceptionsCaught()) {
            Throwable[] exceptions = this.fExecutor.getExceptions();
            throw new ExecutionException(exceptions[0]);
        }
        this.fExecutor = null;
    }

    @Test
    public void simpleGetTest() throws InterruptedException, ExecutionException {
        Query<Integer> q = new Query<Integer>(){

            protected void execute(DataRequestMonitor<Integer> rm) {
                rm.setData((Object)1);
                rm.done();
            }
        };
        Assert.assertTrue((!q.isDone() ? 1 : 0) != 0);
        Assert.assertTrue((!q.isCancelled() ? 1 : 0) != 0);
        this.fExecutor.execute((Runnable)q);
        Assert.assertEquals((int)1, (int)((Integer)q.get()));
        Assert.assertTrue((boolean)q.isDone());
        Assert.assertTrue((!q.isCancelled() ? 1 : 0) != 0);
    }

    @Test
    public void getWithMultipleDispatchesTest() throws InterruptedException, ExecutionException {
        Query<Integer> q = new Query<Integer>(){

            protected void execute(final DataRequestMonitor<Integer> rm) {
                DsfQueryTests.this.fExecutor.execute((Runnable)new DsfRunnable(){

                    public void run() {
                        rm.setData((Object)1);
                        rm.done();
                    }

                    public String toString() {
                        return super.toString() + "\n       getWithMultipleDispatchesTest() second runnable";
                    }
                });
            }

            public String toString() {
                return super.toString() + "\n       getWithMultipleDispatchesTest() first runnable (query)";
            }
        };
        this.fExecutor.execute((Runnable)q);
        Assert.assertEquals((int)1, (int)((Integer)q.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ExecutionException.class)
    public void exceptionOnGetTest() throws InterruptedException, ExecutionException {
        Query<Integer> q = new Query<Integer>(){

            protected void execute(DataRequestMonitor<Integer> rm) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.tests.dsf", -1, "", null));
                rm.done();
            }
        };
        this.fExecutor.execute((Runnable)q);
        try {
            q.get();
        }
        catch (Throwable throwable) {
            Assert.assertTrue((boolean)q.isDone());
            Assert.assertTrue((!q.isCancelled() ? 1 : 0) != 0);
            throw throwable;
        }
        Assert.assertTrue((boolean)q.isDone());
        Assert.assertTrue((!q.isCancelled() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cancelWhileWaitingTest() throws InterruptedException, ExecutionException {
        Query<Integer> q = new Query<Integer>(){

            protected void execute(final DataRequestMonitor<Integer> rm) {
                DsfQueryTests.this.fExecutor.schedule((Runnable)new DsfRunnable(){

                    public void run() {
                        rm.done();
                    }
                }, 1L, TimeUnit.SECONDS);
            }
        };
        this.fExecutor.execute((Runnable)q);
        new Job("DsfQueryTests cancel job", (Query)q){
            final /* synthetic */ Query val$q;
            {
                this.val$q = query;
                super(x0);
            }

            public IStatus run(IProgressMonitor monitor) {
                this.val$q.cancel(false);
                return Status.OK_STATUS;
            }
        }.schedule(1L);
        try {
            q.get();
        }
        catch (CancellationException e) {
            return;
        }
        finally {
            Assert.assertTrue((boolean)q.isDone());
            Assert.assertTrue((boolean)q.isCancelled());
        }
        Assert.assertTrue((String)"CancellationException should have been thrown", (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cancelBeforeWaitingTest() throws InterruptedException, ExecutionException {
        Query<Integer> q = new Query<Integer>(){

            protected void execute(DataRequestMonitor<Integer> rm) {
                Assert.fail((String)"Query was cancelled, it should not be called.");
                rm.done();
            }
        };
        q.cancel(false);
        Assert.assertTrue((boolean)q.isDone());
        Assert.assertTrue((boolean)q.isCancelled());
        this.fExecutor.execute((Runnable)q);
        try {
            q.get();
        }
        catch (CancellationException e) {
            return;
        }
        finally {
            Assert.assertTrue((boolean)q.isDone());
            Assert.assertTrue((boolean)q.isCancelled());
        }
        Assert.assertTrue((String)"CancellationException should have been thrown", (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getTimeoutTest() throws InterruptedException, ExecutionException {
        Query<Integer> q = new Query<Integer>(){

            protected void execute(final DataRequestMonitor<Integer> rm) {
                DsfQueryTests.this.fExecutor.schedule((Runnable)new DsfRunnable(){

                    public void run() {
                        rm.done();
                    }
                }, 1L, TimeUnit.SECONDS);
            }
        };
        this.fExecutor.execute((Runnable)q);
        try {
            q.get(1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return;
        }
        finally {
            Assert.assertFalse((String)"Query should not be done yet, it should have timed out first.", (boolean)q.isDone());
        }
        Assert.assertTrue((String)"TimeoutException should have been thrown", (boolean)false);
    }
}

