/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.document;

import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.dd.ipxact.editor.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritAbstractionDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritAbstractorDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignConfigurationDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritGeneratorChainDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritGeneratorChangeListDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritLGIDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritPMDDocument;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiritDocumentFactory {
    private static SpiritDocumentFactory factory = null;
    private static HashMap<String, Class<? extends SpiritDocument>> mapV12 = new HashMap<String, Class<? extends SpiritDocument>>(){
        private static final long serialVersionUID = 9204150778277382530L;
        {
            this.put("busDefinition", SpiritBusDefinitionDocument.class);
            this.put("component", SpiritComponentDocument.class);
            this.put("design", SpiritDesignDocument.class);
            this.put("designConfiguration", SpiritDesignConfigurationDocument.class);
            this.put("generatorChain", SpiritGeneratorChainDocument.class);
            this.put("generatorChangeList", SpiritGeneratorChangeListDocument.class);
            this.put("looseGeneratorInvocation", SpiritLGIDocument.class);
            this.put("pmd", SpiritPMDDocument.class);
        }
    };
    private static HashMap<String, Class<? extends SpiritDocument>> mapV14 = new HashMap<String, Class<? extends SpiritDocument>>(){
        private static final long serialVersionUID = -493189717309809768L;
        {
            this.put("busDefinition", SpiritBusDefinitionDocument.class);
            this.put("component", SpiritComponentDocument.class);
            this.put("design", SpiritDesignDocument.class);
            this.put("designConfiguration", SpiritDesignConfigurationDocument.class);
            this.put("generatorChain", SpiritGeneratorChainDocument.class);
            this.put("abstractionDefinition", SpiritAbstractionDefinitionDocument.class);
            this.put("abstractor", SpiritAbstractorDocument.class);
        }
    };
    private DocumentBuilder builder;
    private static HashMap<String, SpiritDocument> documentCache = new HashMap();

    public static SpiritDocumentFactory getFactory() throws ParserConfigurationException {
        if (factory == null) {
            factory = new SpiritDocumentFactory();
        }
        return factory;
    }

    private SpiritDocumentFactory() throws ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        this.builder = builderFactory.newDocumentBuilder();
    }

    public void invalidateFile(String file) {
        documentCache.remove(file);
    }

    public Iterator<?> documentTypes(SchemaInfo.IpxactVersion ipxactVersion) {
        Iterator<String> iterator = null;
        switch (ipxactVersion) {
            case BEFORE_V14: {
                iterator = mapV12.keySet().iterator();
                break;
            }
            case V14: {
                iterator = mapV14.keySet().iterator();
            }
        }
        return iterator;
    }

    public SpiritDocument create(Document xmlDoc) throws Exception {
        SpiritDocument theDoc = null;
        Element e = xmlDoc.getDocumentElement();
        String name = e.getLocalName();
        String namespace = e.getNamespaceURI();
        SchemaInfo.IpxactVersion ipxactVersion = SchemaInfo.getIpxactVersion(namespace);
        if (ipxactVersion == null) {
            return null;
        }
        Class<? extends SpiritDocument> classToCreate = null;
        switch (ipxactVersion) {
            case BEFORE_V14: {
                classToCreate = mapV12.get(name);
                break;
            }
            case V14: {
                classToCreate = mapV14.get(name);
            }
        }
        if (classToCreate == null) {
            throw new Exception(MessageFormat.format(Messages.SpiritDocumentFactory_NotARegisteredDocumentType, name));
        }
        theDoc = this.create(classToCreate, xmlDoc);
        return theDoc;
    }

    public SpiritDocument create(String fileName) throws Exception {
        SpiritDocument result = documentCache.get(fileName);
        if (result == null) {
            Document document = this.builder.parse(fileName);
            result = this.create(document);
            documentCache.put(fileName, result);
        }
        return result;
    }

    public SpiritDocument create(Class<? extends SpiritDocument> classToCreate, Document xmlDoc) throws Exception {
        SpiritDocument theDoc = null;
        if (classToCreate == null) {
            throw new Exception(Messages.SpiritDocumentFactory_DocumentClassCannotBeNull);
        }
        Constructor<? extends SpiritDocument> constructor = classToCreate.getConstructor(Document.class);
        theDoc = constructor.newInstance(xmlDoc);
        return theDoc;
    }
}

