/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.MemoryRange;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ActiveOrMonitorInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.BusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ComponentInstanceNode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.Interconnection;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.MemoryMap;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SignalMapElement;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CheckInterconnections {
    private static boolean checkOneInterfaceAttributes(Element interfaceNode, DocumentChecker checker) {
        SpiritLibrary library = checker.getLibrary();
        ICheckerReporter reporter = checker.getReporter();
        SpiritNode spiritInterfaceNode = SpiritNode.createSpiritNode((Element)interfaceNode);
        String componentRef = spiritInterfaceNode.getSpiritAttribute("componentRef");
        String busRef = spiritInterfaceNode.getSpiritAttribute("busRef");
        SpiritDesignDocument designDocument = (SpiritDesignDocument)checker.getSpiritDocument();
        ComponentInstanceNode componentInstanceNode = designDocument.getComponentInstance(componentRef);
        if (componentInstanceNode == null) {
            reporter.report(CheckList.CHECK_12, (SpiritDocument)designDocument, MessageFormat.format(Messages.CheckInterconnections_4, componentRef), interfaceNode);
            return false;
        }
        SpiritNode vlnvNode = componentInstanceNode.getComponentRef();
        Vlnv componentVlnv = new Vlnv(vlnvNode);
        if (componentVlnv == null) {
            reporter.report(CheckList.CHECK_12, (SpiritDocument)designDocument, MessageFormat.format(Messages.CheckInterconnections_5, componentRef), interfaceNode);
            return false;
        }
        SpiritDocument componentDocument = library.get(componentVlnv);
        if (componentDocument == null || !(componentDocument instanceof SpiritComponentDocument)) {
            reporter.report(CheckList.CHECK_12, (SpiritDocument)designDocument, MessageFormat.format(Messages.CheckInterconnections_6, componentVlnv), interfaceNode);
            return false;
        }
        BusInterface busInterface = ((SpiritComponentDocument)componentDocument).getBusInterface(busRef);
        if (busInterface == null) {
            reporter.report(CheckList.CHECK_12, (SpiritDocument)designDocument, MessageFormat.format(Messages.CheckInterconnections_7, componentVlnv, busRef), interfaceNode);
            return false;
        }
        return true;
    }

    public static int checkInterfaceAttributes(DocumentChecker checker) {
        int index;
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        NodeList activeInterfaces = theDoc.getDescendants("activeInterface");
        NodeList monitorInterfaces = theDoc.getDescendants("monitorInterface");
        for (index = 0; index < activeInterfaces.getLength(); ++index) {
            BusInterface activeBusInterface;
            ActiveOrMonitorInterface activeOrMonitorInterface = new ActiveOrMonitorInterface((Element)activeInterfaces.item(index));
            if (!CheckInterconnections.checkOneInterfaceAttributes((Element)activeInterfaces.item(index), checker)) {
                ++nErrors;
            }
            if (theDoc.schemaVersion() == SchemaInfo.IpxactVersion.BEFORE_V14 || (activeBusInterface = activeOrMonitorInterface.getBusInterface(checker.getLibrary())) == null || !activeBusInterface.isMonitor()) continue;
            checker.getReporter().report(CheckList.CHECK_32, theDoc, MessageFormat.format(Messages.CheckMonitorInterfaces_8, activeBusInterface, "monitor"), (SpiritNode)activeOrMonitorInterface);
            ++nErrors;
        }
        for (index = 0; index < monitorInterfaces.getLength(); ++index) {
            if (CheckInterconnections.checkOneInterfaceAttributes((Element)monitorInterfaces.item(index), checker)) continue;
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkInterfaceCompatibility(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        SpiritLibrary library = checker.getLibrary();
        NodeList nodes = theDoc.getDescendants("interconnection");
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            Interconnection interconnection = new Interconnection((Element)nodes.item(index));
            BusInterface busInterface1 = interconnection.getBusInterface1(library);
            BusInterface busInterface2 = interconnection.getBusInterface2(library);
            if (busInterface1 == null || busInterface2 == null || Utilities.areBusesCompatible(checker, busInterface1.getVlnv(), busInterface2.getVlnv())) continue;
            reporter.report(CheckList.CHECK_13, theDoc, Messages.CheckInterconnections_12, (SpiritNode)interconnection);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkForMissingRequiredConnections(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDesignDocument designDoc = (SpiritDesignDocument)checker.getSpiritDocument();
        NodeList componentInstances = designDoc.getDescendants("componentInstance");
        SpiritLibrary library = checker.getLibrary();
        ICheckerReporter reporter = checker.getReporter();
        LinkedList<ComponentInstanceNode> componentList = new LinkedList<ComponentInstanceNode>();
        HashMap<String, Set<String>> interfaceMap = new HashMap<String, Set<String>>();
        for (int i = 0; i < componentInstances.getLength(); ++i) {
            ComponentInstanceNode component = new ComponentInstanceNode((Element)componentInstances.item(i));
            interfaceMap.put(component.getName(), new HashSet());
            componentList.add(component);
        }
        NodeList activeInterfaces = designDoc.getDescendants("activeInterface");
        CheckInterconnections.populateInterfaceMap(interfaceMap, activeInterfaces);
        NodeList monitorInterfaces = designDoc.getDescendants("monitorInterface");
        CheckInterconnections.populateInterfaceMap(interfaceMap, monitorInterfaces);
        for (ComponentInstanceNode componentInstance : componentList) {
            SpiritNode componentRef = componentInstance.getComponentRef();
            Vlnv vlnv = componentRef.getVlnvAttribute();
            SpiritDocument component = library.get(vlnv);
            if (component == null || !(component instanceof SpiritComponentDocument)) continue;
            List busInterfaces = ((SpiritComponentDocument)component).getBusInterfaces();
            for (BusInterface bi : busInterfaces) {
                String connectionRequired = bi.getUniqueDescendantText("connectionRequired");
                if (!"true".equals(connectionRequired)) continue;
                String busName = bi.getName();
                String componentName = componentInstance.getName();
                Set busList = (Set)interfaceMap.get(componentName);
                if (busList == null || busList.contains(busName)) continue;
                reporter.report(CheckList.CHECK_V14_215, (SpiritDocument)designDoc, MessageFormat.format("Bus interface {0} in component {1} has requiredConnection set but is not connected", busName, componentName), componentRef);
                ++nErrors;
            }
        }
        return nErrors;
    }

    private static void populateInterfaceMap(Map<String, Set<String>> interfaceMap, NodeList interfaces) {
        for (int i = 0; i < interfaces.getLength(); ++i) {
            SpiritNode activeInterface = SpiritNode.createSpiritNode((Element)((Element)interfaces.item(i)));
            Set<String> componentInterfaces = interfaceMap.get(activeInterface.getSpiritAttribute("componentRef"));
            componentInterfaces.add(activeInterface.getSpiritAttribute("busRef"));
        }
    }

    public static int checkInterfaceUniqueness(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        NodeList nodes = theDoc.getDescendants("activeInterface");
        int length = nodes.getLength();
        HashSet<String> set = new HashSet<String>(length);
        for (int index = 0; index < length; ++index) {
            SpiritNode activeInterfaceNode = SpiritNode.createSpiritNode((Element)((Element)nodes.item(index)));
            String componentRef = activeInterfaceNode.getSpiritAttribute("componentRef");
            String busRef = activeInterfaceNode.getSpiritAttribute("busRef");
            String value = componentRef + '/' + busRef;
            if (set.add(value)) continue;
            checker.getReporter().report(CheckList.CHECK_14, theDoc, MessageFormat.format(Messages.CheckInterconnections_16, value), activeInterfaceNode);
            ++nErrors;
        }
        set.clear();
        return nErrors;
    }

    public static int checkInterfacePolarity(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        SpiritLibrary library = checker.getLibrary();
        NodeList nodes = theDoc.getDescendants("interconnection");
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            String systemGroup2;
            String systemGroup1;
            Interconnection interconnection = new Interconnection((Element)nodes.item(index));
            BusInterface busInterface1 = interconnection.getBusInterface1(library);
            BusInterface busInterface2 = interconnection.getBusInterface2(library);
            if (busInterface1 == null || busInterface2 == null) continue;
            String message = MessageFormat.format(Messages.CheckInterconnections_22, busInterface1, busInterface2);
            if (busInterface1.isMaster() && !busInterface2.isMirroredMaster() && !busInterface2.isSlave()) {
                reporter.report(CheckList.CHECK_15, theDoc, message, (SpiritNode)interconnection);
                ++nErrors;
            } else if (busInterface1.isMirroredMaster() && !busInterface2.isMaster()) {
                reporter.report(CheckList.CHECK_16, theDoc, message, (SpiritNode)interconnection);
                ++nErrors;
            } else if (busInterface1.isSlave() && !busInterface2.isMirroredSlave() && !busInterface2.isMaster()) {
                reporter.report(CheckList.CHECK_17, theDoc, message, (SpiritNode)interconnection);
                ++nErrors;
            } else if (busInterface1.isMirroredSlave() && !busInterface2.isSlave()) {
                reporter.report(CheckList.CHECK_18, theDoc, message, (SpiritNode)interconnection);
                ++nErrors;
            } else if (busInterface1.isSystem() && !busInterface2.isMirroredSystem()) {
                reporter.report(CheckList.CHECK_19, theDoc, message, (SpiritNode)interconnection);
                ++nErrors;
            } else if (busInterface1.isMirroredSystem() && !busInterface2.isSystem()) {
                reporter.report(CheckList.CHECK_20, theDoc, message, (SpiritNode)interconnection);
                ++nErrors;
            }
            if ((busInterface1.isMirroredSystem() && busInterface2.isSystem() || busInterface1.isSystem() && busInterface2.isMirroredSystem()) && !(systemGroup1 = busInterface1.getSystemGroup()).equals(systemGroup2 = busInterface2.getSystemGroup())) {
                reporter.report(CheckList.CHECK_24, theDoc, MessageFormat.format(Messages.CheckInterconnections_23, busInterface1, busInterface2), (SpiritNode)interconnection);
                ++nErrors;
            }
            if (!busInterface1.isMonitor() && !busInterface2.isMonitor()) continue;
            reporter.report(CheckList.CHECK_31, theDoc, Messages.CheckInterconnections_24, (SpiritNode)interconnection);
            ++nErrors;
        }
        return nErrors;
    }

    private static Set<Long> getLogicalPortBits(List<SignalMapElement> signalMaps) {
        HashSet<Long> bits = new HashSet<Long>();
        for (SignalMapElement signalMap : signalMaps) {
            long min = Math.min(signalMap.getCalculatedLogicalLeft(), signalMap.getCalculatedLogicalRight());
            long max = Math.max(signalMap.getCalculatedLogicalLeft(), signalMap.getCalculatedLogicalRight());
            for (long i = min; i <= max; ++i) {
                bits.add(i);
            }
        }
        return bits;
    }

    public static int checkDirectConnections(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        SpiritLibrary library = checker.getLibrary();
        NodeList nodes = theDoc.getDescendants("interconnection");
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            Interconnection interconnection = new Interconnection((Element)nodes.item(index));
            if (!interconnection.getMode(library).equals("direct")) continue;
            nErrors += CheckInterconnections.checkDirectConnection(checker, theDoc, library, interconnection);
        }
        return nErrors;
    }

    private static int checkDirectConnection(DocumentChecker checker, SpiritDocument theDoc, SpiritLibrary library, Interconnection interconnection) {
        BusInterface master = interconnection.getPrimaryBusInterface(library);
        BusInterface slave = interconnection.getSecondaryBusInterface(library);
        ICheckerReporter reporter = checker.getReporter();
        SchemaInfo.IpxactVersion ipxactVersion = theDoc.schemaVersion();
        int nErrors = 0;
        nErrors += CheckInterconnections.checkDirectConnectionAddressing(checker, theDoc, interconnection, master, slave);
        String message1 = Messages.CheckInterconnections_43;
        String message2 = "spirit:directConnection is not \"true\" for the busDefinition with VLNV: ";
        Vlnv vlnv = master.getVlnv();
        SpiritDocument busDefinitionDocument = library.get(vlnv);
        if (busDefinitionDocument == null) {
            reporter.report(CheckList.CHECK_23, theDoc, MessageFormat.format(message1, vlnv), (SpiritNode)interconnection);
            return ++nErrors;
        }
        if (!"true".equals(busDefinitionDocument.getUniqueDescendantText("directConnection"))) {
            reporter.report(CheckList.CHECK_23, theDoc, MessageFormat.format(message2, vlnv), (SpiritNode)interconnection);
            ++nErrors;
        }
        if ((busDefinitionDocument = library.get(vlnv = slave.getVlnv())) == null) {
            reporter.report(CheckList.CHECK_23, theDoc, MessageFormat.format(message1, vlnv), (SpiritNode)interconnection);
            return ++nErrors;
        }
        if (!"true".equals(busDefinitionDocument.getUniqueDescendantText("directConnection"))) {
            reporter.report(CheckList.CHECK_23, theDoc, MessageFormat.format(message2, vlnv), (SpiritNode)interconnection);
            ++nErrors;
        }
        if (ipxactVersion != SchemaInfo.IpxactVersion.BEFORE_V14) {
            nErrors += CheckInterconnections.checkConnectedBitsMatch(checker, theDoc, interconnection, master, slave);
            if (!master.getEndianness().equals(slave.getEndianness())) {
                reporter.report(CheckList.CHECK_V14_214, theDoc, MessageFormat.format("The two bus interfaces have different endianess in the direct master to slave interconnection {0}", interconnection.getName()), (SpiritNode)interconnection);
            }
        }
        return nErrors;
    }

    private static int checkConnectedBitsMatch(DocumentChecker checker, SpiritDocument theDoc, Interconnection interconnectionNode, BusInterface master, BusInterface slave) {
        ICheckerReporter reporter = checker.getReporter();
        int nErrors = 0;
        Vlnv abstractionVlnv1 = master.getAbstractionVlnv();
        Vlnv abstractionVlnv2 = slave.getAbstractionVlnv();
        if (abstractionVlnv1 != null && abstractionVlnv2 != null && Utilities.areBusesCompatible(checker, abstractionVlnv1, abstractionVlnv2)) {
            Map signals1 = master.getSignalNamesMultimap();
            Map signals2 = slave.getSignalNamesMultimap();
            if (signals1 != null && signals2 != null) {
                for (Map.Entry signalMapEntry1 : signals1.entrySet()) {
                    Set<Long> bits2;
                    Set<Long> bits1;
                    List signalList2 = (List)signals2.get(signalMapEntry1.getKey());
                    if (signalList2 == null || ((Object)(bits1 = CheckInterconnections.getLogicalPortBits((List)signalMapEntry1.getValue()))).equals(bits2 = CheckInterconnections.getLogicalPortBits(signalList2))) continue;
                    reporter.report(CheckList.CHECK_V14_213, theDoc, MessageFormat.format("The mapped bits for logical port {0} do not match in the direct master to slave interconnection {1}", signalMapEntry1.getKey(), interconnectionNode.getName()), (SpiritNode)interconnectionNode);
                    ++nErrors;
                }
            }
        }
        return nErrors;
    }

    private static int checkDirectConnectionAddressing(DocumentChecker checker, SpiritDocument theDoc, Interconnection interconnectionNode, BusInterface master, BusInterface slave) {
        SpiritComponentDocument masterDocNode;
        SpiritNode addressSpace;
        ICheckerReporter reporter = checker.getReporter();
        SchemaInfo.IpxactVersion ipxactVersion = theDoc.schemaVersion();
        int nErrors = 0;
        SpiritNode addressSpaceNode = null;
        String addressSpaceRef = master.getAddressSpaceRef();
        if (!"".equals(addressSpaceRef) && (addressSpace = (masterDocNode = master.getContainingComponent()).getAddressSpace(addressSpaceRef)) != null) {
            addressSpaceNode = SpiritNode.createSpiritNode((SpiritNode)addressSpace);
        }
        MemoryMap memoryMap = null;
        String memoryMapRef = slave.getMemoryMapRef();
        if (!"".equals(memoryMapRef)) {
            SpiritComponentDocument slaveDocumentNode = new SpiritComponentDocument(slave.getOwnerDocument());
            memoryMap = slaveDocumentNode.getMemoryMap(memoryMapRef);
        }
        String masterBitsInLau = "";
        String slaveBitsInLau = "";
        switch (ipxactVersion) {
            case BEFORE_V14: {
                if (addressSpaceNode == null || memoryMap == null) break;
                masterBitsInLau = addressSpaceNode.getUniqueDescendantText("bitsInLau");
                slaveBitsInLau = SpiritNode.createSpiritNode((SpiritNode)memoryMap).getUniqueDescendantText("bitsInLau");
                break;
            }
            case V14: {
                masterBitsInLau = master.getUniqueDescendantText("bitsInLau");
                slaveBitsInLau = slave.getUniqueDescendantText("bitsInLau");
            }
        }
        int masterBitsInLauValue = 8;
        if (!masterBitsInLau.equals("")) {
            masterBitsInLauValue = Integer.parseInt(masterBitsInLau);
        }
        int slaveBitsInLauValue = 8;
        if (!slaveBitsInLau.equals("")) {
            slaveBitsInLauValue = Integer.parseInt(slaveBitsInLau);
        }
        if (masterBitsInLauValue != slaveBitsInLauValue) {
            reporter.report(CheckList.CHECK_21, theDoc, MessageFormat.format(Messages.CheckInterconnections_37, master, slave), (SpiritNode)interconnectionNode);
            return ++nErrors;
        }
        if (ipxactVersion == SchemaInfo.IpxactVersion.BEFORE_V14 && addressSpaceNode != null && memoryMap != null) {
            try {
                List<MemoryRange> memoryMapRanges;
                MemoryRange memoryMapRange;
                long memoryMapExtent;
                String range = addressSpaceNode.getUniqueDescendantText("range");
                MemoryRange addressSpaceRange = new MemoryRange("0", range);
                long addressSpaceExtent = addressSpaceRange.getExtent();
                if (Long.bitCount(addressSpaceExtent) != 1) {
                    reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckInterconnections_40, master, range), (SpiritNode)interconnectionNode);
                    ++nErrors;
                }
                if ((memoryMapExtent = (memoryMapRange = CheckInterconnections.getParallelExtent(memoryMapRanges = CheckInterconnections.getMemoryMapRange(checker, memoryMap.getNode(), interconnectionNode))).getExtent()) > addressSpaceExtent) {
                    reporter.report(CheckList.CHECK_22, theDoc, MessageFormat.format(Messages.CheckInterconnections_41, master, slave, Long.toHexString(addressSpaceExtent), Long.toHexString(memoryMapExtent)), (SpiritNode)interconnectionNode);
                    ++nErrors;
                }
            }
            catch (NumberFormatException nfe) {
                reporter.report(CheckList.CHECK_22, theDoc, MessageFormat.format(Messages.CheckInterconnections_42, nfe.getMessage()), (SpiritNode)interconnectionNode);
            }
        }
        return nErrors;
    }

    private static List<MemoryRange> getMemoryMapRange(DocumentChecker checker, Element memoryMapNode, Interconnection interconnectionNode) {
        ICheckerReporter reporter = checker.getReporter();
        SpiritComponentDocument componentDocument = new SpiritComponentDocument(memoryMapNode.getOwnerDocument());
        ArrayList<MemoryRange> memoryRanges = new ArrayList<MemoryRange>();
        NodeList addressBlockNodes = SpiritNode.createSpiritNode((Element)memoryMapNode).getDescendants("addressBlock");
        for (int index = 0; index < addressBlockNodes.getLength(); ++index) {
            String range;
            Element e = (Element)addressBlockNodes.item(index);
            SpiritNode spiritNode = SpiritNode.createSpiritNode((Element)e);
            String start = spiritNode.getUniqueDescendantText("baseAddress");
            if ("".equals(start)) {
                start = "0";
            }
            if ("".equals(range = spiritNode.getUniqueDescendantText("range"))) {
                range = "0";
            }
            memoryRanges.add(new MemoryRange(start, range));
        }
        NodeList memoryBankNodes = SpiritNode.createSpiritNode((Element)memoryMapNode).getDescendants("bank");
        for (int index = 0; index < memoryBankNodes.getLength(); ++index) {
            Element e = (Element)memoryBankNodes.item(index);
            SpiritNode spiritNode = SpiritNode.createSpiritNode((Element)e);
            String start = spiritNode.getUniqueDescendantText("baseAddress");
            if ("".equals(start)) {
                start = "0";
            }
            List<MemoryRange> bankRanges = CheckInterconnections.getMemoryMapRange(checker, e, interconnectionNode);
            String bankAlignment = SpiritNode.createSpiritNode((Element)e).getSpiritAttribute("bankAlignment");
            MemoryRange bankRange = "parallel".equals(bankAlignment) ? CheckInterconnections.getParallelExtent(bankRanges) : CheckInterconnections.getSerialExtent(bankRanges);
            memoryRanges.add(bankRange);
        }
        NodeList subspaceMapNodes = SpiritNode.createSpiritNode((Element)memoryMapNode).getDescendants("subspaceMap");
        for (int index = 0; index < subspaceMapNodes.getLength(); ++index) {
            String masterRef;
            BusInterface master;
            Element e = (Element)subspaceMapNodes.item(index);
            SpiritNode spiritNode = SpiritNode.createSpiritNode((Element)e);
            String start = spiritNode.getUniqueDescendantText("baseAddress");
            if ("".equals(start)) {
                start = "0";
            }
            if ((master = componentDocument.getBusInterface(masterRef = spiritNode.getSpiritAttribute("masterRef"))) == null) {
                reporter.report(CheckList.CHECK_22, checker.getSpiritDocument(), MessageFormat.format(Messages.CheckInterconnections_61, SpiritNode.createSpiritNode((Element)memoryMapNode).getName(), masterRef), (SpiritNode)interconnectionNode);
                continue;
            }
            SpiritNode addressSpace = componentDocument.getAddressSpace(master.getAddressSpaceRef());
            if (addressSpace == null) {
                reporter.report(CheckList.CHECK_22, checker.getSpiritDocument(), MessageFormat.format(Messages.CheckInterconnections_62, master, master.getAddressSpaceRef()), (SpiritNode)interconnectionNode);
                continue;
            }
            String range = spiritNode.getUniqueDescendantText("range");
            if ("".equals(range)) {
                range = "0";
            }
            memoryRanges.add(new MemoryRange(start, range));
        }
        return memoryRanges;
    }

    private static MemoryRange getParallelExtent(List<MemoryRange> memoryRanges) {
        int size = memoryRanges.size();
        if (size == 0) {
            return new MemoryRange(0L, 0L);
        }
        MemoryRange memoryRange = memoryRanges.get(0);
        long min = memoryRange.getStart();
        long max = memoryRange.getExtent();
        for (int index = 1; index < size; ++index) {
            memoryRange = memoryRanges.get(index);
            min = Math.min(min, memoryRange.getStart());
            max = Math.max(max, memoryRange.getExtent());
        }
        return new MemoryRange(0L, max - min);
    }

    private static MemoryRange getSerialExtent(List<MemoryRange> memoryRanges) {
        int size = memoryRanges.size();
        if (size == 0) {
            return new MemoryRange(0L, 0L);
        }
        MemoryRange memoryRange = memoryRanges.get(0);
        long start = memoryRange.getStart();
        long range = memoryRange.getExtent();
        for (int index = 1; index < size; ++index) {
            memoryRange = memoryRanges.get(index);
            range += memoryRange.getExtent();
        }
        return new MemoryRange(start, range);
    }
}

