/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.ICachingService;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.CommandCache;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.GdbPlugin;
import org.eclipse.dd.gdb.internal.provisional.service.IGDBBackend;
import org.eclipse.dd.gdb.internal.provisional.service.IGDBProcesses;
import org.eclipse.dd.gdb.internal.provisional.service.command.IGDBControl;
import org.eclipse.dd.mi.service.IMIContainerDMContext;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.mi.service.IMIProcessDMContext;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.dd.mi.service.command.commands.MIListThreadGroups;
import org.eclipse.dd.mi.service.command.commands.MITargetAttach;
import org.eclipse.dd.mi.service.command.commands.MITargetDetach;
import org.eclipse.dd.mi.service.command.commands.MIThreadInfo;
import org.eclipse.dd.mi.service.command.events.MIThreadGroupCreatedEvent;
import org.eclipse.dd.mi.service.command.events.MIThreadGroupExitedEvent;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIListThreadGroupsInfo;
import org.eclipse.dd.mi.service.command.output.MINotifyAsyncOutput;
import org.eclipse.dd.mi.service.command.output.MIOOBRecord;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIThread;
import org.eclipse.dd.mi.service.command.output.MIThreadInfoInfo;
import org.eclipse.dd.mi.service.command.output.MIValue;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBProcesses_7_0
extends AbstractDsfService
implements IGDBProcesses,
ICachingService,
IEventListener {
    private Map<String, String> fThreadToGroupMap = new HashMap<String, String>();
    private IGDBControl fCommandControl;
    private CommandCache fContainerCommandCache;
    private CommandCache fThreadCommandCache;
    private Map<String, String> fProcessNames = new HashMap<String, String>();
    private static final String FAKE_THREAD_ID = "0";

    public GDBProcesses_7_0(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                GDBProcesses_7_0.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fCommandControl = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.fContainerCommandCache = new CommandCache(this.getSession(), (ICommandControl)this.fCommandControl);
        this.fContainerCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.fThreadCommandCache = new CommandCache(this.getSession(), (ICommandControl)this.fCommandControl);
        this.fThreadCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.getSession().addServiceEventListener((Object)this, null);
        this.fCommandControl.addEventListener(this);
        this.register(new String[]{IProcesses.class.getName(), IMIProcesses.class.getName(), IGDBProcesses.class.getName(), GDBProcesses_7_0.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        this.fCommandControl.removeEventListener(this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public IProcesses.IThreadDMContext createThreadContext(IProcesses.IProcessDMContext processDmc, String threadId) {
        return new MIThreadDMC(this.getSession().getId(), processDmc, threadId);
    }

    public IProcesses.IProcessDMContext createProcessContext(ICommandControlService.ICommandControlDMContext controlDmc, String pid) {
        return new MIProcessDMC(this.getSession().getId(), controlDmc, pid);
    }

    public IMIExecutionDMContext createExecutionContext(IRunControl.IContainerDMContext containerDmc, IProcesses.IThreadDMContext threadDmc, String threadId) {
        return new MIExecutionDMC(this.getSession().getId(), containerDmc, threadDmc, threadId);
    }

    public IMIContainerDMContext createContainerContext(IProcesses.IProcessDMContext processDmc, String groupId) {
        return new GDBContainerDMC(this.getSession().getId(), processDmc, groupId);
    }

    public IMIContainerDMContext createContainerContextFromThreadId(ICommandControlService.ICommandControlDMContext controlDmc, String threadId) {
        String groupId = this.fThreadToGroupMap.get(threadId);
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(controlDmc, groupId);
        return this.createContainerContext(processDmc, groupId);
    }

    @Override
    public IMIExecutionDMContext[] getExecutionContexts(IMIContainerDMContext containerDmc) {
        String groupId = containerDmc.getGroupId();
        ArrayList<IMIExecutionDMContext> execDmcList = new ArrayList<IMIExecutionDMContext>();
        for (Map.Entry<String, String> entry : this.fThreadToGroupMap.entrySet()) {
            if (!entry.getValue().equals(groupId)) continue;
            String threadId = entry.getKey();
            IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IProcesses.IProcessDMContext.class);
            IMIExecutionDMContext execDmc = this.createExecutionContext((IRunControl.IContainerDMContext)containerDmc, this.createThreadContext(procDmc, threadId), threadId);
            execDmcList.add(execDmc);
        }
        return execDmcList.toArray(new IMIExecutionDMContext[0]);
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        if (dmc instanceof IProcesses.IThreadDMContext) {
            this.getExecutionData((IProcesses.IThreadDMContext)dmc, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10002, "Invalid DMC type", null));
            rm.done();
        }
    }

    public void getExecutionData(IProcesses.IThreadDMContext dmc, final DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (dmc instanceof IMIProcessDMContext) {
            final String id = ((IMIProcessDMContext)dmc).getProcId();
            String name = this.fProcessNames.get(id);
            if (name == null) {
                ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
                this.fCommandControl.queueCommand((ICommand)new MIListThreadGroups(controlDmc, true), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), rm){

                    protected void handleCompleted() {
                        String name = null;
                        if (this.isSuccess()) {
                            for (MIListThreadGroupsInfo.IThreadGroupInfo groupInfo : ((MIListThreadGroupsInfo)this.getData()).getGroupList()) {
                                GDBProcesses_7_0.this.fProcessNames.put(groupInfo.getPid(), groupInfo.getName());
                                if (!groupInfo.getPid().equals(id)) continue;
                                name = groupInfo.getName();
                            }
                        }
                        if (name == null) {
                            name = "Unknown name";
                        }
                        rm.setData((Object)new MIThreadDMData(name, id));
                        rm.done();
                    }
                });
            } else {
                rm.setData((Object)new MIThreadDMData(name, id));
                rm.done();
            }
        } else if (dmc instanceof MIThreadDMC) {
            final MIThreadDMC threadDmc = (MIThreadDMC)dmc;
            ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
            this.fThreadCommandCache.execute((ICommand)new MIThreadInfo(controlDmc, threadDmc.getId()), (DataRequestMonitor)new DataRequestMonitor<MIThreadInfoInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    MIThread thread;
                    MIThreadDMData threadData = null;
                    if (((MIThreadInfoInfo)this.getData()).getThreadList().length != 0 && (thread = ((MIThreadInfoInfo)this.getData()).getThreadList()[0]).getThreadId().equals(threadDmc.getId())) {
                        threadData = new MIThreadDMData("", thread.getOsId());
                    }
                    if (threadData != null) {
                        rm.setData(threadData);
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10002, "Could not get thread info", null));
                    }
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10002, "Invalid DMC type", null));
            rm.done();
        }
    }

    public void getDebuggingContext(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IDMContext> rm) {
        if (dmc instanceof MIProcessDMC) {
            MIProcessDMC procDmc = (MIProcessDMC)dmc;
            rm.setData((Object)this.createContainerContext((IProcesses.IProcessDMContext)procDmc, procDmc.getProcId()));
        } else if (dmc instanceof MIThreadDMC) {
            MIThreadDMC threadDmc = (MIThreadDMC)dmc;
            IMIProcessDMContext procDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIProcessDMContext.class);
            IMIContainerDMContext containerDmc = this.createContainerContext((IProcesses.IProcessDMContext)procDmc, procDmc.getProcId());
            rm.setData((Object)this.createExecutionContext((IRunControl.IContainerDMContext)containerDmc, threadDmc, threadDmc.getId()));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Invalid thread context.", null));
        }
        rm.done();
    }

    public void isDebuggerAttachSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        if (this.getServicesTracker() == null) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        IGDBBackend backend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        rm.setData((Object)backend.getIsAttachSession());
        rm.done();
    }

    public void attachDebuggerToProcess(final IProcesses.IProcessDMContext procCtx, final DataRequestMonitor<IDMContext> rm) {
        if (procCtx instanceof IMIProcessDMContext) {
            ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)procCtx, ICommandControlService.ICommandControlDMContext.class);
            this.fCommandControl.queueCommand((ICommand)new MITargetAttach(controlDmc, ((IMIProcessDMContext)procCtx).getProcId()), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    IMIContainerDMContext containerDmc = GDBProcesses_7_0.this.createContainerContext(procCtx, ((IMIProcessDMContext)procCtx).getProcId());
                    rm.setData((Object)containerDmc);
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Invalid process context.", null));
            rm.done();
        }
    }

    public void canDetachDebuggerFromProcess(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        if (this.getServicesTracker() == null) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        IGDBBackend backend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        rm.setData((Object)(backend.getIsAttachSession() && this.fCommandControl.isConnected() ? 1 : 0));
        rm.done();
    }

    public void detachDebuggerFromProcess(IDMContext dmc, RequestMonitor rm) {
        ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        IMIProcessDMContext procDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIProcessDMContext.class);
        if (controlDmc != null && procDmc != null) {
            this.fCommandControl.queueCommand((ICommand)new MITargetDetach(controlDmc, procDmc.getProcId()), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Invalid context.", null));
            rm.done();
        }
    }

    public void canTerminate(IProcesses.IThreadDMContext thread, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void isDebugNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void debugNewProcess(IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void getProcessesBeingDebugged(IDMContext dmc, final DataRequestMonitor<IDMContext[]> rm) {
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        final IMIContainerDMContext containerDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class);
        if (containerDmc != null) {
            this.fThreadCommandCache.execute((ICommand)new MIListThreadGroups(controlDmc, containerDmc.getGroupId()), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)GDBProcesses_7_0.this.makeExecutionDMCs((IRunControl.IContainerDMContext)containerDmc, ((MIListThreadGroupsInfo)this.getData()).getThreadInfo().getThreadList()));
                    rm.done();
                }
            });
        } else {
            this.fContainerCommandCache.execute((ICommand)new MIListThreadGroups(controlDmc), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)GDBProcesses_7_0.this.makeContainerDMCs(controlDmc, ((MIListThreadGroupsInfo)this.getData()).getGroupList()));
                    rm.done();
                }
            });
        }
    }

    private IRunControl.IExecutionDMContext[] makeExecutionDMCs(IRunControl.IContainerDMContext containerDmc, MIThread[] threadInfos) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IProcesses.IProcessDMContext.class);
        if (threadInfos.length == 0) {
            return new IMIExecutionDMContext[]{this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, FAKE_THREAD_ID), FAKE_THREAD_ID)};
        }
        IMIExecutionDMContext[] executionDmcs = new IMIExecutionDMContext[threadInfos.length];
        for (int i = 0; i < threadInfos.length; ++i) {
            String threadId = threadInfos[i].getThreadId();
            executionDmcs[i] = this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, threadId), threadId);
        }
        return executionDmcs;
    }

    private IMIContainerDMContext[] makeContainerDMCs(ICommandControlService.ICommandControlDMContext controlDmc, MIListThreadGroupsInfo.IThreadGroupInfo[] groups) {
        IProcesses.IProcessDMContext[] procDmcs = this.makeProcessDMCs(controlDmc, groups);
        IMIContainerDMContext[] containerDmcs = new IMIContainerDMContext[groups.length];
        for (int i = 0; i < procDmcs.length; ++i) {
            String groupId = groups[i].getGroupId();
            IProcesses.IProcessDMContext procDmc = this.createProcessContext(controlDmc, groupId);
            containerDmcs[i] = this.createContainerContext(procDmc, groupId);
        }
        return containerDmcs;
    }

    public void getRunningProcesses(IDMContext dmc, final DataRequestMonitor<IProcesses.IProcessDMContext[]> rm) {
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        if (controlDmc != null) {
            this.fCommandControl.queueCommand((ICommand)new MIListThreadGroups(controlDmc, true), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        for (MIListThreadGroupsInfo.IThreadGroupInfo groupInfo : ((MIListThreadGroupsInfo)this.getData()).getGroupList()) {
                            GDBProcesses_7_0.this.fProcessNames.put(groupInfo.getPid(), groupInfo.getName());
                        }
                        rm.setData((Object)GDBProcesses_7_0.this.makeProcessDMCs(controlDmc, ((MIListThreadGroupsInfo)this.getData()).getGroupList()));
                    } else {
                        rm.setData((Object)new IProcesses.IProcessDMContext[0]);
                    }
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Invalid context.", null));
            rm.done();
        }
    }

    private IProcesses.IProcessDMContext[] makeProcessDMCs(ICommandControlService.ICommandControlDMContext controlDmc, MIListThreadGroupsInfo.IThreadGroupInfo[] processes) {
        IMIProcessDMContext[] procDmcs = new IMIProcessDMContext[processes.length];
        for (int i = 0; i < procDmcs.length; ++i) {
            procDmcs[i] = this.createProcessContext(controlDmc, processes[i].getGroupId());
        }
        return procDmcs;
    }

    public void isRunNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void runNewProcess(IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IProcesses.IProcessDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void terminate(IProcesses.IThreadDMContext thread, RequestMonitor rm) {
        if (thread instanceof IMIProcessDMContext) {
            this.fCommandControl.terminate(rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Invalid process context.", null));
            rm.done();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadGroupCreatedEvent e) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)e.getDMContext();
        IMIContainerDMContext containerDmc = e.getGroupId() != null ? this.createContainerContext(procDmc, e.getGroupId()) : null;
        this.getSession().dispatchEvent((Object)new ContainerStartedDMEvent((IRunControl.IContainerDMContext)containerDmc), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadGroupExitedEvent e) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)e.getDMContext();
        IMIContainerDMContext containerDmc = e.getGroupId() != null ? this.createContainerContext(procDmc, e.getGroupId()) : null;
        this.getSession().dispatchEvent((Object)new ContainerExitedDMEvent((IRunControl.IContainerDMContext)containerDmc), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            this.fContainerCommandCache.setContextAvailable(e.getDMContext(), false);
            this.fThreadCommandCache.setContextAvailable(e.getDMContext(), false);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            this.fContainerCommandCache.setContextAvailable(e.getDMContext(), true);
            this.fThreadCommandCache.setContextAvailable(e.getDMContext(), true);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IStartedDMEvent e) {
        if (e instanceof ContainerStartedDMEvent) {
            this.fCommandControl.setConnected(true);
            this.fContainerCommandCache.reset();
        } else {
            this.fThreadCommandCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        if (e instanceof ContainerExitedDMEvent) {
            this.fCommandControl.setConnected(false);
            this.fContainerCommandCache.reset();
        } else {
            this.fThreadCommandCache.reset();
        }
    }

    public void flushCache(IDMContext context) {
        this.fContainerCommandCache.reset(context);
        this.fThreadCommandCache.reset(context);
    }

    public void eventReceived(Object output) {
        for (MIOOBRecord oobr : ((MIOutput)output).getMIOOBRecords()) {
            if (!(oobr instanceof MINotifyAsyncOutput)) continue;
            MINotifyAsyncOutput exec = (MINotifyAsyncOutput)oobr;
            String miEvent = exec.getAsyncClass();
            if ("thread-created".equals(miEvent) || "thread-exited".equals(miEvent)) {
                String threadId = null;
                String groupId = null;
                MIResult[] results = exec.getMIResults();
                for (int i = 0; i < results.length; ++i) {
                    String var = results[i].getVariable();
                    MIValue val = results[i].getMIValue();
                    if (var.equals("group-id")) {
                        if (!(val instanceof MIConst)) continue;
                        groupId = ((MIConst)val).getString();
                        continue;
                    }
                    if (!var.equals("id") || !(val instanceof MIConst)) continue;
                    threadId = ((MIConst)val).getString();
                }
                if (groupId == null) {
                    groupId = "";
                }
                if ("thread-created".equals(miEvent)) {
                    this.fThreadToGroupMap.put(threadId, groupId);
                    continue;
                }
                this.fThreadToGroupMap.remove(threadId);
                continue;
            }
            if (!"thread-group-created".equals(miEvent) && !"thread-group-exited".equals(miEvent)) continue;
            String groupId = null;
            MIResult[] results = exec.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                MIValue val = results[i].getMIValue();
                if (!var.equals("id") || !(val instanceof MIConst)) continue;
                groupId = ((MIConst)val).getString().trim();
            }
            if (groupId == null || !"thread-group-exited".equals(miEvent) || !this.fThreadToGroupMap.containsValue(groupId)) continue;
            Iterator<Map.Entry<String, String>> iterator = this.fThreadToGroupMap.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getValue().equals(groupId)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContainerExitedDMEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IExitedDMEvent {
        public ContainerExitedDMEvent(IRunControl.IContainerDMContext context) {
            super((IDMContext)context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContainerStartedDMEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IStartedDMEvent {
        public ContainerStartedDMEvent(IRunControl.IContainerDMContext context) {
            super((IDMContext)context);
        }
    }

    @Immutable
    protected static class MIThreadDMData
    implements IProcesses.IThreadDMData {
        final String fName;
        final String fId;

        public MIThreadDMData(String name, String id) {
            this.fName = name;
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isDebuggerAttached() {
            return true;
        }
    }

    @Immutable
    private static class MIProcessDMC
    extends AbstractDMContext
    implements IMIProcessDMContext {
        private final String fId;

        public MIProcessDMC(String sessionId, ICommandControlService.ICommandControlDMContext controlDmc, String id) {
            IDMContext[] iDMContextArray;
            if (controlDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = controlDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        public String getProcId() {
            return this.fId;
        }

        public String toString() {
            return this.baseToString() + ".proc[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && (((MIProcessDMC)((Object)obj)).fId == null ? this.fId == null : ((MIProcessDMC)((Object)obj)).fId.equals(this.fId));
        }

        public int hashCode() {
            return super.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    private static class MIThreadDMC
    extends AbstractDMContext
    implements IProcesses.IThreadDMContext {
        private final String fId;

        public MIThreadDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String id) {
            IDMContext[] iDMContextArray;
            if (processDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = processDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String toString() {
            return this.baseToString() + ".OSthread[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && (((MIThreadDMC)((Object)obj)).fId == null ? this.fId == null : ((MIThreadDMC)((Object)obj)).fId.equals(this.fId));
        }

        public int hashCode() {
            return super.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    private class GDBContainerDMC
    extends MIContainerDMC
    implements IMemory.IMemoryDMContext {
        public GDBContainerDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String groupId) {
            super(sessionId, processDmc, groupId);
        }
    }

    @Immutable
    private static class MIContainerDMC
    extends AbstractDMContext
    implements IMIContainerDMContext {
        private final String fId;

        public MIContainerDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String groupId) {
            IDMContext[] iDMContextArray;
            if (processDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = processDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = groupId;
        }

        public String getGroupId() {
            return this.fId;
        }

        public String toString() {
            return this.baseToString() + ".threadGroup[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && (((MIContainerDMC)((Object)obj)).fId == null ? this.fId == null : ((MIContainerDMC)((Object)obj)).fId.equals(this.fId));
        }

        public int hashCode() {
            return super.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    private static class MIExecutionDMC
    extends AbstractDMContext
    implements IMIExecutionDMContext {
        private final String fThreadId;

        protected MIExecutionDMC(String sessionId, IRunControl.IContainerDMContext containerDmc, IProcesses.IThreadDMContext threadDmc, String threadId) {
            IDMContext[] iDMContextArray;
            if (containerDmc == null && threadDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else if (containerDmc == null) {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = threadDmc;
            } else if (threadDmc == null) {
                IDMContext[] iDMContextArray3 = new IDMContext[1];
                iDMContextArray = iDMContextArray3;
                iDMContextArray3[0] = containerDmc;
            } else {
                IDMContext[] iDMContextArray4 = new IDMContext[2];
                iDMContextArray4[0] = containerDmc;
                iDMContextArray = iDMContextArray4;
                iDMContextArray4[1] = threadDmc;
            }
            super(sessionId, iDMContextArray);
            this.fThreadId = threadId;
        }

        public int getThreadId() {
            try {
                return Integer.parseInt(this.fThreadId);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }

        public String getId() {
            return this.fThreadId;
        }

        public String toString() {
            return this.baseToString() + ".thread[" + this.fThreadId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && ((MIExecutionDMC)((Object)obj)).fThreadId.equals(this.fThreadId);
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.fThreadId.hashCode();
        }
    }
}

