/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.examples.dsf.filebrowser;

import java.io.File;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.examples.dsf.filebrowser.FileVMContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

class FilesystemRootsVMNode
extends AbstractVMNode
implements IElementLabelProvider {
    public FilesystemRootsVMNode(AbstractVMProvider provider) {
        super(provider);
    }

    public String toString() {
        return "FilesystemRootsVMNode";
    }

    public void update(final IChildrenUpdate[] updates) {
        new Job(""){
            {
                super(x0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                File[] files = File.listRoots();
                for (IChildrenUpdate update : updates) {
                    int offset = update.getOffset() != -1 ? update.getOffset() : 0;
                    int length = update.getLength() != -1 ? update.getLength() : files.length;
                    for (int i = offset; i < files.length && i < offset + length; ++i) {
                        update.setChild((Object)new FileVMContext((IVMNode)FilesystemRootsVMNode.this, files[i]), i);
                    }
                    update.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void update(IHasChildrenUpdate[] updates) {
        for (IHasChildrenUpdate update : updates) {
            update.setHasChilren(true);
            update.done();
        }
    }

    public void update(final IChildrenCountUpdate[] updates) {
        new Job(""){
            {
                super(x0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                for (IChildrenCountUpdate update : updates) {
                    if (!FilesystemRootsVMNode.this.checkUpdate((IViewerUpdate)update)) continue;
                    update.setChildCount(File.listRoots().length);
                    update.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void update(final ILabelUpdate[] updates) {
        new Job(""){
            {
                super(x0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                for (ILabelUpdate update : updates) {
                    update.setLabel(FilesystemRootsVMNode.this.getLabel((FileVMContext)((Object)update.getElement())), 0);
                    update.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private String getLabel(FileVMContext vmc) {
        return vmc.getFile().getAbsolutePath();
    }

    public int getDeltaFlags(Object e) {
        int retVal = 0;
        if (e instanceof String) {
            retVal |= 0x300000;
        }
        return retVal;
    }

    public void buildDelta(final Object event, final VMDelta parentDelta, int nodeOffset, final RequestMonitor requestMonitor) {
        if (event instanceof String) {
            new Job(""){
                {
                    super(x0);
                    this.setSystem(true);
                    this.setPriority(10);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    File eventFile = new File((String)event);
                    if (eventFile.exists()) {
                        int index;
                        LinkedList<File> filePath = new LinkedList<File>();
                        for (File file = eventFile; file != null; file = file.getParentFile()) {
                            filePath.add(0, file);
                        }
                        File eventRoot = (File)filePath.get(0);
                        File[] roots = File.listRoots();
                        for (index = 0; index < roots.length && !eventRoot.equals(roots[index]); ++index) {
                        }
                        if (index < roots.length) {
                            VMDelta delta = parentDelta.addNode((Object)new FileVMContext((IVMNode)FilesystemRootsVMNode.this, eventRoot), index, 0);
                            if (eventFile.equals(eventRoot)) {
                                delta.setFlags(delta.getFlags() | 0x200000 | 0x100000);
                            }
                        }
                    }
                    requestMonitor.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            requestMonitor.done();
        }
    }
}

