/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.preferences;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DecoratingStringFieldEditor
extends StringFieldEditor {
    private ControlDecoration fDecoration;

    protected DecoratingStringFieldEditor() {
    }

    public DecoratingStringFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public DecoratingStringFieldEditor(String name, String labelText, int width, Composite parent) {
        super(name, labelText, width, parent);
    }

    public DecoratingStringFieldEditor(String name, String labelText, int width, int strategy, Composite parent) {
        super(name, labelText, width, strategy, parent);
    }

    public Text getTextControl(Composite parent) {
        Text control = super.getTextControl(parent);
        if (this.fDecoration == null) {
            this.fDecoration = new ControlDecoration((Control)control, 16512);
            FieldDecoration errorDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            this.fDecoration.setImage(errorDecoration.getImage());
            this.fDecoration.setDescriptionText(this.getErrorMessage());
            control.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    DecoratingStringFieldEditor.this.refreshValidState();
                }
            });
        }
        return control;
    }

    protected void showErrorMessage(String msg) {
        super.showErrorMessage(msg);
        if (this.fDecoration != null) {
            this.fDecoration.setDescriptionText(msg);
            this.fDecoration.show();
        }
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
        if (this.fDecoration != null) {
            this.fDecoration.hide();
        }
    }
}

