/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritAbstractionDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ComponentWireSignal;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ConstraintSet;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ModeConstraints;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.OnMode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritSignal;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class CheckConstraints {
    public static int checkWireConstraints(DocumentChecker checker) {
        int nErrors = 0;
        SpiritComponentDocument theDoc = (SpiritComponentDocument)checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList wireNodes = theDoc.getDescendants("wire");
        for (int i = 0; i < wireNodes.getLength(); ++i) {
            ComponentWireSignal wireNode = new ComponentWireSignal((Element)wireNodes.item(i));
            String direction = wireNode.getDirection();
            List constraintSets = wireNode.getConstraintSets();
            for (ConstraintSet constraintSet : constraintSets) {
                if (direction.equals("out") && constraintSet.getDriveConstraint() != null) {
                    reporter.report(CheckList.CHECK_INFORMATION, (SpiritDocument)theDoc, Messages.CheckConstraints_V14_141);
                    ++nErrors;
                    continue;
                }
                if (!direction.equals("in") || constraintSet.getLoadConstaint() == null) continue;
                reporter.report(CheckList.CHECK_INFORMATION, (SpiritDocument)theDoc, Messages.CheckConstraints_V14_142);
                ++nErrors;
            }
        }
        return nErrors;
    }

    public static int checkOnMasterSlaveSystemConstraints(DocumentChecker checker) {
        int nErrors = 0;
        SpiritAbstractionDefinitionDocument theDoc = (SpiritAbstractionDefinitionDocument)checker.getSpiritDocument();
        List signals = theDoc.getSignals();
        for (SpiritSignal signal : signals) {
            if (!signal.isWirePort()) continue;
            nErrors += CheckConstraints.checkWirePortConstraints(checker, signal);
        }
        return nErrors;
    }

    private static int checkWirePortConstraints(DocumentChecker checker, SpiritSignal signal) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        List onModeNodes = signal.getOnModeNodes();
        for (OnMode onMode : onModeNodes) {
            String direction = onMode.getDirection();
            ModeConstraints constraints = onMode.getModeConstraints();
            if (constraints != null) {
                if (direction.equals("out") && constraints.getDriveConstraint() != null) {
                    CheckConstraints.reportConstraintError(theDoc, reporter, "out", constraints, "driveConstraint", "modeConstaints");
                    ++nErrors;
                } else if (direction.equals("in") && constraints.getLoadConstraint() != null) {
                    CheckConstraints.reportConstraintError(theDoc, reporter, "in", constraints, "loadConstraint", "modeConstaints");
                    ++nErrors;
                }
            }
            if ((constraints = onMode.getMirroredModeConstraints()) == null) continue;
            if (direction.equals("in") && constraints.getDriveConstraint() != null) {
                CheckConstraints.reportConstraintError(theDoc, reporter, "in", constraints, "driveConstraint", "modeConstaints");
                ++nErrors;
                continue;
            }
            if (!direction.equals("out") || constraints.getLoadConstraint() == null) continue;
            CheckConstraints.reportConstraintError(theDoc, reporter, "out", constraints, "loadConstraint", "modeConstaints");
            ++nErrors;
        }
        return nErrors;
    }

    private static void reportConstraintError(SpiritDocument theDoc, ICheckerReporter reporter, String direction, ModeConstraints constraints, String constraintType, String constraintLocation) {
        reporter.report(CheckList.CHECK_V14_14, theDoc, MessageFormat.format(Messages.CheckConstraints_V14_14X, direction, constraintType, constraintLocation), (SpiritNode)constraints);
    }
}

