/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.CheckVisitor;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;

public class Check63Visitor
extends CheckVisitor {
    private static final String DEFAULT_BIT_STEERING = "off";
    private static final String BIT_STEERING_DEFAULTED = Messages.Check63Visitor_Default;

    public Check63Visitor(ICheckerReporter reporter) {
        super(reporter);
    }

    public boolean visit(HierarchicalConnection hierarchicalConnection) {
        String fromDefaulted = "";
        String bitSteering = hierarchicalConnection.busInterface.getBitSteering();
        if (bitSteering.length() == 0) {
            bitSteering = DEFAULT_BIT_STEERING;
            fromDefaulted = BIT_STEERING_DEFAULTED;
        }
        String toDefaulted = "";
        String refBitSteering = hierarchicalConnection.refBusInterface.getBitSteering();
        if (refBitSteering.length() == 0) {
            refBitSteering = DEFAULT_BIT_STEERING;
            toDefaulted = BIT_STEERING_DEFAULTED;
        }
        String message = Messages.Check63Visitor_0;
        if (!bitSteering.equals(refBitSteering)) {
            this.reporter.report(CheckList.CHECK_63, null, MessageFormat.format(message, fromDefaulted, bitSteering, hierarchicalConnection.busInterface, hierarchicalConnection.busInterfaceDoc.getVlnv(), toDefaulted, refBitSteering, hierarchicalConnection.refBusInterface, hierarchicalConnection.refBusInterfaceDoc.getVlnv()));
            ++this.problems;
        }
        return true;
    }
}

