/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.core.model.ISteppingModeTarget;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.SteppingController;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.actions.DefaultRefreshAllTarget;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.actions.IRefreshAllTarget;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.DefaultDsfModelSelectionPolicyFactory;
import org.eclipse.dd.dsf.debug.ui.actions.DsfResumeCommand;
import org.eclipse.dd.dsf.debug.ui.actions.DsfStepIntoCommand;
import org.eclipse.dd.dsf.debug.ui.actions.DsfStepOverCommand;
import org.eclipse.dd.dsf.debug.ui.actions.DsfStepReturnCommand;
import org.eclipse.dd.dsf.debug.ui.actions.DsfSteppingModeTarget;
import org.eclipse.dd.dsf.debug.ui.actions.DsfSuspendCommand;
import org.eclipse.dd.dsf.debug.ui.contexts.DsfSuspendTrigger;
import org.eclipse.dd.dsf.debug.ui.sourcelookup.DsfSourceDisplayAdapter;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.provisional.actions.IConnect;
import org.eclipse.dd.gdb.internal.provisional.launching.GdbLaunch;
import org.eclipse.dd.gdb.internal.ui.actions.DsfTerminateCommand;
import org.eclipse.dd.gdb.internal.ui.actions.GdbConnectCommand;
import org.eclipse.dd.gdb.internal.ui.actions.GdbDisconnectCommand;
import org.eclipse.dd.gdb.internal.ui.actions.GdbRestartCommand;
import org.eclipse.dd.gdb.internal.ui.viewmodel.GdbViewModelAdapter;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.commands.IDisconnectHandler;
import org.eclipse.debug.core.commands.IResumeHandler;
import org.eclipse.debug.core.commands.IStepIntoHandler;
import org.eclipse.debug.core.commands.IStepOverHandler;
import org.eclipse.debug.core.commands.IStepReturnHandler;
import org.eclipse.debug.core.commands.ISuspendHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicyFactory;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;

@ThreadSafe
public class GdbAdapterFactory
implements IAdapterFactory,
ILaunchesListener2 {
    private static Map<GdbLaunch, SessionAdapterSet> fgLaunchAdapterSets = Collections.synchronizedMap(new HashMap());
    private static Map<ILaunch, SessionAdapterSet> fgDisposedLaunchAdapterSets = new WeakHashMap<ILaunch, SessionAdapterSet>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeAdapterSet(ILaunch launch) {
        Map<GdbLaunch, SessionAdapterSet> map = fgLaunchAdapterSets;
        synchronized (map) {
            if (fgLaunchAdapterSets.containsKey(launch)) {
                fgLaunchAdapterSets.remove(launch).dispose();
                fgDisposedLaunchAdapterSets.put(launch, null);
            }
        }
    }

    public GdbAdapterFactory() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        SessionAdapterSet adapterSet;
        if (!(adaptableObject instanceof GdbLaunch)) {
            return null;
        }
        GdbLaunch launch = (GdbLaunch)adaptableObject;
        DsfSession session = launch.getSession();
        if (session == null) {
            return null;
        }
        Map<GdbLaunch, SessionAdapterSet> map = fgLaunchAdapterSets;
        synchronized (map) {
            if (fgDisposedLaunchAdapterSets.containsKey(launch)) {
                return null;
            }
            adapterSet = fgLaunchAdapterSets.get(launch);
            if (adapterSet == null) {
                adapterSet = new SessionAdapterSet(launch);
                fgLaunchAdapterSets.put(launch, adapterSet);
            }
        }
        if (adapterType.equals(IElementContentProvider.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(IModelProxyFactory.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(IColumnPresentationFactory.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(ISuspendTrigger.class)) {
            return adapterSet.fSuspendTrigger;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IElementContentProvider.class, IModelProxyFactory.class, ISuspendTrigger.class, IColumnPresentationFactory.class};
    }

    public void launchesRemoved(ILaunch[] launches) {
        for (ILaunch launch : launches) {
            if (!(launch instanceof GdbLaunch)) continue;
            GdbAdapterFactory.disposeAdapterSet(launch);
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    @Immutable
    class SessionAdapterSet {
        final GdbLaunch fLaunch;
        final GdbViewModelAdapter fViewModelAdapter;
        final DsfSourceDisplayAdapter fSourceDisplayAdapter;
        final DsfStepIntoCommand fStepIntoCommand;
        final DsfStepOverCommand fStepOverCommand;
        final DsfStepReturnCommand fStepReturnCommand;
        final DsfSuspendCommand fSuspendCommand;
        final DsfResumeCommand fResumeCommand;
        final GdbRestartCommand fRestartCommand;
        final DsfTerminateCommand fTerminateCommand;
        final GdbConnectCommand fConnectCommand;
        final GdbDisconnectCommand fDisconnectCommand;
        final IDebugModelProvider fDebugModelProvider;
        final DsfSuspendTrigger fSuspendTrigger;
        final DsfSteppingModeTarget fSteppingModeTarget;
        final IModelSelectionPolicyFactory fModelSelectionPolicyFactory;
        final SteppingController fSteppingController;
        final DefaultRefreshAllTarget fRefreshAllTarget;

        SessionAdapterSet(GdbLaunch launch) {
            this.fLaunch = launch;
            DsfSession session = launch.getSession();
            this.fSteppingController = new SteppingController(session);
            session.registerModelAdapter(SteppingController.class, (Object)this.fSteppingController);
            this.fViewModelAdapter = new GdbViewModelAdapter(session, this.fSteppingController);
            this.fSourceDisplayAdapter = launch.getSourceLocator() instanceof ISourceLookupDirector ? new DsfSourceDisplayAdapter(session, (ISourceLookupDirector)launch.getSourceLocator(), this.fSteppingController) : null;
            session.registerModelAdapter(ISourceDisplay.class, (Object)this.fSourceDisplayAdapter);
            this.fSteppingModeTarget = new DsfSteppingModeTarget();
            this.fStepIntoCommand = new DsfStepIntoCommand(session, this.fSteppingModeTarget);
            this.fStepOverCommand = new DsfStepOverCommand(session, this.fSteppingModeTarget);
            this.fStepReturnCommand = new DsfStepReturnCommand(session);
            this.fSuspendCommand = new DsfSuspendCommand(session);
            this.fResumeCommand = new DsfResumeCommand(session);
            this.fRestartCommand = new GdbRestartCommand(session, this.fLaunch);
            this.fTerminateCommand = new DsfTerminateCommand(session);
            this.fConnectCommand = new GdbConnectCommand(session);
            this.fDisconnectCommand = new GdbDisconnectCommand(session);
            this.fSuspendTrigger = new DsfSuspendTrigger(session, (ILaunch)this.fLaunch);
            this.fModelSelectionPolicyFactory = new DefaultDsfModelSelectionPolicyFactory();
            this.fRefreshAllTarget = new DefaultRefreshAllTarget();
            session.registerModelAdapter(ISteppingModeTarget.class, (Object)this.fSteppingModeTarget);
            session.registerModelAdapter(IStepIntoHandler.class, (Object)this.fStepIntoCommand);
            session.registerModelAdapter(IStepOverHandler.class, (Object)this.fStepOverCommand);
            session.registerModelAdapter(IStepReturnHandler.class, (Object)this.fStepReturnCommand);
            session.registerModelAdapter(ISuspendHandler.class, (Object)this.fSuspendCommand);
            session.registerModelAdapter(IResumeHandler.class, (Object)this.fResumeCommand);
            session.registerModelAdapter(IRestart.class, (Object)this.fRestartCommand);
            session.registerModelAdapter(ITerminateHandler.class, (Object)this.fTerminateCommand);
            session.registerModelAdapter(IConnect.class, (Object)this.fConnectCommand);
            session.registerModelAdapter(IDisconnectHandler.class, (Object)this.fDisconnectCommand);
            session.registerModelAdapter(IModelSelectionPolicyFactory.class, (Object)this.fModelSelectionPolicyFactory);
            session.registerModelAdapter(IRefreshAllTarget.class, (Object)this.fRefreshAllTarget);
            this.fDebugModelProvider = new IDebugModelProvider(){

                public String[] getModelIdentifiers() {
                    return new String[]{"org.eclipse.dd.gdb"};
                }
            };
            session.registerModelAdapter(IDebugModelProvider.class, (Object)this.fDebugModelProvider);
            session.registerModelAdapter(ILaunch.class, (Object)this.fLaunch);
        }

        void dispose() {
            DsfSession session = this.fLaunch.getSession();
            this.fViewModelAdapter.dispose();
            session.unregisterModelAdapter(ISourceDisplay.class);
            if (this.fSourceDisplayAdapter != null) {
                this.fSourceDisplayAdapter.dispose();
            }
            session.unregisterModelAdapter(SteppingController.class);
            this.fSteppingController.dispose();
            session.unregisterModelAdapter(ISteppingModeTarget.class);
            session.unregisterModelAdapter(IStepIntoHandler.class);
            session.unregisterModelAdapter(IStepOverHandler.class);
            session.unregisterModelAdapter(IStepReturnHandler.class);
            session.unregisterModelAdapter(ISuspendHandler.class);
            session.unregisterModelAdapter(IResumeHandler.class);
            session.unregisterModelAdapter(IRestart.class);
            session.unregisterModelAdapter(ITerminateHandler.class);
            session.unregisterModelAdapter(IConnect.class);
            session.unregisterModelAdapter(IDisconnectHandler.class);
            session.unregisterModelAdapter(IModelSelectionPolicyFactory.class);
            session.unregisterModelAdapter(IRefreshAllTarget.class);
            this.fStepIntoCommand.dispose();
            this.fStepOverCommand.dispose();
            this.fStepReturnCommand.dispose();
            this.fSuspendCommand.dispose();
            this.fResumeCommand.dispose();
            this.fRestartCommand.dispose();
            this.fTerminateCommand.dispose();
            this.fConnectCommand.dispose();
            this.fDisconnectCommand.dispose();
            this.fSuspendTrigger.dispose();
        }
    }
}

