/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.SteppingController;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.ExpandStackEvent;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.IStack2;
import org.eclipse.dd.dsf.debug.service.StepQueueManager;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackFramesVMNode
extends AbstractDMVMNode
implements IElementLabelProvider,
IElementMementoProvider {
    private Map<IRunControl.IExecutionDMContext, Integer> fTemporaryLimits = new HashMap<IRunControl.IExecutionDMContext, Integer>();

    public StackFramesVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IStack.IFrameDMContext.class);
    }

    public String toString() {
        return "StackFramesVMNode(" + this.getSession().getId() + ")";
    }

    protected void updateHasElementsInSessionThread(IHasChildrenUpdate update) {
        IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IRunControl.IExecutionDMContext execCtx = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (runControl == null || execCtx == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        update.setHasChilren(runControl.isSuspended(execCtx) || runControl.isStepping(execCtx));
        update.done();
    }

    protected void updateElementCountInSessionThread(final IChildrenCountUpdate update) {
        IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (stackService == null || execDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        final int stackFrameLimit = this.getStackFrameLimit(execDmc);
        stackService.getStackDepth((IDMContext)execDmc, stackFrameLimit == Integer.MAX_VALUE ? 0 : stackFrameLimit + 1, (DataRequestMonitor)new ViewerDataRequestMonitor<Integer>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    StackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                int stackDepth = (Integer)this.getData();
                if (stackFrameLimit < stackDepth) {
                    stackDepth = stackFrameLimit + 1;
                }
                update.setChildCount(stackDepth);
                update.done();
            }
        });
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        final IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (stackService == null || execDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        final int stackFrameLimit = this.getStackFrameLimit(execDmc);
        final int startIndex = update.getOffset();
        if (startIndex == 0 && update.getLength() == 1) {
            stackService.getTopFrame((IDMContext)execDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IStack.IFrameDMContext>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        StackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    update.setChild((Object)StackFramesVMNode.this.createVMContext((IDMContext)this.getData()), 0);
                    update.done();
                }
            });
        } else if (startIndex >= 0 && update.getLength() > 0 && stackService instanceof IStack2) {
            IStack2 stackService2 = (IStack2)stackService;
            int endIndex = startIndex + update.getLength() - 1;
            if (startIndex < stackFrameLimit && endIndex >= stackFrameLimit) {
                endIndex = stackFrameLimit - 1;
            }
            stackService2.getFrames((IDMContext)execDmc, startIndex, endIndex, (DataRequestMonitor)new ViewerDataRequestMonitor<IStack.IFrameDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        StackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    IStack.IFrameDMContext[] frames = (IStack.IFrameDMContext[])this.getData();
                    StackFramesVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])frames, startIndex);
                    if (startIndex + update.getLength() > stackFrameLimit) {
                        update.setChild((Object)new IncompleteStackVMContext(execDmc, stackFrameLimit), stackFrameLimit);
                    }
                    update.done();
                }
            });
        } else {
            stackService.getFrames((IDMContext)execDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IStack.IFrameDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        StackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    IStack.IFrameDMContext[] frames = (IStack.IFrameDMContext[])this.getData();
                    if (frames.length > stackFrameLimit) {
                        IStack.IFrameDMContext[] tmpFrames = new IStack.IFrameDMContext[stackFrameLimit];
                        System.arraycopy(frames, 0, tmpFrames, 0, stackFrameLimit);
                        frames = tmpFrames;
                        update.setChild((Object)new IncompleteStackVMContext(execDmc, stackFrameLimit), stackFrameLimit);
                    }
                    StackFramesVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])frames);
                    update.done();
                }
            });
        }
    }

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    StackFramesVMNode.this.updateLabelInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
            if (stackService == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                continue;
            }
            if (update.getElement() instanceof IncompleteStackVMContext) {
                update.setLabel("<...more frames...>", 0);
                update.setImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_STACKFRAME"), 0);
                update.done();
                continue;
            }
            final IStack.IFrameDMContext dmc = (IStack.IFrameDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IStack.IFrameDMContext.class);
            if (dmc == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                continue;
            }
            this.getDMVMProvider().getModelData((IVMNode)this, (IViewerUpdate)update, (IDMService)this.getServicesTracker().getService(IStack.class, null), (IDMContext)dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IStack.IFrameDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        StackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    String[] localColumns = update.getColumnIds();
                    if (localColumns == null) {
                        localColumns = new String[]{null};
                    }
                    for (int i = 0; i < localColumns.length; ++i) {
                        StackFramesVMNode.this.fillColumnLabel(dmc, (IStack.IFrameDMData)this.getData(), localColumns[i], i, update);
                    }
                    update.done();
                }
            }, this.getExecutor());
        }
    }

    protected void fillColumnLabel(IStack.IFrameDMContext dmContext, IStack.IFrameDMData dmData, String columnId, int idx, ILabelUpdate update) {
        if (idx != 0) {
            return;
        }
        IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (execDmc == null) {
            return;
        }
        IRunControl runControlService = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        SteppingController stepQueueMgr = (SteppingController)execDmc.getAdapter(SteppingController.class);
        if (runControlService == null || stepQueueMgr == null) {
            return;
        }
        String imageKey = null;
        imageKey = runControlService.isSuspended(execDmc) || runControlService.isStepping(execDmc) && !stepQueueMgr.isSteppingTimedOut(execDmc) ? "IMG_OBJS_STACKFRAME" : "IMG_OBJS_STACKFRAME_RUNNING";
        update.setImageDescriptor(DebugUITools.getImageDescriptor((String)imageKey), 0);
        StringBuilder label = new StringBuilder();
        if (dmData.getFunction() != null && dmData.getFunction().length() != 0) {
            label.append(" ");
            label.append(dmData.getFunction());
            label.append("()");
        }
        if (dmData.getFile() != null && dmData.getFile().length() != 0) {
            label.append(" at ");
            label.append(dmData.getFile());
        }
        if (dmData.getLine() >= 0) {
            label.append(":");
            label.append(dmData.getLine());
            label.append(" ");
        }
        if (dmData.getAddress() != null) {
            label.append("- 0x" + dmData.getAddress().toString(16));
        }
        update.setLabel(label.toString(), 0);
    }

    public void getContextsForEvent(VMDelta parentDelta, Object e, final DataRequestMonitor<IVMContext[]> rm) {
        if (e instanceof ModelProxyInstalledEvent) {
            this.getVMProvider().updateNode((IVMNode)this, (IChildrenUpdate)new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), 0, 1, (DataRequestMonitor)new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

                public void handleCompleted() {
                    if (this.isSuccess() && ((List)this.getData()).size() != 0) {
                        rm.setData((Object)new IVMContext[]{(IVMContext)((List)this.getData()).get(0)});
                    } else {
                        rm.setData((Object)new IVMContext[0]);
                    }
                    rm.done();
                }
            }));
            return;
        }
        super.getContextsForEvent(parentDelta, e, rm);
    }

    public int getDeltaFlags(Object e) {
        String property;
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 0x300400;
        }
        if (e instanceof FullStackRefreshEvent) {
            return 0x100400;
        }
        if (e instanceof SteppingController.SteppingTimedOutEvent) {
            return 1024;
        }
        if (e instanceof StepQueueManager.ISteppingTimedOutEvent) {
            return 1024;
        }
        if (e instanceof ModelProxyInstalledEvent) {
            return 0x300000;
        }
        if (e instanceof ExpandStackEvent) {
            return 1024;
        }
        if (e instanceof IRunControl.IExitedDMEvent) {
            this.clearStackFrameLimit((IRunControl.IExecutionDMContext)((IRunControl.IExitedDMEvent)e).getDMContext());
            return 0;
        }
        if (e instanceof PropertyChangeEvent && ("stackFrameLimitEnable".equals(property = ((PropertyChangeEvent)e).getProperty()) || "stackFrameLimit".equals(property))) {
            return 1024;
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parent, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            IRunControl.IExecutionDMContext triggeringCtx;
            this.clearStackFrameLimit((IRunControl.IExecutionDMContext)((IRunControl.IContainerSuspendedDMEvent)e).getDMContext());
            IRunControl.IContainerSuspendedDMEvent csEvent = (IRunControl.IContainerSuspendedDMEvent)e;
            IRunControl.IExecutionDMContext iExecutionDMContext = triggeringCtx = csEvent.getTriggeringContexts().length != 0 ? csEvent.getTriggeringContexts()[0] : null;
            if (parent.getElement() instanceof IDMVMContext) {
                IRunControl.IExecutionDMContext threadDmc = null;
                threadDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)parent.getElement()).getDMContext(), IRunControl.IExecutionDMContext.class);
                this.buildDeltaForSuspendedEvent(threadDmc, triggeringCtx, parent, nodeOffset, rm);
            } else {
                rm.done();
            }
        } else if (e instanceof FullStackRefreshEvent) {
            IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)((FullStackRefreshEvent)((Object)e)).getDMContext();
            this.buildDeltaForFullStackRefreshEvent(execDmc, execDmc, parent, nodeOffset, rm);
        } else if (e instanceof IRunControl.ISuspendedDMEvent) {
            this.clearStackFrameLimit((IRunControl.IExecutionDMContext)((IRunControl.ISuspendedDMEvent)e).getDMContext());
            IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)((IRunControl.ISuspendedDMEvent)e).getDMContext();
            this.buildDeltaForSuspendedEvent(execDmc, execDmc, parent, nodeOffset, rm);
        } else if (e instanceof SteppingController.SteppingTimedOutEvent) {
            this.buildDeltaForSteppingTimedOutEvent((SteppingController.SteppingTimedOutEvent)((Object)e), parent, nodeOffset, rm);
        } else if (e instanceof StepQueueManager.ISteppingTimedOutEvent) {
            this.buildDeltaForSteppingTimedOutEvent((StepQueueManager.ISteppingTimedOutEvent)e, parent, nodeOffset, rm);
        } else if (e instanceof ModelProxyInstalledEvent) {
            this.buildDeltaForModelProxyInstalledEvent(parent, nodeOffset, rm);
        } else if (e instanceof ExpandStackEvent) {
            IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)((ExpandStackEvent)((Object)e)).getDMContext();
            this.buildDeltaForExpandStackEvent(execDmc, parent, rm);
        } else if (e instanceof PropertyChangeEvent) {
            String property = ((PropertyChangeEvent)e).getProperty();
            if ("stackFrameLimitEnable".equals(property) || "stackFrameLimit".equals(property)) {
                this.buildDeltaForStackFrameLimitPreferenceChangedEvent(parent, rm);
            } else {
                rm.done();
            }
        } else {
            rm.done();
        }
    }

    private void buildDeltaForSuspendedEvent(IRunControl.IExecutionDMContext executionCtx, IRunControl.IExecutionDMContext triggeringCtx, final VMDelta parentDelta, int nodeOffset, final RequestMonitor rm) {
        IRunControl runControlService = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        if (stackService == null || runControlService == null) {
            rm.done();
            return;
        }
        if (executionCtx.equals(triggeringCtx)) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x100000);
            this.getVMProvider().updateNode((IVMNode)this, (IChildrenUpdate)new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), 0, 1, (DataRequestMonitor)new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

                public void handleCompleted() {
                    List data = (List)this.getData();
                    if (data != null && data.size() != 0) {
                        parentDelta.addNode(data.get(0), 0, 0x200800);
                    }
                    rm.done();
                }
            }));
        } else {
            rm.done();
        }
    }

    private void buildDeltaForFullStackRefreshEvent(IRunControl.IExecutionDMContext executionCtx, IRunControl.IExecutionDMContext triggeringCtx, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        IRunControl runControlService = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        if (stackService == null || runControlService == null) {
            rm.done();
            return;
        }
        if (triggeringCtx == null || !runControlService.isStepping(triggeringCtx)) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        rm.done();
    }

    private void buildDeltaForSteppingTimedOutEvent(SteppingController.SteppingTimedOutEvent e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        rm.done();
    }

    private void buildDeltaForSteppingTimedOutEvent(StepQueueManager.ISteppingTimedOutEvent e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        rm.done();
    }

    private void buildDeltaForModelProxyInstalledEvent(final VMDelta parentDelta, int nodeOffset, final RequestMonitor rm) {
        this.getVMProvider().updateNode((IVMNode)this, (IChildrenUpdate)new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, (DataRequestMonitor)new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

            public void handleCompleted() {
                if (this.isSuccess() && ((List)this.getData()).size() != 0) {
                    parentDelta.addNode(((List)this.getData()).get(0), 0, 0x300000);
                }
                rm.done();
            }
        }));
    }

    private void buildDeltaForExpandStackEvent(IRunControl.IExecutionDMContext execDmc, VMDelta parentDelta, RequestMonitor rm) {
        parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        rm.done();
    }

    private void buildDeltaForStackFrameLimitPreferenceChangedEvent(VMDelta parentDelta, RequestMonitor rm) {
        parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        rm.done();
    }

    private String produceFrameElementName(String viewName, IStack.IFrameDMContext frame) {
        if (viewName.startsWith("org.eclipse.debug.ui.VariableView") || viewName.startsWith("org.eclipse.debug.ui.ExpressionView")) {
            return "Frame." + frame.getLevel() + "." + frame.getSessionId();
        }
        return "Frame" + frame.getSessionId();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        for (IElementCompareRequest request : requests) {
            IDMContext dmc;
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            String mementoName = memento.getString("STACK_FRAME_MEMENTO_NAME");
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IStack.IFrameDMContext) {
                String elementName = this.produceFrameElementName(request.getPresentationContext().getId(), (IStack.IFrameDMContext)dmc);
                request.setEqual(elementName.equals(mementoName));
            }
            request.done();
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        for (IElementMementoRequest request : requests) {
            IDMContext dmc;
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IStack.IFrameDMContext) {
                String elementName = this.produceFrameElementName(request.getPresentationContext().getId(), (IStack.IFrameDMContext)dmc);
                memento.putString("STACK_FRAME_MEMENTO_NAME", elementName);
            }
            request.done();
        }
    }

    public int getStackFrameLimit(IRunControl.IExecutionDMContext execCtx) {
        if (this.fTemporaryLimits.containsKey(execCtx)) {
            return this.fTemporaryLimits.get(execCtx);
        }
        Object stackDepthLimit = this.getVMProvider().getPresentationContext().getProperty("stackFrameLimit");
        if (stackDepthLimit instanceof Integer) {
            return (Integer)stackDepthLimit;
        }
        return Integer.MAX_VALUE;
    }

    private void clearStackFrameLimit(IRunControl.IExecutionDMContext execCtx) {
        if (execCtx instanceof IRunControl.IContainerDMContext) {
            Iterator<IRunControl.IExecutionDMContext> itr = this.fTemporaryLimits.keySet().iterator();
            while (itr.hasNext()) {
                IRunControl.IExecutionDMContext limitCtx = itr.next();
                if (!limitCtx.equals(execCtx) && !DMContexts.isAncestorOf((IDMContext)limitCtx, (IDMContext)execCtx)) continue;
                itr.remove();
            }
        } else {
            this.fTemporaryLimits.remove(execCtx);
        }
    }

    public void incrementStackFrameLimit(IRunControl.IExecutionDMContext execCtx) {
        int stackFrameLimit = this.getStackFrameLimit(execCtx);
        if (stackFrameLimit < 0x3FFFFFFF) {
            this.fTemporaryLimits.put(execCtx, stackFrameLimit * 2);
        } else {
            this.fTemporaryLimits.put(execCtx, Integer.MAX_VALUE);
        }
    }

    public class IncompleteStackVMContext
    extends AbstractVMContext {
        private final int fLevel;
        private final IRunControl.IExecutionDMContext fDmc;

        public IncompleteStackVMContext(IRunControl.IExecutionDMContext dmc, int level) {
            super((IVMNode)StackFramesVMNode.this);
            this.fDmc = dmc;
            this.fLevel = level;
        }

        public int getLevel() {
            return this.fLevel;
        }

        public IRunControl.IExecutionDMContext getExecutionDMContext() {
            return this.fDmc;
        }

        public boolean equals(Object obj) {
            return obj instanceof IncompleteStackVMContext && ((IncompleteStackVMContext)((Object)obj)).fDmc.equals(this.fDmc);
        }

        public int hashCode() {
            return this.fDmc.hashCode();
        }
    }
}

