/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.CheckVisitor;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SignalMapElement;

public class Check66Visitor
extends CheckVisitor {
    public Check66Visitor(ICheckerReporter reporter) {
        super(reporter);
    }

    public boolean visit(HierarchicalConnection hierarchicalConnection) {
        Map signalMapElements = hierarchicalConnection.busInterface.getSignalNames();
        Map refSignalNames = hierarchicalConnection.refBusInterface.getSignalNames();
        if (signalMapElements != null && refSignalNames != null) {
            String message = Messages.Check66Visitor_0;
            for (Map.Entry entry : signalMapElements.entrySet()) {
                String busSignalName = (String)entry.getKey();
                SignalMapElement refSignalName = (SignalMapElement)refSignalNames.get(busSignalName);
                if (refSignalName == null) continue;
                Long value = ((SignalMapElement)entry.getValue()).getLeft();
                Long refValue = refSignalName.getLeft();
                if (value == null && refValue != null || value != null && !value.equals(refValue)) {
                    this.reporter.report(CheckList.CHECK_66, null, MessageFormat.format(message, "left", hierarchicalConnection.busInterface, hierarchicalConnection.busInterfaceDoc.getVlnv(), hierarchicalConnection.refBusInterface, hierarchicalConnection.refBusInterfaceDoc.getVlnv(), busSignalName));
                    ++this.problems;
                }
                value = ((SignalMapElement)entry.getValue()).getRight();
                refValue = refSignalName.getRight();
                if ((value != null || refValue == null) && (value == null || value.equals(refValue))) continue;
                this.reporter.report(CheckList.CHECK_66, null, MessageFormat.format(message, "right", hierarchicalConnection.busInterface, hierarchicalConnection.busInterfaceDoc.getVlnv(), hierarchicalConnection.refBusInterface, hierarchicalConnection.refBusInterfaceDoc.getVlnv(), busSignalName));
                ++this.problems;
            }
        }
        return true;
    }
}

