/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.ui.preferences;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.dd.ipxact.checker.ui.Messages;
import org.eclipse.dd.ipxact.checker.ui.preferences.AbstractTableFieldEditor;
import org.eclipse.dd.ipxact.checker.ui.preferences.NewVariableDialog;
import org.eclipse.dd.ipxact.checker.ui.preferences.PreferencesSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FilePathVariableFieldEditor
extends AbstractTableFieldEditor {
    protected FilePathVariableFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.getButton(3).setVisible(false);
        this.getButton(4).setVisible(false);
    }

    public TableColumn[] createTableColumns(Table table) {
        TableColumn[] tableColumns = new TableColumn[2];
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(Messages.FilePathVariableFieldEditor_Variable);
        tableColumns[0] = tableColumn;
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(Messages.FilePathVariableFieldEditor_Value);
        tableColumns[1] = tableColumn;
        return tableColumns;
    }

    protected String[][] parseString(String stringList) {
        String[][] filePathVariables = PreferencesSupport.parseString(stringList);
        if (filePathVariables != null) {
            List list = Arrays.asList(filePathVariables);
            Collections.sort(list, new Comparator<String[]>(){

                @Override
                public int compare(String[] a1, String[] a2) {
                    return a1[0].compareTo(a2[0]);
                }
            });
            filePathVariables = (String[][])list.toArray();
        }
        return filePathVariables;
    }

    protected String createString(String[][] items) {
        return PreferencesSupport.createString(items);
    }

    protected TableItem createNewTableItem(Table table) {
        TableItem tableItem = null;
        NewVariableDialog newVariableDialog = new NewVariableDialog(table.getShell());
        int result = newVariableDialog.open();
        if (result == 0) {
            tableItem = new TableItem(table, 16384);
            tableItem.setText(0, newVariableDialog.getVariableText());
            tableItem.setText(1, newVariableDialog.getValueText());
        }
        return tableItem;
    }

    protected String[] editTableItem(Table table, String[] current) {
        if (current == null || current.length < 2) {
            return null;
        }
        String[] newValues = null;
        NewVariableDialog newVariableDialog = new NewVariableDialog(table.getShell());
        newVariableDialog.setVariableText(current[0]);
        newVariableDialog.setValueText(current[1]);
        int result = newVariableDialog.open();
        if (result == 0) {
            newValues = new String[]{newVariableDialog.getVariableText(), newVariableDialog.getValueText()};
        }
        return newValues;
    }
}

