/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.propertysheet;

import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocumentFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.wst.sse.ui.views.properties.IPropertySourceExtension;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SpiritPropertySource
implements IPropertySource2,
IPropertySourceExtension {
    private IPropertySource basePs;
    private Object target_object;

    public SpiritPropertySource(IPropertySource ps, Object target) {
        this.basePs = ps;
        this.target_object = target;
    }

    public boolean isPropertyResettable(Object id) {
        return ((IPropertySource2)this.basePs).isPropertyResettable(id);
    }

    public boolean isPropertySet(Object id) {
        return this.basePs.isPropertySet(id);
    }

    public Object getEditableValue() {
        return this.basePs.getEditableValue();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] pds = this.basePs.getPropertyDescriptors();
        try {
            Node node;
            Document doc;
            if (this.target_object instanceof Node && (doc = (node = (Node)this.target_object).getOwnerDocument()) != null) {
                SpiritDocument sdoc = SpiritDocumentFactory.getFactory().create(doc);
                for (int i = 0; i < pds.length; ++i) {
                    String name = pds[i].getDisplayName();
                    String attribute = name.substring(name.indexOf(58) + 1);
                    String[] values = sdoc.attributeValueSuggestions(node, attribute);
                    if (values.length == 0) continue;
                    pds[i] = new EnumeratedStringPropertyDescriptor(name, name, values);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pds;
    }

    public Object getPropertyValue(Object id) {
        return this.basePs.getPropertyValue(id);
    }

    public void resetPropertyValue(Object id) {
        this.basePs.resetPropertyValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        this.basePs.setPropertyValue(id, value);
    }

    public boolean isPropertyRemovable(Object name) {
        return ((IPropertySourceExtension)this.basePs).isPropertyRemovable(name);
    }

    public void removeProperty(Object name) {
        ((IPropertySourceExtension)this.basePs).removeProperty(name);
    }

    private class EnumeratedStringPropertyDescriptor
    extends PropertyDescriptor {
        protected StringComboBoxCellEditor fEditor;
        protected Composite fParent;
        protected String[] fValues;

        public EnumeratedStringPropertyDescriptor(Object id, String newDisplayName, String[] valuesArray) {
            super(id, newDisplayName);
            this.fValues = null;
            this.setDescription((String)id);
            this.fValues = valuesArray;
        }

        public CellEditor createPropertyEditor(Composite parent) {
            if (this.fEditor == null || this.fEditor.getControl() == null || this.fEditor.getControl().isDisposed() || parent != this.fParent) {
                this.fEditor = new StringComboBoxCellEditor(parent, this.fValues);
            }
            this.fParent = parent;
            return this.fEditor;
        }
    }

    private class StringComboBoxCellEditor
    extends ComboBoxCellEditor {
        private boolean fSettingValue;

        public StringComboBoxCellEditor(Composite parent, String[] items) {
            super(parent, items);
            this.fSettingValue = false;
        }

        protected Object doGetValue() {
            Object index = super.doGetValue();
            int selection = -1;
            if (index instanceof Integer) {
                selection = (Integer)index;
            }
            if (selection >= 0) {
                return this.getItems()[selection];
            }
            if (this.getControl() instanceof CCombo) {
                return ((CCombo)this.getControl()).getText();
            }
            return null;
        }

        protected void doSetValue(Object value) {
            if (this.fSettingValue) {
                return;
            }
            this.fSettingValue = true;
            if (value instanceof Integer) {
                super.doSetValue(value);
            } else {
                String stringValue = value.toString();
                int selection = -1;
                for (int i = 0; i < this.getItems().length; ++i) {
                    if (!this.getItems()[i].equals(stringValue)) continue;
                    selection = i;
                }
                if (selection >= 0) {
                    super.doSetValue((Object)new Integer(selection));
                } else {
                    super.doSetValue((Object)new Integer(-1));
                    if (this.getControl() instanceof CCombo && !stringValue.equals(((CCombo)this.getControl()).getText())) {
                        ((CCombo)this.getControl()).setText(stringValue);
                    }
                }
            }
            this.fSettingValue = false;
        }

        public void setItems(String[] newItems) {
            if (this.getControl() == null || this.getControl().isDisposed()) {
                return;
            }
            Object previousSelectedValue = this.getValue();
            super.setItems(newItems);
            if (previousSelectedValue != null && this.getControl() instanceof CCombo) {
                for (int i = 0; i < newItems.length; ++i) {
                    if (!newItems[i].equals(previousSelectedValue)) continue;
                    this.setValue(previousSelectedValue);
                }
            }
        }
    }
}

