/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.gdb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.service.ClassAccessor;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.tests.gdb.framework.AsyncCompletionWaitor;
import org.eclipse.dd.tests.gdb.framework.BackgroundRunner;
import org.eclipse.dd.tests.gdb.framework.BaseTestCase;
import org.eclipse.dd.tests.gdb.framework.SyncUtil;
import org.eclipse.dd.tests.gdb.launching.TestsPlugin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=BackgroundRunner.class)
public class ExpressionServiceTest
extends BaseTestCase {
    private DsfSession fSession;
    private DsfServicesTracker fServicesTracker;
    private IExpressions fExpService;
    private int fExprChangedEventCount = 0;
    private IExpressions.IExpressionDMContext fExprChangedCtx = null;
    private IExpressions.IExpressionDMContext globalExpressionCtx1 = null;
    private IExpressions.IExpressionDMContext globalExpressionCtx2 = null;

    @BeforeClass
    public static void beforeClassMethod() {
        ExpressionServiceTest.setLaunchAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "data/launch/bin/ExpressionTestApp.exe");
    }

    @Before
    public void init() {
        this.fSession = this.getGDBLaunch().getSession();
        this.fServicesTracker = new DsfServicesTracker(TestsPlugin.getBundleContext(), this.fSession.getId());
        this.fExpService = (IExpressions)this.fServicesTracker.getService(IExpressions.class);
        this.fSession.addServiceEventListener((Object)this, null);
        this.clearExprChangedData();
    }

    @After
    public void shutdown() {
        this.fSession.removeServiceEventListener((Object)this);
        this.fExpService = null;
        this.fServicesTracker.dispose();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IExpressions.IExpressionChangedDMEvent e) {
        ++this.fExprChangedEventCount;
        this.fExprChangedCtx = (IExpressions.IExpressionDMContext)e.getDMContext();
    }

    private void clearExprChangedData() {
        this.fExprChangedEventCount = 0;
        this.fExprChangedCtx = null;
    }

    private int getExprChangedCount() {
        return this.fExprChangedEventCount;
    }

    private IExpressions.IExpressionDMContext getExprChangedContext() {
        return this.fExprChangedCtx;
    }

    @Test
    public void testLiteralIntegerExpressions() throws Throwable {
        MIStoppedEvent stoppedEvent = SyncUtil.SyncRunToLocation("testLocals");
        HashMap<String, String[]> tests = new HashMap<String, String[]>();
        tests.put("0 + 0 - 0", new String[]{"0x0", "0", "0", "0", "0"});
        tests.put("3 + 4", new String[]{"0x7", "07", "111", "7", "7"});
        tests.put("3 + 4 * 5", new String[]{"0x17", "027", "10111", "23", "23"});
        tests.put("5 * 3 + 4", new String[]{"0x13", "023", "10011", "19", "19"});
        tests.put("5 * (3 + 4)", new String[]{"0x23", "043", "100011", "35", "35"});
        tests.put("10 - 15", new String[]{"0xFFFFFFFB", "037777777773", "11111111111111111111111111111011", "-5", "-5"});
        tests.put("10 + -15", new String[]{"0xFFFFFFFB", "037777777773", "11111111111111111111111111111011", "-5", "-5"});
        this.executeExpressionSubTests(tests, (IDMContext)SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0));
    }

    @Test
    public void testLiteralFloatingPointExpressions() throws Throwable {
        MIStoppedEvent stoppedEvent = SyncUtil.SyncRunToLocation("testLocals");
        HashMap<String, String[]> tests = new HashMap<String, String[]>();
        tests.put("3.1415 + 1.1111", new String[]{"0x4", "04", "100", "4", "4.2526000000000002"});
        tests.put("100.0 / 3.0", new String[]{"0x21", "041", "100001", "33", "33.333333333333336"});
        tests.put("-100.0 / 3.0", new String[]{"0xffffffffffffffdf", "01777777777777777777737", "1111111111111111111111111111111111111111111111111111111111011111", "-33", "-33.333333333333336"});
        tests.put("-100.0 / -3.0", new String[]{"0x21", "041", "100001", "33", "33.333333333333336"});
        tests.put("100.0 / 0.5", new String[]{"0xc8", "0310", "11001000", "200", "200"});
        this.executeExpressionSubTests(tests, (IDMContext)SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0));
    }

    @Test
    public void testLocalVariables() throws Throwable {
        SyncUtil.SyncRunToLocation("testLocals");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 16);
        HashMap<String, String[]> tests1 = new HashMap<String, String[]>();
        tests1.put("lIntVar", new String[]{"0x3039", "030071", "11000000111001", "12345", "12345"});
        tests1.put("lDoubleVar", new String[]{"0x3039", "030071", "11000000111001", "12345", "12345.123449999999"});
        tests1.put("lCharVar", new String[]{"0x6d", "0155", "1101101", "109", "109 'm'"});
        tests1.put("lBoolVar", new String[]{"0x0", "0", "0", "0", "false"});
        tests1.put("lIntArray[1]", new String[]{"0x3039", "030071", "11000000111001", "12345", "12345"});
        tests1.put("lDoubleArray[1]", new String[]{"0x3039", "030071", "11000000111001", "12345", "12345.123449999999"});
        tests1.put("lCharArray[1]", new String[]{"0x6d", "0155", "1101101", "109", "109 'm'"});
        tests1.put("lBoolArray[1]", new String[]{"0x0", "0", "0", "0", "false"});
        tests1.put("*lIntPtr", new String[]{"0x3039", "030071", "11000000111001", "12345", "12345"});
        tests1.put("*lDoublePtr", new String[]{"0x3039", "030071", "11000000111001", "12345", "12345.123449999999"});
        tests1.put("*lCharPtr", new String[]{"0x6d", "0155", "1101101", "109", "109 'm'"});
        tests1.put("*lBoolPtr", new String[]{"0x0", "0", "0", "0", "false"});
        tests1.put("lIntPtr2", new String[]{"0x1", "01", "1", "1", "0x1"});
        tests1.put("lDoublePtr2", new String[]{"0x2345", "021505", "10001101000101", "9029", "0x2345"});
        tests1.put("lBoolPtr2", new String[]{"0x123ABCDE", "02216536336", "10010001110101011110011011110", "305839326", "0x123ABCDE"});
        this.executeExpressionSubTests(tests1, (IDMContext)SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0));
        SyncUtil.SyncStep(IRunControl.StepType.STEP_INTO);
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 5);
        HashMap<String, String[]> tests2 = new HashMap<String, String[]>();
        tests2.put("lIntVar", new String[]{"0x1a85", "015205", "1101010000101", "6789", "6789"});
        tests2.put("lDoubleArray[1]", new String[]{"0x1a85", "015205", "1101010000101", "6789", "6789.6788999999999"});
        tests2.put("lCharVar", new String[]{"0x69", "0151", "1101001", "105", "105 'i'"});
        tests2.put("*lCharPtr", new String[]{"0x69", "0151", "1101001", "105", "105 'i'"});
        tests2.put("lBoolPtr2", new String[]{"0xABCDE123", "025363360443", "10101011110011011110000100100011", "2882396451", "0xABCDE123"});
        this.executeExpressionSubTests(tests2, (IDMContext)SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0));
        this.executeExpressionSubTests(tests1, (IDMContext)SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 1));
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        this.executeExpressionSubTests(tests1, (IDMContext)SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0));
    }

    @Ignore(value="Sublocks do not work with GDB")
    @Test
    public void testSubBlock() throws Throwable {
        SyncUtil.SyncRunToLocation("testSubblock");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 2);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        HashMap<String, Object> tests = new HashMap<String, String[]>();
        tests.put("a", new String[]{"0x8", "010", "1000", "8", "8"});
        tests.put("b", new String[]{"0x1", "01", "1", "1", "1"});
        this.executeExpressionSubTests(tests, (IDMContext)frameDmc);
        SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 2);
        tests = new HashMap();
        tests.put("a", new String[]{"0xc", "014", "1100", "12", "12"});
        tests.put("b", new String[]{"0x1", "01", "1", "1", "1"});
        this.executeExpressionSubTests(tests, (IDMContext)frameDmc);
        SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        tests = new HashMap();
        tests.put("a", new String[]{"0xc", "014", "1100", "12", "12"});
        tests.put("b", new String[]{"0xc", "014", "1100", "12", "12"});
        this.executeExpressionSubTests(tests, (IDMContext)frameDmc);
        SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        tests = new HashMap();
        tests.put("a", new String[]{"0x8", "010", "1000", "8", "8"});
        tests.put("b", new String[]{"0xc", "014", "1100", "12", "12"});
        this.executeExpressionSubTests(tests, (IDMContext)frameDmc);
    }

    @Test
    public void testChildren() throws Throwable {
        MIStoppedEvent stoppedEvent = SyncUtil.SyncRunToLocation("testChildren");
        this.doTestChildren(stoppedEvent);
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        this.doTestChildren(stoppedEvent);
    }

    @Test
    public void testWriteVariable() throws Throwable {
        SyncUtil.SyncRunToLocation("testWrite");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        IExpressions.IExpressionDMContext exprDmc = SyncUtil.SyncCreateExpression((IDMContext)frameDmc, "a[1]");
        this.writeAndCheck(exprDmc, "987", "DECIMAL.Format", "987");
        this.writeAndCheck(exprDmc, "16", "HEX.Format", "22");
        this.writeAndCheck(exprDmc, "0x2e", "HEX.Format", "46");
        this.writeAndCheck(exprDmc, "16", "OCTAL.Format", "14");
        this.writeAndCheck(exprDmc, "022", "OCTAL.Format", "18");
        this.writeAndCheck(exprDmc, "1011", "BINARY.Format", "11");
        this.writeAndCheck(exprDmc, "0b1001", "BINARY.Format", "9");
        this.writeAndCheck(exprDmc, "456", "NATURAL.Format", "456");
    }

    private void writeAndCheck(final IExpressions.IExpressionDMContext exprDmc, final String newValueFormatted, final String format, String newValueInDecimal) throws Throwable {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                ExpressionServiceTest.this.fExpService.writeExpression(exprDmc, newValueFormatted, format, new RequestMonitor((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        wait.waitFinished(this.getStatus());
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        Assert.assertTrue((String)("ExprChangedEvent problem: expected 1, received " + this.getExprChangedCount()), (this.getExprChangedCount() == 1 ? 1 : 0) != 0);
        this.clearExprChangedData();
        wait.waitReset();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "DECIMAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            wait.setReturnInfo(this.getData());
                        }
                        wait.waitFinished(this.getStatus());
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        String actualDecimalValue = ((IFormattedValues.FormattedValueDMData)wait.getReturnInfo()).getFormattedValue();
        Assert.assertTrue((String)("Failed to correctly evaluate '" + exprDmc.getExpression() + "': expected '" + newValueInDecimal + "', got '" + actualDecimalValue + "'"), (boolean)actualDecimalValue.equalsIgnoreCase(newValueInDecimal));
        Assert.assertTrue((String)("ExprChangedEvent problem: expected 0, received " + this.getExprChangedCount()), (this.getExprChangedCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWriteErrorFormat() throws Throwable {
        SyncUtil.SyncRunToLocation("testWrite");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        IExpressions.IExpressionDMContext exprDmc = SyncUtil.SyncCreateExpression((IDMContext)frameDmc, "a[1]");
        this.writeAndCheckError(exprDmc, "goodbye", "DECIMAL.Format");
        this.writeAndCheckError(exprDmc, "abggg", "HEX.Format");
        this.writeAndCheckError(exprDmc, "99", "OCTAL.Format");
        this.writeAndCheckError(exprDmc, "234", "BINARY.Format");
        this.writeAndCheckError(exprDmc, "hello", "NATURAL.Format");
        this.writeAndCheckError(exprDmc, "1", "ThisFormatDoesNotExist");
        IExpressions.IExpressionDMContext notWritableExprDmc = SyncUtil.SyncCreateExpression((IDMContext)frameDmc, "10+5");
        this.writeAndCheckError(notWritableExprDmc, "1", "NATURAL.Format");
    }

    private void writeAndCheckError(final IExpressions.IExpressionDMContext exprDmc, final String invalidValueFormatted, final String format) throws Throwable {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                ExpressionServiceTest.this.fExpService.writeExpression(exprDmc, invalidValueFormatted, format, new RequestMonitor((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        wait.waitFinished(this.getStatus());
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)("Got an OK status for an error test case.  Should not be able to write value " + invalidValueFormatted + " in " + format), (!wait.isOK() ? 1 : 0) != 0);
        Assert.assertTrue((String)("ExprChangedEvent problem: expected 0, received " + this.getExprChangedCount()), (this.getExprChangedCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentReads() throws Throwable {
        SyncUtil.SyncRunToLocation("testConcurrent");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        final IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext exprDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "a[0]");
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("28")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating natural format", null));
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "HEX.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equalsIgnoreCase("0x1c")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating hex format", null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        Assert.assertTrue((String)("ExprChangedEvent problem: expected 0, received " + this.getExprChangedCount()), (this.getExprChangedCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentReadChildren() throws Throwable {
        SyncUtil.SyncRunToLocation("testConcurrent");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        final IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        final IExpressions.IExpressionDMContext addrDmc = SyncUtil.SyncCreateExpression((IDMContext)frameDmc, "&a");
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)addrDmc, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            wait.setReturnInfo(this.getData());
                        }
                        wait.waitFinished(this.getStatus());
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        final String actualAddrStr = ((IFormattedValues.FormattedValueDMData)wait.getReturnInfo()).getFormattedValue();
        wait.waitReset();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext exprDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "a");
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals(actualAddrStr)) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating natural format", null));
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getSubExpressions(exprDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else {
                            IExpressions.IExpressionDMContext[] children = (IExpressions.IExpressionDMContext[])this.getData();
                            int failedIndex = -1;
                            for (int i = 0; i < 2; ++i) {
                                if (children[i].getExpression().equals("a[" + i + "]")) continue;
                                failedIndex = i;
                            }
                            if (failedIndex != -1) {
                                wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting child number: " + failedIndex, null));
                            } else {
                                wait.waitFinished();
                            }
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "HEX.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals(actualAddrStr)) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating hex format", null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        Assert.assertTrue((String)("ExprChangedEvent problem: expected 0, received " + this.getExprChangedCount()), (this.getExprChangedCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentReadChildrenCount() throws Throwable {
        SyncUtil.SyncRunToLocation("testConcurrent");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        final IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        final IExpressions.IExpressionDMContext addrDmc = SyncUtil.SyncCreateExpression((IDMContext)frameDmc, "&a");
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)addrDmc, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            wait.setReturnInfo(this.getData());
                        }
                        wait.waitFinished(this.getStatus());
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        final String actualAddrStr = ((IFormattedValues.FormattedValueDMData)wait.getReturnInfo()).getFormattedValue();
        wait.waitReset();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                wait.increment();
                IExpressions.IExpressionDMContext exprDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "a");
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals(actualAddrStr)) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating natural format", null));
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getSubExpressionCount(exprDmc, (DataRequestMonitor)new DataRequestMonitor<Integer>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else {
                            int count = (Integer)this.getData();
                            if (count != 2) {
                                wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting count for children.  Got" + count + "instead of 2", null));
                            } else {
                                wait.waitFinished();
                            }
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "HEX.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals(actualAddrStr)) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating hex format", null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        Assert.assertTrue((String)("ExprChangedEvent problem: expected 0, received " + this.getExprChangedCount()), (this.getExprChangedCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentReadWrite() throws Throwable {
        SyncUtil.SyncRunToLocation("testConcurrent");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final IExpressions.IExpressionDMContext exprDmc = SyncUtil.SyncCreateExpression((IDMContext)frameDmc, "a[1]");
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("32")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating natural format, got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of 32", null));
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.writeExpression(exprDmc, "56", "NATURAL.Format", new RequestMonitor((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else {
                            wait.waitFinished();
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "HEX.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("0x38")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating hex format, got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of 0x38", null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        Assert.assertTrue((String)("ExprChangedEvent problem: expected 1, received " + this.getExprChangedCount()), (this.getExprChangedCount() == 1 ? 1 : 0) != 0);
        exprDmc.equals(this.getExprChangedContext());
        this.clearExprChangedData();
    }

    @Test
    public void testConcurrentReadWriteChildren() throws Throwable {
        SyncUtil.SyncRunToLocation("testConcurrent");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final IExpressions.IExpressionDMContext exprDmc = SyncUtil.SyncCreateExpression((IDMContext)frameDmc, "a[1]");
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("32")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating natural format, got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of 32", null));
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "HEX.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("0x20")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating hex format, got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of 0x20", null));
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getSubExpressionCount(exprDmc, (DataRequestMonitor)new DataRequestMonitor<Integer>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if ((Integer)this.getData() != 0) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting child count; expecting 0 got " + this.getData(), null));
                        } else {
                            wait.waitFinished();
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getSubExpressions(exprDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 0) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 0 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            wait.waitFinished();
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "OCTAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("040")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating hex format, got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of 040", null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        Assert.assertTrue((String)("ExprChangedEvent problem: expected 0, received " + this.getExprChangedCount()), (this.getExprChangedCount() == 0 ? 1 : 0) != 0);
        exprDmc.equals(this.getExprChangedContext());
        this.clearExprChangedData();
    }

    @Test
    public void testWriteCache() throws Throwable {
        SyncUtil.SyncRunToLocation("testConcurrent");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final IExpressions.IExpressionDMContext exprDmc = SyncUtil.SyncCreateExpression((IDMContext)frameDmc, "a[1]");
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("32")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating natural format, got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of 32", null));
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.writeExpression(exprDmc, "56", "NATURAL.Format", new RequestMonitor((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else {
                            wait.waitFinished();
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "OCTAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("070")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating hex format, got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of 070", null));
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("32")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating natural format, got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of 32", null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("56")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating natural format, got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of 56", null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        Assert.assertTrue((String)("ExprChangedEvent problem: expected 1, received " + this.getExprChangedCount()), (this.getExprChangedCount() == 1 ? 1 : 0) != 0);
        exprDmc.equals(this.getExprChangedContext());
        this.clearExprChangedData();
    }

    @Test
    public void testExprAddress() throws Throwable {
        SyncUtil.SyncRunToLocation("testAddress");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 2);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        IExpressions.IExpressionDMContext exprDmc = SyncUtil.SyncCreateExpression((IDMContext)frameDmc, "a");
        final IExpressions.IExpressionDMContext exprDmc2 = SyncUtil.SyncCreateExpression((IDMContext)frameDmc, "a_ptr");
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc2, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            wait.setReturnInfo(this.getData());
                        }
                        wait.waitFinished(this.getStatus());
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        String actualAddrStr = ((IFormattedValues.FormattedValueDMData)wait.getReturnInfo()).getFormattedValue();
        wait.waitReset();
        this.checkAddressData(exprDmc, actualAddrStr, 4);
        Assert.assertTrue((String)("ExprChangedEvent problem: expected 0, received " + this.getExprChangedCount()), (this.getExprChangedCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGlobalVariables() throws Throwable {
        MIStoppedEvent stoppedEvent = SyncUtil.SyncRunToLocation("locals2");
        HashMap<String, String[]> tests = new HashMap<String, String[]>();
        tests.put("gIntVar", new String[]{"0x21F", "01037", "1000011111", "543", "543"});
        tests.put("gDoubleVar", new String[]{"0x21F", "01037", "1000011111", "543", "543.54300000000001"});
        tests.put("gCharVar", new String[]{"0x67", "0147", "1100111", "103", "103 'g'"});
        tests.put("gBoolVar", new String[]{"0x0", "0", "0", "0", "false"});
        tests.put("gIntArray[1]", new String[]{"0x28E", "01216", "1010001110", "654", "654"});
        tests.put("gDoubleArray[1]", new String[]{"0x28E", "01216", "1010001110", "654", "654.32100000000003"});
        tests.put("gCharArray[1]", new String[]{"0x64", "0144", "1100100", "100", "100 'd'"});
        tests.put("gBoolArray[1]", new String[]{"0x0", "0", "0", "0", "false"});
        tests.put("*gIntPtr", new String[]{"0x21F", "01037", "1000011111", "543", "543"});
        tests.put("*gDoublePtr", new String[]{"0x21F", "01037", "1000011111", "543", "543.54300000000001"});
        tests.put("*gCharPtr", new String[]{"0x67", "0147", "1100111", "103", "103 'g'"});
        tests.put("*gBoolPtr", new String[]{"0x0", "0", "0", "0", "false"});
        tests.put("gIntPtr2", new String[]{"0x8", "010", "1000", "8", "0x8"});
        tests.put("gDoublePtr2", new String[]{"0x5432", "052062", "101010000110010", "21554", "0x5432"});
        tests.put("gBoolPtr2", new String[]{"0x12ABCDEF", "02252746757", "10010101010111100110111101111", "313249263", "0x12ABCDEF"});
        this.executeExpressionSubTests(tests, (IDMContext)SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0));
        this.executeExpressionSubTests(tests, (IDMContext)SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 1));
        this.executeExpressionSubTests(tests, (IDMContext)SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 2));
    }

    @Test
    public void testNamingSameDepth() throws Throwable {
        SyncUtil.SyncRunToLocation("testName1");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        HashMap<String, Object> tests = new HashMap<String, String[]>();
        tests.put("a", new String[]{"0x1", "01", "1", "1", "1"});
        this.executeExpressionSubTests(tests, (IDMContext)frameDmc);
        SyncUtil.SyncRunToLocation("testName2");
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_INTO, 1);
        frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        tests = new HashMap();
        tests.put("a", new String[]{"0x2", "02", "10", "2", "2"});
        this.executeExpressionSubTests(tests, (IDMContext)frameDmc);
        SyncUtil.SyncRunToLocation("testName1");
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_INTO, 1);
        frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        tests = new HashMap();
        tests.put("a", new String[]{"0x3", "03", "11", "3", "3"});
        this.executeExpressionSubTests(tests, (IDMContext)frameDmc);
    }

    @Test
    public void testNamingSameMethod() throws Throwable {
        SyncUtil.SyncRunToLocation("testSameName");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_INTO, 2);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        HashMap<String, Object> tests = new HashMap<String, String[]>();
        tests.put("a", new String[]{"0x1", "01", "1", "1", "1"});
        this.executeExpressionSubTests(tests, (IDMContext)frameDmc);
        SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_INTO, 2);
        frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        tests = new HashMap();
        tests.put("a", new String[]{"0x2", "02", "10", "2", "2"});
        this.executeExpressionSubTests(tests, (IDMContext)frameDmc);
        SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_INTO, 2);
        frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        tests = new HashMap();
        tests.put("a", new String[]{"0x3", "03", "11", "3", "3"});
        this.executeExpressionSubTests(tests, (IDMContext)frameDmc);
    }

    @Test
    public void testThreadContext() throws Throwable {
        SyncUtil.SyncRunToLocation("locals2");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER);
        HashMap<String, Object> tests = new HashMap<String, String[]>();
        tests.put("lIntVar", new String[]{"0x3039", "030071", "11000000111001", "12345", "12345"});
        this.executeExpressionSubTests(tests, (IDMContext)SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 1));
        tests = new HashMap();
        tests.put("lIntVar", new String[]{"0x1a85", "015205", "1101010000101", "6789", "6789"});
        this.executeExpressionSubTests(tests, stoppedEvent.getDMContext());
    }

    @Test
    public void testChildNamingSameMethod() throws Throwable {
        SyncUtil.SyncRunToLocation("testSameName");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_INTO, 4);
        final IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext parentDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "z");
                ExpressionServiceTest.this.fExpService.getSubExpressions(parentDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 2) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 2 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            String valueStr = "1";
                            final IExpressions.IExpressionDMContext child = ((IExpressions.IExpressionDMContext[])this.getData())[0];
                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)child, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("1")) {
                                        wait.waitFinished();
                                    } else {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + child.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "1", null));
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_INTO, 4);
        final IStack.IFrameDMContext frameDmc2 = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext parentDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc2, "z");
                ExpressionServiceTest.this.fExpService.getSubExpressions(parentDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 2) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 2 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            String valueStr = "2";
                            final IExpressions.IExpressionDMContext child = ((IExpressions.IExpressionDMContext[])this.getData())[0];
                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)child, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("2")) {
                                        wait.waitFinished();
                                    } else {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + child.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "2", null));
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_INTO, 4);
        final IStack.IFrameDMContext frameDmc3 = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext parentDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc3, "z");
                ExpressionServiceTest.this.fExpService.getSubExpressions(parentDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 2) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 2 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            String valueStr = "3";
                            final IExpressions.IExpressionDMContext child = ((IExpressions.IExpressionDMContext[])this.getData())[0];
                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)child, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("3")) {
                                        wait.waitFinished();
                                    } else {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + child.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "3", null));
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
    }

    @Test
    public void testUpdatingChildren() throws Throwable {
        SyncUtil.SyncRunToLocation("testUpdateChildren");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 2);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.doUpdateTest(frameDmc, 0);
        SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_INTO, 3);
        IStack.IFrameDMContext frameDmc2 = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.doUpdateTest(frameDmc2, 100);
        SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_INTO, 3);
        IStack.IFrameDMContext frameDmc3 = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.doUpdateTest(frameDmc3, 200);
    }

    public void doUpdateTest(final IStack.IFrameDMContext frameDmc, final int baseValue) throws Throwable {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext parentDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "a");
                ExpressionServiceTest.this.fExpService.getSubExpressions(parentDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 1) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 1 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            ExpressionServiceTest.this.fExpService.getSubExpressions(((IExpressions.IExpressionDMContext[])this.getData())[0], (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    final IExpressions.IExpressionDMContext[] childDmcs = (IExpressions.IExpressionDMContext[])this.getData();
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (childDmcs.length != 2) {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 2 got " + childDmcs.length, null));
                                    } else {
                                        for (int i = 0; i < 2; ++i) {
                                            final String valueStr = Integer.toString(baseValue + i + 10);
                                            final int finali = i;
                                            wait.increment();
                                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)childDmcs[i], "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                                protected void handleCompleted() {
                                                    if (!this.isSuccess()) {
                                                        wait.waitFinished(this.getStatus());
                                                    } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals(valueStr)) {
                                                        wait.waitFinished();
                                                    } else {
                                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + childDmcs[finali].getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + valueStr, null));
                                                    }
                                                }
                                            });
                                        }
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 2);
        final IStack.IFrameDMContext frameDmc2 = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext parentDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc2, "a");
                ExpressionServiceTest.this.fExpService.getSubExpressions(parentDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 1) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 1 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            ExpressionServiceTest.this.fExpService.getSubExpressions(((IExpressions.IExpressionDMContext[])this.getData())[0], (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    final IExpressions.IExpressionDMContext[] childDmcs = (IExpressions.IExpressionDMContext[])this.getData();
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (childDmcs.length != 2) {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 2 got " + childDmcs.length, null));
                                    } else {
                                        for (int i = 0; i < 2; ++i) {
                                            final String valueStr = Integer.toString(baseValue + i + 20);
                                            final int finali = i;
                                            wait.increment();
                                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)childDmcs[i], "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                                protected void handleCompleted() {
                                                    if (!this.isSuccess()) {
                                                        wait.waitFinished(this.getStatus());
                                                    } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals(valueStr)) {
                                                        wait.waitFinished();
                                                    } else {
                                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + childDmcs[finali].getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + valueStr, null));
                                                    }
                                                }
                                            });
                                        }
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
    }

    @Test
    public void testDeleteChildren() throws Throwable {
        SyncUtil.SyncRunToLocation("testDeleteChildren");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        final IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext parentDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "f");
                ExpressionServiceTest.this.fExpService.getSubExpressions(parentDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 5) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 5 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            String childStr = "((bar) f)";
                            if (!((IExpressions.IExpressionDMContext[])this.getData())[0].getExpression().equals(childStr)) {
                                wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Got child " + ((IExpressions.IExpressionDMContext[])this.getData())[0].getExpression() + " instead of " + childStr, null));
                            } else {
                                ExpressionServiceTest.this.fExpService.getSubExpressions(((IExpressions.IExpressionDMContext[])this.getData())[0], (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                    protected void handleCompleted() {
                                        if (!this.isSuccess()) {
                                            wait.waitFinished(this.getStatus());
                                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 2) {
                                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 2 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                                        } else {
                                            String childStr = "((((bar) f)).d)";
                                            if (!((IExpressions.IExpressionDMContext[])this.getData())[0].getExpression().equals(childStr)) {
                                                wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Got child " + ((IExpressions.IExpressionDMContext[])this.getData())[0].getExpression() + " instead of " + childStr, null));
                                            } else {
                                                wait.setReturnInfo(((IExpressions.IExpressionDMContext[])this.getData())[0]);
                                                wait.waitFinished();
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        final IExpressions.IExpressionDMContext deletedChildDmc = (IExpressions.IExpressionDMContext)wait.getReturnInfo();
        wait.waitReset();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                for (int i = 0; i < 1100; ++i) {
                    IExpressions.IExpressionDMContext dmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "a[" + i + "]");
                    wait.increment();
                    ExpressionServiceTest.this.fExpService.getExpressionData(dmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                        protected void handleCompleted() {
                            if (!this.isSuccess()) {
                                wait.waitFinished(this.getStatus());
                            } else {
                                wait.waitFinished();
                            }
                        }
                    });
                }
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                ExpressionServiceTest.this.fExpService.getExpressionData(deletedChildDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else {
                            wait.waitFinished();
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
    }

    @Test
    public void testUpdateGDBBug() throws Throwable {
        SyncUtil.SyncRunToLocation("testUpdateGDBBug");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        final IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext exprDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "a");
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "BINARY.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("1011")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating binary format, expected 1011 but got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        final IStack.IFrameDMContext frameDmc2 = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext exprDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc2, "a");
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "BINARY.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("11")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating binary format, expected 11 but got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
    }

    @Test
    public void testUpdateIssue() throws Throwable {
        SyncUtil.SyncRunToLocation("testUpdateIssue");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        final IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext exprDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "a");
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("1.99")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating a, expected 1.99 but got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), null));
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "HEX.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("0x1")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating a, expected 0x1 but got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        final IStack.IFrameDMContext frameDmc2 = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext exprDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc2, "a");
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("1.22")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating natural format, expected 1.22 but got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
    }

    @Test
    public void testUpdateIssue2() throws Throwable {
        SyncUtil.SyncRunToLocation("testUpdateIssue2");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        final IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext parentDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "z");
                ExpressionServiceTest.this.fExpService.getSubExpressions(parentDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 1) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 1 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            String valueStr = "1";
                            ExpressionServiceTest.this.globalExpressionCtx1 = ((IExpressions.IExpressionDMContext[])this.getData())[0];
                            wait.increment();
                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx1, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("1")) {
                                        wait.waitFinished();
                                    } else {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx1.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "1", null));
                                    }
                                }
                            });
                            wait.increment();
                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx1, "DECIMAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("1")) {
                                        wait.waitFinished();
                                    } else {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx1.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "1", null));
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx1, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("1.22")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating natural format, expected 1.22 but got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
    }

    @Test
    public void testConcurrentReadAndUpdateChild() throws Throwable {
        SyncUtil.SyncRunToLocation("testConcurrentReadAndUpdateChild");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 1);
        final IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext parentDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "z");
                wait.increment();
                ExpressionServiceTest.this.fExpService.getSubExpressions(parentDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 1) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 1 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            String valueStr = "01";
                            ExpressionServiceTest.this.globalExpressionCtx1 = ((IExpressions.IExpressionDMContext[])this.getData())[0];
                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx1, "OCTAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("01")) {
                                        wait.waitFinished();
                                    } else {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx1.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "01", null));
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx1, "BINARY.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        String valueStr = "1";
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("1")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx1.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "1", null));
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx1, "HEX.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        String valueStr = "0x1";
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("0x1")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx1.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "0x1", null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
    }

    @Test(timeout=5000L)
    public void testConcurrentUpdateOutOfScopeChildThenParent() throws Throwable {
        SyncUtil.SyncRunToLocation("testConcurrentUpdateOutOfScopeChildThenParent");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_INTO, 2);
        final IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                ExpressionServiceTest.this.globalExpressionCtx1 = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "z");
                wait.increment();
                ExpressionServiceTest.this.fExpService.getSubExpressions(ExpressionServiceTest.this.globalExpressionCtx1, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 1) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 1 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            String valueStr = "1";
                            ExpressionServiceTest.this.globalExpressionCtx2 = ((IExpressions.IExpressionDMContext[])this.getData())[0];
                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx2, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("1")) {
                                        wait.waitFinished();
                                    } else {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx2.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "1", null));
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_INTO, 2);
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx2, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        String valueStr = "2";
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("2")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx2.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "2", null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx1, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        String valueStr = "{...}";
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("{...}")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx1.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "{...}", null));
                        }
                    }
                });
                wait.increment();
                ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx1, "DECIMAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        String valueStr = "{...}";
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("{...}")) {
                            wait.waitFinished();
                        } else {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx1.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "{...}", null));
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
    }

    @Test
    public void testUpdateOfPointer() throws Throwable {
        SyncUtil.SyncRunToLocation("testUpdateOfPointer");
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 3);
        final IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        String firstValue = "1";
        String secondValue = "2";
        String thirdValue = "3";
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext parentDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "z");
                ExpressionServiceTest.this.fExpService.getSubExpressions(parentDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 2) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 2 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            ExpressionServiceTest.this.globalExpressionCtx1 = ((IExpressions.IExpressionDMContext[])this.getData())[0];
                            ExpressionServiceTest.this.globalExpressionCtx2 = ((IExpressions.IExpressionDMContext[])this.getData())[1];
                            wait.increment();
                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx1, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("1")) {
                                        wait.waitFinished();
                                    } else {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx1.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "1", null));
                                    }
                                }
                            });
                            wait.increment();
                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx2, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else {
                                        wait.setReturnInfo(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                        wait.waitFinished();
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        final String pointerValue = (String)wait.getReturnInfo();
        wait.waitReset();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                ExpressionServiceTest.this.fExpService.getSubExpressions(ExpressionServiceTest.this.globalExpressionCtx2, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 1) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 1 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            ExpressionServiceTest.this.globalExpressionCtx2 = ((IExpressions.IExpressionDMContext[])this.getData())[0];
                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx2, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("1")) {
                                        wait.waitFinished();
                                    } else {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx2.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "1", null));
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER, 2);
        final IStack.IFrameDMContext frameDmc2 = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                IExpressions.IExpressionDMContext parentDmc = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc2, "z");
                ExpressionServiceTest.this.fExpService.getSubExpressions(parentDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 2) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 2 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            ExpressionServiceTest.this.globalExpressionCtx1 = ((IExpressions.IExpressionDMContext[])this.getData())[0];
                            ExpressionServiceTest.this.globalExpressionCtx2 = ((IExpressions.IExpressionDMContext[])this.getData())[1];
                            wait.increment();
                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx1, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("2")) {
                                        wait.waitFinished();
                                    } else {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx1.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "2", null));
                                    }
                                }
                            });
                            wait.increment();
                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx2, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (!((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals(pointerValue)) {
                                        wait.waitFinished();
                                    } else {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx2.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of some other value", null));
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                ExpressionServiceTest.this.fExpService.getSubExpressions(ExpressionServiceTest.this.globalExpressionCtx2, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            wait.waitFinished(this.getStatus());
                        } else if (((IExpressions.IExpressionDMContext[])this.getData()).length != 1) {
                            wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed getting children; expecting 1 got " + ((IExpressions.IExpressionDMContext[])this.getData()).length, null));
                        } else {
                            ExpressionServiceTest.this.globalExpressionCtx2 = ((IExpressions.IExpressionDMContext[])this.getData())[0];
                            ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)ExpressionServiceTest.this.globalExpressionCtx2, "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        wait.waitFinished(this.getStatus());
                                    } else if (((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().equals("3")) {
                                        wait.waitFinished();
                                    } else {
                                        wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed evaluating " + ExpressionServiceTest.this.globalExpressionCtx2.getExpression() + ", got " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + " instead of " + "3", null));
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
    }

    @Test
    public void testCanWrite() throws Throwable {
        MIStoppedEvent stoppedEvent = SyncUtil.SyncRunToLocation("testCanWrite");
        final IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                int exprCount = 5;
                final IExpressions.IExpressionDMContext[] dmcs = new IExpressions.IExpressionDMContext[5];
                final boolean[] expectedValues = new boolean[5];
                int exprIndex = 0;
                dmcs[exprIndex] = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "a");
                expectedValues[exprIndex] = true;
                dmcs[++exprIndex] = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "b");
                expectedValues[exprIndex] = true;
                dmcs[++exprIndex] = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "c");
                expectedValues[exprIndex] = false;
                dmcs[++exprIndex] = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "d");
                expectedValues[exprIndex] = false;
                dmcs[++exprIndex] = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "d[1]");
                expectedValues[exprIndex] = true;
                ++exprIndex;
                int index = 0;
                while (index < 5) {
                    final int finalIndex = index++;
                    wait.increment();
                    ExpressionServiceTest.this.fExpService.canWriteExpression(dmcs[finalIndex], (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                        protected void handleCompleted() {
                            if (!this.isSuccess()) {
                                wait.waitFinished(this.getStatus());
                            } else if ((Boolean)this.getData() == expectedValues[finalIndex]) {
                                wait.waitFinished();
                            } else {
                                wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed establishing proper canWrite for  " + dmcs[finalIndex].getExpression() + ", got " + this.getData() + " instead of " + expectedValues[finalIndex], null));
                            }
                        }
                    });
                }
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
    }

    @Ignore(value="Only works in versions later than GDB6.7")
    @Test
    public void testCanWriteLValue() throws Throwable {
        MIStoppedEvent stoppedEvent = SyncUtil.SyncRunToLocation("testCanWrite");
        final IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                int exprCount = 2;
                final IExpressions.IExpressionDMContext[] dmcs = new IExpressions.IExpressionDMContext[2];
                final boolean[] expectedValues = new boolean[2];
                int exprIndex = 0;
                dmcs[exprIndex] = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "&a");
                expectedValues[exprIndex] = false;
                dmcs[++exprIndex] = ExpressionServiceTest.this.fExpService.createExpression((IDMContext)frameDmc, "1");
                expectedValues[exprIndex] = false;
                ++exprIndex;
                int index = 0;
                while (index < 2) {
                    final int finalIndex = index++;
                    wait.increment();
                    ExpressionServiceTest.this.fExpService.canWriteExpression(dmcs[finalIndex], (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                        protected void handleCompleted() {
                            if (!this.isSuccess()) {
                                wait.waitFinished(this.getStatus());
                            } else if ((Boolean)this.getData() == expectedValues[finalIndex]) {
                                wait.waitFinished();
                            } else {
                                wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Failed establishing proper canWrite for  " + dmcs[finalIndex].getExpression() + ", got " + this.getData() + " instead of " + expectedValues[finalIndex], null));
                            }
                        }
                    });
                }
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
    }

    private void executeExpressionSubTests(final Map<String, String[]> tests, IDMContext dmc) throws Throwable {
        for (final String expressionToEvaluate : tests.keySet()) {
            final IExpressions.IExpressionDMContext exprDMC = SyncUtil.SyncCreateExpression(dmc, expressionToEvaluate);
            final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
            this.fExpService.getExecutor().submit(new Runnable(){

                public void run() {
                    ExpressionServiceTest.this.fExpService.getAvailableFormats((IFormattedValues.IFormattedDataDMContext)exprDMC, (DataRequestMonitor)new DataRequestMonitor<String[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                        protected void handleCompleted() {
                            if (!this.isSuccess()) {
                                wait.waitFinished(this.getStatus());
                            } else {
                                String[] formatIds;
                                for (final String formatId : formatIds = (String[])this.getData()) {
                                    IFormattedValues.FormattedValueDMContext valueDmc = ExpressionServiceTest.this.fExpService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDMC, formatId);
                                    wait.increment();
                                    ExpressionServiceTest.this.fExpService.getFormattedExpressionValue(valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                                        protected void handleCompleted() {
                                            if (!this.isSuccess()) {
                                                wait.waitFinished(this.getStatus());
                                            } else {
                                                String expectedValue;
                                                IFormattedValues.FormattedValueDMData exprValueDMData = (IFormattedValues.FormattedValueDMData)this.getData();
                                                String[] expectedValues = (String[])tests.get(expressionToEvaluate);
                                                String actualValue = exprValueDMData.getFormattedValue();
                                                if (actualValue.equalsIgnoreCase(expectedValue = formatId.equals("HEX.Format") ? expectedValues[0] : (formatId.equals("OCTAL.Format") ? expectedValues[1] : (formatId.equals("BINARY.Format") ? expectedValues[2] : (formatId.equals("DECIMAL.Format") ? expectedValues[3] : (formatId.equals("NATURAL.Format") ? expectedValues[4] : "[Unrecognized format ID: " + formatId + "]")))))) {
                                                    wait.waitFinished();
                                                } else {
                                                    String errorMsg = "Failed to correctly evalutate '" + expressionToEvaluate + "': expected '" + expectedValue + "', got '" + actualValue + "'";
                                                    wait.waitFinished((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", errorMsg, null));
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    });
                }
            });
            wait.waitUntilDone(0);
            Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
            Assert.assertTrue((String)("ExprChangedEvent problem: expected 0, received " + this.getExprChangedCount()), (this.getExprChangedCount() == 0 ? 1 : 0) != 0);
        }
    }

    private boolean addressesEqual(IExpressions.IExpressionDMAddress addrToTest, String addrStr, int size) {
        Object addr = addrStr.length() <= 10 ? new Addr32(addrStr) : new Addr64(addrStr);
        return addrToTest.getAddress().equals(addr) && addrToTest.getSize() == size;
    }

    private void checkAddressData(final IExpressions.IExpressionDMContext dmc, String actualAddrStr, int actualAddrSize) throws Throwable {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                ExpressionServiceTest.this.fExpService.getExpressionAddressData(dmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMAddress>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            wait.setReturnInfo(this.getData());
                        }
                        wait.waitFinished(this.getStatus());
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        IExpressions.IExpressionDMAddress addr = (IExpressions.IExpressionDMAddress)wait.getReturnInfo();
        Assert.assertTrue((String)"Unable to get address", (addr != null ? 1 : 0) != 0);
        if (addr != null) {
            Assert.assertTrue((String)("Received wrong address of " + addr.toString() + " instead of (" + actualAddrStr + ", " + actualAddrSize + ")"), (boolean)this.addressesEqual(addr, actualAddrStr, actualAddrSize));
        }
    }

    private void doTestChildren(MIStoppedEvent stoppedEvent) throws Throwable {
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        IExpressions.IExpressionDMContext exprDMC = SyncUtil.SyncCreateExpression((IDMContext)frameDmc, "f");
        IExpressions.IExpressionDMContext[] children = this.getChildren(exprDMC, new String[]{"bar", "bar2", "a", "b", "c"});
        IExpressions.IExpressionDMContext[] children1 = this.getChildren(children[0], new String[]{"d", "e"});
        this.getChildren(children1[0], new String[0]);
        IExpressions.IExpressionDMContext[] children2 = this.getChildren(children1[1], new String[]{"e[0]", "e[1]"});
        this.getChildren(children2[0], new String[0]);
        this.getChildren(children2[1], new String[0]);
        children1 = this.getChildren(children[1], new String[]{"f", "g"});
        this.getChildren(children1[0], new String[0]);
        children2 = this.getChildren(children1[1], new String[]{"g[0]", "g[1]"});
        this.getChildren(children2[0], new String[0]);
        this.getChildren(children2[1], new String[0]);
        children1 = this.getChildren(children[2], new String[]{"a[0]", "a[1]"});
        this.getChildren(children1[0], new String[0]);
        this.getChildren(children1[1], new String[0]);
        children1 = this.getChildren(children[3], new String[]{"d", "e"});
        this.getChildren(children1[0], new String[0]);
        children2 = this.getChildren(children1[1], new String[]{"e[0]", "e[1]"});
        this.getChildren(children2[0], new String[0]);
        this.getChildren(children2[1], new String[0]);
        this.getChildren(children[4], new String[0]);
        Assert.assertTrue((String)("ExprChangedEvent problem: expected 0, received " + this.getExprChangedCount()), (this.getExprChangedCount() == 0 ? 1 : 0) != 0);
    }

    private IExpressions.IExpressionDMContext[] getChildren(final IExpressions.IExpressionDMContext parentDmc, String[] expectedValues) throws Throwable {
        int i;
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        this.fExpService.getExecutor().submit(new Runnable(){

            public void run() {
                ExpressionServiceTest.this.fExpService.getSubExpressions(parentDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)ExpressionServiceTest.this.fExpService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            wait.setReturnInfo(this.getData());
                        }
                        wait.waitFinished(this.getStatus());
                    }
                });
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        IExpressions.IExpressionDMContext[] childDmcs = (IExpressions.IExpressionDMContext[])wait.getReturnInfo();
        Object[] childExpressions = new String[childDmcs.length];
        ClassAccessor.MIExpressionDMCAccessor[] childDmcsAccessor = new ClassAccessor.MIExpressionDMCAccessor[childDmcs.length];
        for (i = 0; i < childExpressions.length; ++i) {
            childDmcsAccessor[i] = new ClassAccessor.MIExpressionDMCAccessor(childDmcs[i]);
            childExpressions[i] = childDmcsAccessor[i].getRelativeExpression();
        }
        Assert.assertTrue((String)("Expected " + Arrays.toString(expectedValues) + " but got " + Arrays.toString(childExpressions)), (expectedValues.length == childExpressions.length ? 1 : 0) != 0);
        for (i = 0; i < childDmcsAccessor.length; ++i) {
            Assert.assertTrue((String)("Expected: " + expectedValues[i] + " got: " + childDmcsAccessor[i].getRelativeExpression()), (boolean)childDmcsAccessor[i].getRelativeExpression().equals(expectedValues[i]));
        }
        return childDmcs;
    }
}

