/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.util.List;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritAbstractionDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritAbstractorDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.BusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class CheckAbstractions {
    public static int checkBusTypeConsistency_114(DocumentChecker checker) {
        int nErrors = 0;
        SpiritComponentDocument theDoc = (SpiritComponentDocument)checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        List busInterfaces = theDoc.getBusInterfaces();
        for (BusInterface busInterface : busInterfaces) {
            Vlnv busType = busInterface.getVlnv();
            Vlnv abstractionVlnv = busInterface.getAbstractionVlnv();
            if (abstractionVlnv == null) continue;
            try {
                SpiritAbstractionDefinitionDocument absDoc = (SpiritAbstractionDefinitionDocument)checker.getLibrary().get(abstractionVlnv);
                Vlnv abstractionBusType = new Vlnv(absDoc.getBusType());
                if (abstractionBusType.equals((Object)busType)) continue;
                reporter.report(CheckList.CHECK_V14_111, (SpiritDocument)theDoc, Messages.CheckAbstractions_V14_114, (SpiritNode)busInterface);
                ++nErrors;
            }
            catch (Exception e) {}
        }
        return nErrors;
    }

    public static int checkBusTypeConsistency_323(DocumentChecker checker) {
        int nErrors = 0;
        SpiritAbstractorDocument abstractorDoc = (SpiritAbstractorDocument)checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        SpiritNode busTypeNode = abstractorDoc.getBusType();
        Vlnv theDocBusTypeVlnv = busTypeNode.getVlnvAttribute();
        NodeList abstractionTypes = abstractorDoc.getDescendants("abstractionType");
        for (int i = 0; i < abstractionTypes.getLength(); ++i) {
            SpiritNode abstractionTypeNode = SpiritNode.createSpiritNode((Element)((Element)abstractionTypes.item(i)));
            try {
                SpiritAbstractionDefinitionDocument abstractionDocument = (SpiritAbstractionDefinitionDocument)checker.getLinkedDocument(abstractionTypeNode);
                SpiritNode abstractionDefinitionElement = abstractionDocument.getBusType();
                Vlnv abstractionDefinitionBusType = abstractionDefinitionElement.getVlnvAttribute();
                if (abstractionDefinitionBusType.equals((Object)theDocBusTypeVlnv)) continue;
                reporter.report(CheckList.CHECK_V14_317, (SpiritDocument)abstractorDoc, Messages.CheckList_V14_317, abstractorDoc.getBaseDocument());
                ++nErrors;
                continue;
            }
            catch (Exception e) {
                checker.getReporter().report(CheckList.CHECK_2, (SpiritDocument)abstractorDoc, e.getMessage(), abstractionTypes.item(1));
                ++nErrors;
            }
        }
        return nErrors;
    }
}

