/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.gdb.framework;

import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceEventWaitor<V> {
    public static final int WAIT_FOREVER = 0;
    private Class<V> fEventTypeClass;
    private DsfSession fSession;
    private V fEvent;

    public ServiceEventWaitor(DsfSession session) {
        this.fSession = session;
    }

    public ServiceEventWaitor(DsfSession session, Class<V> eventClass) {
        this(session);
        this.registerForEvent(eventClass);
    }

    public void registerForEvent(Class<V> eventClass) {
        this.fEventTypeClass = eventClass;
        this.fEvent = null;
        this.fSession.addServiceEventListener((Object)this, null);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.fEventTypeClass != null) {
            this.fSession.removeServiceEventListener((Object)this);
        }
    }

    public synchronized V waitForEvent(int timeout) throws Exception {
        if (this.fEventTypeClass == null) {
            throw new Exception("Event to wait for has not been specified!");
        }
        if (this.fEvent != null) {
            return this.fEvent;
        }
        this.wait(timeout);
        if (this.fEvent == null) {
            throw new Exception("Timed out waiting for ServiceEvent: " + this.fEventTypeClass.getName());
        }
        return this.fEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DsfServiceEventHandler
    public void eventDispatched(V event) {
        if (this.fEventTypeClass.isAssignableFrom(event.getClass())) {
            ServiceEventWaitor serviceEventWaitor = this;
            synchronized (serviceEventWaitor) {
                this.fEvent = event;
                this.notifyAll();
            }
        }
    }
}

