/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.gdb.launching;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.dd.gdb.internal.provisional.launching.FinalLaunchSequence;
import org.eclipse.dd.gdb.internal.provisional.launching.GdbLaunch;
import org.eclipse.dd.gdb.internal.provisional.launching.LaunchUtils;
import org.eclipse.dd.gdb.internal.provisional.launching.ServicesLaunchSequence;
import org.eclipse.dd.gdb.internal.provisional.service.GdbDebugServicesFactory;
import org.eclipse.dd.gdb.internal.provisional.service.SessionType;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

@ThreadSafe
public class TestLaunchDelegate
extends LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate2 {
    public static final String GDB_DEBUG_MODEL_ID = "org.eclipse.dd.tests.gdb";

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("debug")) {
            this.launchDebugger(config, launch, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchDebugger(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Launching debugger session", 10);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            if (debugMode.equals("run")) {
                this.launchLocalDebugSession(config, launch, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void launchLocalDebugSession(ILaunchConfiguration config, ILaunch l, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        GdbLaunch launch = (GdbLaunch)l;
        monitor.subTask("DSF GDB/MI reference JUnit tests");
        Path exePath = new Path(TestLaunchDelegate.getProgramName(config));
        this.verifyBinary((IPath)exePath);
        monitor.worked(1);
        launch.setServiceFactory((IDsfDebugServicesFactory)new GdbDebugServicesFactory(LaunchUtils.getGDBVersion((ILaunchConfiguration)config)));
        SubProgressMonitor subMon1 = new SubProgressMonitor(monitor, 4, 4);
        ServicesLaunchSequence servicesLaunchSequence = new ServicesLaunchSequence(launch.getSession(), launch, (IProgressMonitor)subMon1);
        launch.getSession().getExecutor().execute((Runnable)servicesLaunchSequence);
        try {
            servicesLaunchSequence.get();
        }
        catch (InterruptedException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
        }
        catch (ExecutionException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in services launch sequence", e1.getCause()));
        }
        launch.initializeControl();
        launch.addCLIProcess("gdb");
        launch.addInferiorProcess(exePath.lastSegment());
        SubProgressMonitor subMon2 = new SubProgressMonitor(monitor, 4, 4);
        FinalLaunchSequence finalLaunchSequence = new FinalLaunchSequence(launch.getSession().getExecutor(), launch, SessionType.LOCAL, false, (IProgressMonitor)subMon2);
        launch.getSession().getExecutor().execute((Runnable)finalLaunchSequence);
        try {
            finalLaunchSequence.get();
        }
        catch (InterruptedException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
        }
        catch (ExecutionException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in final launch sequence", e1.getCause()));
        }
    }

    private void verifyBinary(IPath exePath) throws CoreException {
        try {
            new FileReader(exePath.toFile());
        }
        catch (Exception e) {
            FileNotFoundException exception = new FileNotFoundException(exePath.toOSString() + " does not exist");
            int code = 107;
            throw new CoreException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, code, exception == null ? "" : exception.getLocalizedMessage(), (Throwable)exception));
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        return super.preLaunchCheck(config, mode, monitor);
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        GdbLaunch launch = new GdbLaunch(configuration, mode, null);
        launch.initialize();
        return launch;
    }

    private static String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", (String)null);
    }
}

