/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.dsf.service;

import java.lang.reflect.Constructor;
import java.util.concurrent.ExecutionException;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.service.IDsfService;
import org.eclipse.dd.tests.dsf.DsfTestPlugin;
import org.eclipse.dd.tests.dsf.TestDsfExecutor;
import org.eclipse.dd.tests.dsf.service.MultiInstanceTestService;
import org.eclipse.dd.tests.dsf.service.SimpleTestService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceTests {
    TestDsfExecutor fExecutor;

    @Before
    public void startExecutor() throws ExecutionException, InterruptedException {
        this.fExecutor = new TestDsfExecutor();
    }

    @After
    public void shutdownExecutor() throws ExecutionException, InterruptedException {
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                ServiceTests.this.fExecutor.shutdown();
            }
        }).get();
        if (this.fExecutor.exceptionsCaught()) {
            Throwable[] exceptions = this.fExecutor.getExceptions();
            throw new ExecutionException(exceptions[0]);
        }
        this.fExecutor = null;
    }

    @Test
    public void singleServiceTest() throws InterruptedException, ExecutionException {
        Sequence seq = new Sequence((DsfExecutor)this.fExecutor){
            CreateSessionStep fSessionStep;
            InitializeServiceStep fServiceStep;
            private final Sequence.Step[] fSteps;
            {
                Sequence.Step[] stepArray = new Sequence.Step[6];
                this.fSessionStep = new CreateSessionStep();
                stepArray[0] = this.fSessionStep;
                this.fServiceStep = new InitializeServiceStep(this.fSessionStep, SimpleTestService.class);
                stepArray[1] = this.fServiceStep;
                stepArray[2] = new TestRetrievingSimpleServiceReferenceStep(SimpleTestService.class, true, this.fSessionStep);
                stepArray[3] = new ShutdownServiceStep(this.fServiceStep);
                stepArray[4] = new TestRetrievingSimpleServiceReferenceStep(SimpleTestService.class, false, this.fSessionStep);
                stepArray[5] = new ShutdownSessionStep(this.fSessionStep);
                this.fSteps = stepArray;
            }

            public Sequence.Step[] getSteps() {
                return this.fSteps;
            }
        };
        this.fExecutor.execute((Runnable)seq);
        seq.get();
    }

    @Test
    public void singleServiceMultiSessionTest() throws InterruptedException, ExecutionException {
        Sequence seq = new Sequence((DsfExecutor)this.fExecutor){
            CreateSessionStep fSession1Step;
            CreateSessionStep fSession2Step;
            InitializeServiceStep fSession1ServiceStep;
            InitializeServiceStep fSession2ServiceStep;
            private final Sequence.Step[] fSteps;
            {
                Sequence.Step[] stepArray = new Sequence.Step[12];
                this.fSession1Step = new CreateSessionStep();
                stepArray[0] = this.fSession1Step;
                this.fSession2Step = new CreateSessionStep();
                stepArray[1] = this.fSession2Step;
                this.fSession1ServiceStep = new InitializeServiceStep(this.fSession1Step, SimpleTestService.class);
                stepArray[2] = this.fSession1ServiceStep;
                this.fSession2ServiceStep = new InitializeServiceStep(this.fSession2Step, SimpleTestService.class);
                stepArray[3] = this.fSession2ServiceStep;
                stepArray[4] = new TestRetrievingSimpleServiceReferenceStep(SimpleTestService.class, true, this.fSession1Step);
                stepArray[5] = new TestRetrievingSimpleServiceReferenceStep(SimpleTestService.class, true, this.fSession2Step);
                stepArray[6] = new ShutdownServiceStep(this.fSession1ServiceStep);
                stepArray[7] = new ShutdownServiceStep(this.fSession2ServiceStep);
                stepArray[8] = new TestRetrievingSimpleServiceReferenceStep(SimpleTestService.class, false, this.fSession1Step);
                stepArray[9] = new TestRetrievingSimpleServiceReferenceStep(SimpleTestService.class, false, this.fSession2Step);
                stepArray[10] = new ShutdownSessionStep(this.fSession1Step);
                stepArray[11] = new ShutdownSessionStep(this.fSession2Step);
                this.fSteps = stepArray;
            }

            public Sequence.Step[] getSteps() {
                return this.fSteps;
            }
        };
        this.fExecutor.execute((Runnable)seq);
        seq.get();
    }

    @Test
    public void multiServiceServiceTest() throws InterruptedException, ExecutionException {
        Sequence seq = new Sequence((DsfExecutor)this.fExecutor){
            CreateSessionStep fSessionStep;
            InitializeServiceStep fService1Step;
            InitializeServiceStep fService2Step;
            private final Sequence.Step[] fSteps;
            {
                Sequence.Step[] stepArray = new Sequence.Step[10];
                this.fSessionStep = new CreateSessionStep();
                stepArray[0] = this.fSessionStep;
                this.fService1Step = new InitializeMultiInstanceServiceStep(this.fSessionStep, MultiInstanceTestService.class, "1");
                stepArray[1] = this.fService1Step;
                this.fService2Step = new InitializeMultiInstanceServiceStep(this.fSessionStep, MultiInstanceTestService.class, "2");
                stepArray[2] = this.fService2Step;
                stepArray[3] = new TestRetrievingMultiSessionServiceReferenceStep(MultiInstanceTestService.class, true, this.fSessionStep, "1");
                stepArray[4] = new TestRetrievingMultiSessionServiceReferenceStep(MultiInstanceTestService.class, true, this.fSessionStep, "2");
                stepArray[5] = new ShutdownServiceStep(this.fService1Step);
                stepArray[6] = new ShutdownServiceStep(this.fService2Step);
                stepArray[7] = new TestRetrievingMultiSessionServiceReferenceStep(MultiInstanceTestService.class, false, this.fSessionStep, "1");
                stepArray[8] = new TestRetrievingMultiSessionServiceReferenceStep(MultiInstanceTestService.class, false, this.fSessionStep, "2");
                stepArray[9] = new ShutdownSessionStep(this.fSessionStep);
                this.fSteps = stepArray;
            }

            public Sequence.Step[] getSteps() {
                return this.fSteps;
            }
        };
        this.fExecutor.execute((Runnable)seq);
        seq.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestRetrievingMultiSessionServiceReferenceStep
    extends TestRetrievingSimpleServiceReferenceStep {
        String fServiceId;

        TestRetrievingMultiSessionServiceReferenceStep(Class<?> clazz, boolean shouldSucceed, CreateSessionStep createSessionStep, String serviceId) {
            super(clazz, shouldSucceed, createSessionStep);
            this.fServiceId = serviceId;
        }

        @Override
        String getFilter() {
            return "(&(org.eclipse.dd.dsf.service.IService.session_id=" + this.fCreateSessionStep.getSession().getId() + ")" + "(" + MultiInstanceTestService.PROP_INSTANCE_ID + "=" + this.fServiceId + ")" + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestRetrievingSimpleServiceReferenceStep
    extends TestRetrievingReferenceStep {
        CreateSessionStep fCreateSessionStep;

        TestRetrievingSimpleServiceReferenceStep(Class<?> clazz, boolean shouldSucceed, CreateSessionStep createSessionStep) {
            super(clazz, shouldSucceed);
            this.fCreateSessionStep = createSessionStep;
        }

        @Override
        String getFilter() {
            return "(org.eclipse.dd.dsf.service.IService.session_id=" + this.fCreateSessionStep.getSession().getId() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TestRetrievingReferenceStep
    extends Sequence.Step {
        String fClass;
        boolean fShouldSucceed;

        TestRetrievingReferenceStep(Class<?> clazz, boolean shouldSucceed) {
            this.fClass = clazz.getName();
            this.fShouldSucceed = shouldSucceed;
        }

        abstract String getFilter();

        public void execute(RequestMonitor requestMonitor) {
            ServiceReference[] refs = null;
            try {
                refs = DsfTestPlugin.getBundleContext().getServiceReferences(this.fClass, this.getFilter());
            }
            catch (InvalidSyntaxException e) {
                Assert.fail((String)"Unexpected exception");
            }
            if (this.fShouldSucceed) {
                Assert.assertTrue((refs != null ? 1 : 0) != 0);
                Assert.assertTrue((refs.length == 1 ? 1 : 0) != 0);
                IDsfService service = (IDsfService)DsfTestPlugin.getBundleContext().getService(refs[0]);
                Assert.assertTrue((service != null ? 1 : 0) != 0);
                DsfTestPlugin.getBundleContext().ungetService(refs[0]);
            } else {
                Assert.assertTrue((refs == null ? 1 : 0) != 0);
            }
            requestMonitor.done();
        }
    }

    private class ShutdownServiceStep
    extends Sequence.Step {
        InitializeServiceStep fInitializeServiceStep;

        ShutdownServiceStep(InitializeServiceStep initStep) {
            this.fInitializeServiceStep = initStep;
        }

        public void execute(RequestMonitor requestMonitor) {
            this.fInitializeServiceStep.getService().shutdown(requestMonitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitializeMultiInstanceServiceStep
    extends InitializeServiceStep {
        String fServiceId;

        InitializeMultiInstanceServiceStep(CreateSessionStep createSessionStep, Class<? extends IDsfService> serviceClass, String serviceId) {
            super(createSessionStep, serviceClass);
            this.fServiceId = serviceId;
        }

        @Override
        IDsfService getService() {
            return this.fService;
        }

        @Override
        public void execute(RequestMonitor requestMonitor) {
            try {
                Constructor c = this.fServiceClass.getConstructor(DsfSession.class, String.class);
                this.fService = (IDsfService)c.newInstance(this.fCreateSessionStep.getSession(), this.fServiceId);
            }
            catch (Exception e) {
                Assert.fail((String)"Unexpected exception");
            }
            this.fService.initialize(requestMonitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitializeServiceStep
    extends Sequence.Step {
        CreateSessionStep fCreateSessionStep;
        Class<? extends IDsfService> fServiceClass;
        IDsfService fService;

        InitializeServiceStep(CreateSessionStep createSessionStep, Class<? extends IDsfService> serviceClass) {
            this.fCreateSessionStep = createSessionStep;
            this.fServiceClass = serviceClass;
        }

        IDsfService getService() {
            return this.fService;
        }

        public void execute(RequestMonitor requestMonitor) {
            try {
                Constructor<? extends IDsfService> c = this.fServiceClass.getConstructor(DsfSession.class);
                this.fService = c.newInstance(this.fCreateSessionStep.getSession());
            }
            catch (Exception e) {
                Assert.fail((String)"Unexpected exception");
            }
            this.fService.initialize(requestMonitor);
        }
    }

    private class ShutdownSessionStep
    extends Sequence.Step {
        private CreateSessionStep fCreateSessionStep;

        ShutdownSessionStep(CreateSessionStep createSessionStep) {
            this.fCreateSessionStep = createSessionStep;
        }

        public void execute(RequestMonitor requestMonitor) {
            DsfSession.endSession((DsfSession)this.fCreateSessionStep.getSession());
            requestMonitor.done();
        }
    }

    private class CreateSessionStep
    extends Sequence.Step {
        private DsfSession fSession;

        private CreateSessionStep() {
        }

        public void execute(RequestMonitor requestMonitor) {
            this.fSession = DsfSession.startSession((DsfExecutor)ServiceTests.this.fExecutor, (String)"org.eclipse.dd.dsf.tests");
            requestMonitor.done();
        }

        DsfSession getSession() {
            return this.fSession;
        }
    }
}

