/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.gdb;

import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.provisional.service.command.IGDBControl;
import org.eclipse.dd.mi.service.MIProcesses;
import org.eclipse.dd.tests.gdb.framework.AsyncCompletionWaitor;
import org.eclipse.dd.tests.gdb.framework.BaseTestCase;
import org.eclipse.dd.tests.gdb.launching.TestsPlugin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GDBProcessesTest
extends BaseTestCase {
    private static final String EXEC_PATH = "data/launch/bin/";
    private static final String EXEC_NAME = "MultiThread.exe";
    private DsfSession fSession;
    private DsfServicesTracker fServicesTracker;
    private IGDBControl fGdbCtrl;
    private MIProcesses fProcService;
    private final AsyncCompletionWaitor fWait = new AsyncCompletionWaitor();

    @Before
    public void init() throws Exception {
        this.fSession = this.getGDBLaunch().getSession();
        this.fServicesTracker = new DsfServicesTracker(TestsPlugin.getBundleContext(), this.fSession.getId());
        this.fProcService = (MIProcesses)this.fServicesTracker.getService(MIProcesses.class);
        this.fGdbCtrl = (IGDBControl)this.fServicesTracker.getService(IGDBControl.class);
    }

    @After
    public void tearDown() {
        this.fProcService = null;
        this.fServicesTracker.dispose();
    }

    @BeforeClass
    public static void beforeClassMethod() {
        GDBProcessesTest.setLaunchAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "data/launch/bin/MultiThread.exe");
    }

    @Test
    public void getProcessData() throws InterruptedException {
        DataRequestMonitor<IProcesses.IThreadDMData> rm = new DataRequestMonitor<IProcesses.IThreadDMData>((Executor)this.fSession.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    GDBProcessesTest.this.fWait.setReturnInfo(this.getData());
                }
                GDBProcessesTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fSession.getExecutor().submit(new Runnable((DataRequestMonitor)rm){
            final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
            }

            public void run() {
                String groupId = "";
                IProcesses.IProcessDMContext procDmc = GDBProcessesTest.this.fProcService.createProcessContext(GDBProcessesTest.this.fGdbCtrl.getContext(), groupId);
                GDBProcessesTest.this.fProcService.getExecutionData((IProcesses.IThreadDMContext)procDmc, this.val$rm);
            }
        });
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        IProcesses.IThreadDMData processData = (IProcesses.IThreadDMData)this.fWait.getReturnInfo();
        if (processData == null) {
            Assert.fail((String)"No process data is returned for Process DMC");
        } else {
            Assert.assertEquals((String)"Process data should be executable name MultiThread.exe", (Object)EXEC_NAME, (Object)processData.getName());
        }
    }

    @Test
    public void getThreadData() throws InterruptedException {
        String THREAD_ID = "1";
        DataRequestMonitor<IProcesses.IThreadDMData> rm = new DataRequestMonitor<IProcesses.IThreadDMData>((Executor)this.fSession.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    GDBProcessesTest.this.fWait.setReturnInfo(this.getData());
                }
                GDBProcessesTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fProcService.getExecutor().submit(new Runnable((DataRequestMonitor)rm){
            final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
            }

            public void run() {
                String groupId = "";
                IProcesses.IProcessDMContext procDmc = GDBProcessesTest.this.fProcService.createProcessContext(GDBProcessesTest.this.fGdbCtrl.getContext(), groupId);
                IProcesses.IThreadDMContext threadDmc = GDBProcessesTest.this.fProcService.createThreadContext(procDmc, "1");
                GDBProcessesTest.this.fProcService.getExecutionData(threadDmc, this.val$rm);
            }
        });
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        IProcesses.IThreadDMData threadData = (IProcesses.IThreadDMData)this.fWait.getReturnInfo();
        if (threadData == null) {
            Assert.fail((String)"Thread data not returned for thread id = 1");
        } else {
            Pattern pattern = Pattern.compile("\\d*", 8);
            Matcher matcher = pattern.matcher(threadData.getId());
            Assert.assertTrue((String)"Thread ID is a series of number", (boolean)matcher.find());
            Assert.assertEquals((String)"Thread name is should have been blank for GDB Back end", (Object)"", (Object)threadData.getName());
        }
        this.fWait.waitReset();
    }
}

