/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceLibrary;
import org.eclipse.dd.ipxact.editor.ui.SpiritUiPlugin;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class SpiritDocumentTransfer
extends ByteArrayTransfer {
    private static SpiritDocumentTransfer instance;
    private String typeName;
    private int typeId;

    public static SpiritDocumentTransfer getInstance() {
        if (instance == null) {
            instance = new SpiritDocumentTransfer();
            SpiritDocumentTransfer.instance.typeName = "spirit-document-transfer-format-" + System.currentTimeMillis() + '-' + ((Object)((Object)instance)).hashCode();
            SpiritDocumentTransfer.instance.typeId = SpiritDocumentTransfer.registerType((String)SpiritDocumentTransfer.instance.typeName);
        }
        return instance;
    }

    private SpiritDocumentTransfer() {
    }

    protected int[] getTypeIds() {
        return new int[]{this.typeId};
    }

    protected String[] getTypeNames() {
        return new String[]{this.typeName};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!(object instanceof SpiritDocument)) {
            return;
        }
        SpiritDocument document = (SpiritDocument)object;
        byte[] bytes = this.toByteArray(document);
        super.javaToNative((Object)bytes, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            Vlnv vlnv = new Vlnv(dataIn);
            return SpiritResourceLibrary.getDefault().get(vlnv);
        }
        catch (IOException ex) {
            SpiritUiPlugin.logError(ex);
            return null;
        }
    }

    private byte[] toByteArray(SpiritDocument document) {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(bytesOut);
            document.getVlnv().write(dataOut);
            dataOut.close();
            return bytesOut.toByteArray();
        }
        catch (IOException ex) {
            SpiritUiPlugin.logError(ex);
            return null;
        }
    }
}

