/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.memory.renderings.traditional;

import java.math.BigInteger;
import org.eclipse.dd.debug.memory.renderings.traditional.GoToAddressWidget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.RenderingViewPane;
import org.eclipse.debug.internal.ui.views.memory.renderings.CreateRendering;
import org.eclipse.debug.ui.memory.AbstractMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class TraditionalGoToAddressRendering
extends AbstractMemoryRendering {
    private IMemoryRenderingSite fSite;
    private IMemoryRenderingContainer fContainer;
    private Control fControl;

    public void init(IMemoryRenderingContainer container, IMemoryBlock block) {
        super.init(container, block);
        this.fSite = container.getMemoryRenderingSite();
        this.fContainer = container;
    }

    public TraditionalGoToAddressRendering(String renderingId) {
        super(renderingId);
    }

    public Control createControl(Composite parent) {
        Control fGotoAddressControl;
        Composite fGotoAddressContainer = parent;
        final GoToAddressWidget fGotoAddress = new GoToAddressWidget();
        this.fControl = fGotoAddressControl = fGotoAddress.createControl(fGotoAddressContainer);
        final Runnable goHandler = new Runnable(){

            public void run() {
                TraditionalGoToAddressRendering.this.go(fGotoAddress.getExpressionText(), false);
            }
        };
        Button button = fGotoAddress.getButton(0);
        if (button != null) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    goHandler.run();
                }
            });
        }
        if ((button = fGotoAddress.getButton(GoToAddressWidget.ID_GO_NEW_TAB)) != null) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TraditionalGoToAddressRendering.this.go(fGotoAddress.getExpressionText(), true);
                }
            });
        }
        fGotoAddress.getExpressionWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    goHandler.run();
                }
                super.keyPressed(e);
            }
        });
        return this.fControl;
    }

    public Control getControl() {
        return this.fControl;
    }

    private void go(final String expression, final boolean inNewTab) {
        IMemoryRenderingContainer[] containers = this.fSite.getMemoryRenderingContainers();
        for (int i = 0; i < containers.length; ++i) {
            IMemoryRendering activeRendering;
            if (!(containers[i] instanceof RenderingViewPane)) continue;
            final IMemoryRenderingContainer container = containers[i];
            if (containers[i] == null || (activeRendering = containers[i].getActiveRendering()) == null) continue;
            new Thread(){

                public void run() {
                    IMemoryBlock activeMemoryBlock = activeRendering.getMemoryBlock();
                    IMemoryBlockExtension blockExtension = (IMemoryBlockExtension)activeMemoryBlock.getAdapter(IMemoryBlockExtension.class);
                    if (inNewTab) {
                        try {
                            CreateRendering rendering = new CreateRendering(container);
                            IMemoryBlockExtension newBlock = null;
                            if (activeMemoryBlock.getDebugTarget() instanceof IMemoryBlockRetrievalExtension) {
                                newBlock = ((IMemoryBlockRetrievalExtension)activeMemoryBlock.getDebugTarget()).getExtendedMemoryBlock(expression, (Object)activeMemoryBlock.getDebugTarget());
                            } else {
                                BigInteger newAddress = expression.toUpperCase().startsWith("0X") ? new BigInteger(expression.substring(2), 16) : new BigInteger(expression, 16);
                                newBlock = activeMemoryBlock.getDebugTarget().getMemoryBlock(newAddress.longValue(), activeMemoryBlock.getLength());
                            }
                            IMemoryBlockExtension finalNewBlock = newBlock;
                            Display.getDefault().asyncExec(new Runnable((IMemoryRendering)rendering, (IMemoryBlock)finalNewBlock){
                                final /* synthetic */ IMemoryRendering val$rendering;
                                final /* synthetic */ IMemoryBlock val$finalNewBlock;
                                {
                                    this.val$rendering = iMemoryRendering;
                                    this.val$finalNewBlock = iMemoryBlock;
                                }

                                public void run() {
                                    this.val$rendering.init(container, this.val$finalNewBlock);
                                    container.addMemoryRendering(this.val$rendering);
                                }
                            });
                        }
                        catch (DebugException e) {
                            MemoryViewUtil.openError((String)DebugUIMessages.GoToAddressAction_Go_to_address_failed, (String)DebugUIMessages.GoToAddressAction_Address_is_invalid, (Exception)((Object)e));
                        }
                    } else if (activeRendering instanceof IRepositionableMemoryRendering) {
                        try {
                            if (activeMemoryBlock.getDebugTarget() instanceof IMemoryBlockRetrievalExtension) {
                                IMemoryBlockExtension resolveExpressionBlock = ((IMemoryBlockRetrievalExtension)activeMemoryBlock.getDebugTarget()).getExtendedMemoryBlock(expression, (Object)activeMemoryBlock.getDebugTarget());
                                ((IRepositionableMemoryRendering)activeRendering).goToAddress(resolveExpressionBlock.getBigBaseAddress());
                            } else {
                                BigInteger newAddress = expression.toUpperCase().startsWith("0X") ? new BigInteger(expression.substring(2), 16) : new BigInteger(expression, 16);
                                ((IRepositionableMemoryRendering)activeRendering).goToAddress(newAddress);
                            }
                        }
                        catch (DebugException de) {
                            MemoryViewUtil.openError((String)DebugUIMessages.GoToAddressAction_Go_to_address_failed, (String)DebugUIMessages.GoToAddressAction_Address_is_invalid, (Exception)((Object)de));
                        }
                    }
                }
            }.start();
        }
    }
}

