/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.breakpoints;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IDsfBreakpointExtension;
import org.eclipse.dd.dsf.debug.service.IRunControl;

public class CBreakpointGdbThreadsFilterExtension
implements IDsfBreakpointExtension {
    private Map<IRunControl.IContainerDMContext, Set<IRunControl.IExecutionDMContext>> fFilteredThreadsByTarget = new HashMap<IRunControl.IContainerDMContext, Set<IRunControl.IExecutionDMContext>>(1);

    public void initialize(ICBreakpoint breakpoint) {
    }

    public IRunControl.IContainerDMContext[] getTargetFilters() throws CoreException {
        Set<IRunControl.IContainerDMContext> set = this.fFilteredThreadsByTarget.keySet();
        return set.toArray(new IRunControl.IContainerDMContext[set.size()]);
    }

    public IRunControl.IExecutionDMContext[] getThreadFilters(IRunControl.IContainerDMContext target) throws CoreException {
        Set<IRunControl.IExecutionDMContext> set = this.fFilteredThreadsByTarget.get(target);
        return set != null ? set.toArray(new IRunControl.IExecutionDMContext[set.size()]) : null;
    }

    public void removeTargetFilter(IRunControl.IContainerDMContext target) throws CoreException {
        if (this.fFilteredThreadsByTarget.containsKey(target)) {
            this.fFilteredThreadsByTarget.remove(target);
        }
    }

    public void removeThreadFilters(IRunControl.IExecutionDMContext[] threads) throws CoreException {
        Set<IRunControl.IExecutionDMContext> set;
        IRunControl.IContainerDMContext target;
        if (threads != null && threads.length > 0 && this.fFilteredThreadsByTarget.containsKey(target = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)threads[0], IRunControl.IContainerDMContext.class)) && (set = this.fFilteredThreadsByTarget.get(target)) != null) {
            set.removeAll(Arrays.asList(threads));
            if (set.isEmpty()) {
                this.fFilteredThreadsByTarget.remove(target);
            }
        }
    }

    public void setTargetFilter(IRunControl.IContainerDMContext target) throws CoreException {
        this.fFilteredThreadsByTarget.put(target, null);
    }

    public void setThreadFilters(IRunControl.IExecutionDMContext[] threads) throws CoreException {
        if (threads != null && threads.length > 0) {
            IRunControl.IContainerDMContext target = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)threads[0], IRunControl.IContainerDMContext.class);
            this.fFilteredThreadsByTarget.put(target, new HashSet<IRunControl.IExecutionDMContext>(Arrays.asList(threads)));
        }
    }
}

