/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.Choice;
import org.eclipse.dd.ipxact.editor.core.document.GeneratorChainConfiguration;
import org.eclipse.dd.ipxact.editor.core.document.SpiritAbstractorDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignConfigurationDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritGeneratorChainDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.AbstractorInstance;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ComponentInstanceNode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ConfigurableElementValue;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.GeneratorConfiguration;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.InterconnectionConfiguration;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CheckConfigurableElements {
    private static String getStringArg(Object arg) throws XPathFunctionException {
        if (arg instanceof String) {
            return (String)arg;
        }
        if (arg instanceof NodeList) {
            Node n = ((NodeList)arg).item(0);
            if (n == null) {
                return "";
            }
            return n.getTextContent();
        }
        if (arg instanceof Double) {
            return Double.toString((Double)arg);
        }
        throw new XPathFunctionException(Messages.CheckConfigurableElements_5);
    }

    private static Double getDoubleArg(Object arg) throws XPathFunctionException {
        if (arg instanceof String) {
            try {
                return Double.valueOf((String)arg);
            }
            catch (NumberFormatException e) {
                throw new XPathFunctionException(Messages.CheckConfigurableElements_6);
            }
        }
        if (arg instanceof NodeList) {
            Node n = ((NodeList)arg).item(0);
            if (n == null) {
                return 0.0;
            }
            try {
                return Double.valueOf(n.getTextContent());
            }
            catch (NumberFormatException e) {
                throw new XPathFunctionException(Messages.CheckConfigurableElements_7);
            }
        }
        if (arg instanceof Double) {
            return (Double)arg;
        }
        throw new XPathFunctionException(Messages.CheckConfigurableElements_8);
    }

    public static int checkDependencies(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        List elements = theDoc.getAllDescendants();
        for (SpiritNode e : elements) {
            String resolve;
            block7: {
                resolve = e.getSpiritAttribute("resolve");
                if (e.hasSpiritAttribute("dependency")) {
                    if (resolve == null) {
                        reporter.report(CheckList.CHECK_37, theDoc, Messages.CheckConfigurableElements_1, e);
                        ++nErrors;
                        continue;
                    }
                    if (!resolve.equals("dependent")) {
                        reporter.report(CheckList.CHECK_37, theDoc, MessageFormat.format(Messages.CheckConfigurableElements_2, resolve), e);
                        ++nErrors;
                        continue;
                    }
                    String xpath_string = e.getSpiritAttribute("dependency");
                    XPath xpath = theDoc.createXPath();
                    SpiritXPathFunctionResolver resolver = new SpiritXPathFunctionResolver(e.getNamespaceURI());
                    xpath.setXPathFunctionResolver(resolver);
                    String xpathResult = null;
                    try {
                        xpathResult = xpath.evaluate(xpath_string, e.getNode());
                        break block7;
                    }
                    catch (Exception exception) {
                        reporter.report(CheckList.CHECK_38, theDoc, Messages.CheckConfigurableElements_4, e);
                        ++nErrors;
                        continue;
                    }
                }
                if (resolve != null && resolve.equals("dependent")) {
                    reporter.report(CheckList.CHECK_37, theDoc, Messages.CheckConfigurableElements_0, e);
                    ++nErrors;
                    continue;
                }
            }
            if (resolve == null || !resolve.equals("user") && !resolve.equals("generated") || e.hasSpiritAttribute("id")) continue;
            reporter.report(CheckList.CHECK_42, theDoc, Messages.CheckConfigurableElements_3);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkDesignConfigurableElementReferences(DocumentChecker checker) {
        int nErrors = 0;
        ICheckerReporter reporter = checker.getReporter();
        SpiritDesignDocument theDoc = (SpiritDesignDocument)checker.getSpiritDocument();
        for (ComponentInstanceNode instance : theDoc.getComponentInstances()) {
            SpiritComponentDocument componentDocument;
            SpiritNode componentRef = instance.getComponentRef();
            try {
                componentDocument = (SpiritComponentDocument)checker.getLinkedDocument(componentRef);
            }
            catch (Exception e) {
                continue;
            }
            List elements = instance.getConfigurableElementValues();
            for (ConfigurableElementValue element : elements) {
                String id = element.getReferenceId();
                SpiritNode target = componentDocument.getNodeById(id);
                if (target == null) {
                    reporter.report(CheckList.CHECK_43, (SpiritDocument)theDoc, MessageFormat.format("id {0} does not reference a valid id in component {1} (VLVN {2})", id, instance.getName(), componentDocument.getVlnv()), (SpiritNode)element);
                    ++nErrors;
                    continue;
                }
                nErrors += CheckConfigurableElements.checkReferenceValid(checker, element, (SpiritDocument)componentDocument, target, instance.getName(), componentDocument.getVlnv());
            }
        }
        return nErrors;
    }

    public static int checkDesignConfigConfigurableElementReferences(DocumentChecker checker) {
        int nErrors = 0;
        ICheckerReporter reporter = checker.getReporter();
        SpiritDesignConfigurationDocument theDoc = (SpiritDesignConfigurationDocument)checker.getSpiritDocument();
        List generatorChainConfigurations = theDoc.getGeneratorChainConfigurations();
        for (GeneratorChainConfiguration generatorChainConfiguration : generatorChainConfigurations) {
            SpiritGeneratorChainDocument generatorChain;
            SpiritNode generatorChainRef = generatorChainConfiguration.getGeneratorChainRef();
            try {
                generatorChain = (SpiritGeneratorChainDocument)checker.getLinkedDocument(generatorChainRef);
            }
            catch (Exception e) {
                continue;
            }
            for (GeneratorConfiguration generatorConfig : generatorChainConfiguration.getGeneratorConfigurations()) {
                String generatorName = generatorConfig.getGeneratorName();
                SpiritNode targetGenerator = generatorChain.getGenerator(generatorName);
                if (targetGenerator == null) continue;
                List configValues = generatorConfig.getConfigurableElementValues();
                for (ConfigurableElementValue valueNode : configValues) {
                    String id = valueNode.getReferenceId();
                    SpiritNode target = targetGenerator.getNodeById(id);
                    if (target == null) {
                        reporter.report(CheckList.CHECK_V14_514, (SpiritDocument)theDoc, MessageFormat.format("id {0} does not reference a valid id in generator chain {1} (VLVN {2})", id, targetGenerator.getName(), generatorChain.getVlnv()), (SpiritNode)valueNode);
                        ++nErrors;
                        continue;
                    }
                    nErrors += CheckConfigurableElements.checkReferenceValid(checker, valueNode, (SpiritDocument)generatorChain, target, valueNode.getName(), generatorChain.getVlnv());
                }
            }
        }
        for (InterconnectionConfiguration interconnectionConfig : theDoc.getInterconnectionConfigurations()) {
            for (AbstractorInstance abstractorInstance : interconnectionConfig.getAbstractorConfigurations()) {
                SpiritNode abstractorRef = abstractorInstance.getAbstractorRef();
                try {
                    SpiritAbstractorDocument abstractor = (SpiritAbstractorDocument)checker.getLinkedDocument(abstractorRef);
                    for (ConfigurableElementValue valueNode : abstractorInstance.getConfigurableElementValues()) {
                        String id = valueNode.getReferenceId();
                        SpiritNode target = abstractor.getNodeById(id);
                        if (target == null) {
                            reporter.report(CheckList.CHECK_V14_515, (SpiritDocument)theDoc, MessageFormat.format("id {0} does not reference a valid id in abstractor {1} (VLVN {2})", id, abstractor.getName(), abstractor.getVlnv()), (SpiritNode)valueNode);
                            ++nErrors;
                            continue;
                        }
                        nErrors += CheckConfigurableElements.checkReferenceValid(checker, valueNode, (SpiritDocument)abstractor, target, valueNode.getName(), abstractor.getVlnv());
                    }
                }
                catch (Exception e) {
                }
            }
        }
        return nErrors;
    }

    private static int checkReferenceValid(DocumentChecker checker, ConfigurableElementValue element, SpiritDocument targetDocument, SpiritNode target, String componentName, Vlnv componentVlnv) {
        String choiceName;
        Choice choice;
        String valueText;
        ICheckerReporter reporter;
        SpiritDocument theDoc;
        int nErrors;
        block23: {
            nErrors = 0;
            theDoc = checker.getSpiritDocument();
            reporter = checker.getReporter();
            String resolve = target.getSpiritAttribute("resolve");
            if (!resolve.equals("user") && !resolve.equals("generated")) {
                reporter.report(CheckList.CHECK_44, theDoc, MessageFormat.format("id {0} references an element in component {1} (VLVN {2}) that cannot be configured", element.getReferenceId(), componentName, componentVlnv), (SpiritNode)element);
                ++nErrors;
            }
            String minString = target.getSpiritAttribute("minimum");
            String maxString = target.getSpiritAttribute("maximum");
            valueText = element.getValue();
            if (target.getSpiritAttribute("format").equals("float")) {
                try {
                    float value = Float.parseFloat(valueText);
                    if (minString.length() != 0) {
                        try {
                            float minValue = Float.parseFloat(minString);
                            if (minValue > value) {
                                reporter.report(CheckList.CHECK_45, theDoc, MessageFormat.format("The configured value of the referenced element (id {0} in {1}, VLNV {2}) is {3} which is less than its minimum value {4}", element.getReferenceId(), componentName, componentVlnv, Float.valueOf(value), Float.valueOf(minValue)), (SpiritNode)element);
                            }
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (maxString.length() == 0) break block23;
                    try {
                        float maxValue = Float.parseFloat(maxString);
                        if (maxValue < value) {
                            reporter.report(CheckList.CHECK_46, theDoc, MessageFormat.format("The configured value of the referenced element (id {0} in {1}, VLNV {2}) is {3} which is more than its maximum value {4}", element.getReferenceId(), componentName, componentVlnv, Float.valueOf(value), Float.valueOf(maxValue)), (SpiritNode)element);
                        }
                    }
                    catch (NumberFormatException e) {
                    }
                }
                catch (NumberFormatException e) {
                    reporter.report(CheckList.CHECK_ERROR, theDoc, MessageFormat.format("id {0} references an element in {1} (VLNV {2}) that is a float, but the value {3} cannot be interpreted as a float value", element.getReferenceId(), componentName, componentVlnv, valueText), (SpiritNode)element);
                }
            } else if (target.getSpiritAttribute("format").equals("long")) {
                try {
                    float value = Long.parseLong(valueText);
                    if (minString.length() != 0) {
                        try {
                            float minValue = Long.parseLong(minString);
                            if (minValue > value) {
                                reporter.report(CheckList.CHECK_45, theDoc, MessageFormat.format("The configured value of the referenced element (id {0} in {1}, VLNV {2}) is {3} which is less than its minimum value {4}", element.getReferenceId(), componentName, componentVlnv, Float.valueOf(value), Float.valueOf(minValue)), (SpiritNode)element);
                            }
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (maxString.length() == 0) break block23;
                    try {
                        float maxValue = Long.parseLong(maxString);
                        if (maxValue < value) {
                            reporter.report(CheckList.CHECK_46, theDoc, MessageFormat.format("The configured value of the referenced element (id {0} in {1}, VLNV {2}) is {3} which is more than its maximum value {4}", element.getReferenceId(), componentName, componentVlnv, Float.valueOf(value), Float.valueOf(maxValue)), (SpiritNode)element);
                        }
                    }
                    catch (NumberFormatException e) {}
                }
                catch (NumberFormatException e) {
                    reporter.report(CheckList.CHECK_ERROR, theDoc, MessageFormat.format("id {0} references an element in {1} (VLNV {2}) that is a long, but the value {3} cannot be interpreted as a long value", element.getReferenceId(), componentName, componentVlnv, valueText), (SpiritNode)element);
                }
            }
        }
        if ((choice = targetDocument.getChoice(choiceName = target.getSpiritAttribute("choiceRef"))) != null && !choice.getValues().contains(valueText)) {
            reporter.report(CheckList.CHECK_48, theDoc, MessageFormat.format("id {0} references an element in {1} (VLNV {2}) that references the choice {3}, but the value ({4}) is not a value that may be chosen", element.getReferenceId(), componentName, componentVlnv, choiceName, valueText), (SpiritNode)element);
        }
        return nErrors;
    }

    private static class SpiritContainsToken
    implements XPathFunction {
        private SpiritContainsToken() {
        }

        public Object evaluate(List arg0) throws XPathFunctionException {
            String[] tokens;
            String token = CheckConfigurableElements.getStringArg(arg0.get(1));
            String target = CheckConfigurableElements.getStringArg(arg0.get(0));
            for (String t : tokens = target.split("\\s")) {
                if (!t.equals(token)) continue;
                return true;
            }
            return false;
        }
    }

    private static class SpiritDecode
    implements XPathFunction {
        private SpiritDecode() {
        }

        public Object evaluate(List arg0) throws XPathFunctionException {
            String in = CheckConfigurableElements.getStringArg(arg0.get(0));
            if (in == "") {
                return 0.0;
            }
            in = in.toUpperCase();
            in = in.trim();
            int radix = 10;
            if (in.startsWith("#")) {
                radix = 16;
                in = in.substring(1);
            } else if (in.startsWith("0X")) {
                radix = 16;
                in = in.substring(2);
            }
            double multiplier = 1.0;
            char lastchar = in.charAt(in.length() - 1);
            if (Character.isLetter(lastchar)) {
                in = in.substring(0, in.length() - 1);
                switch (lastchar) {
                    case 'K': {
                        multiplier = 1024.0;
                        break;
                    }
                    case 'M': {
                        multiplier = 1048576.0;
                        break;
                    }
                    case 'G': {
                        multiplier = 1.073741824E9;
                        break;
                    }
                    case 'T': {
                        multiplier = 0.0;
                    }
                }
            }
            try {
                if (radix == 10) {
                    return Double.parseDouble(in) * multiplier;
                }
                return new Integer(Integer.parseInt(in, radix)).doubleValue() * multiplier;
            }
            catch (NumberFormatException e) {
                throw new XPathFunctionException(Messages.CheckConfigurableElements_9);
            }
        }
    }

    private static class SpiritLog
    implements XPathFunction {
        private SpiritLog() {
        }

        public Object evaluate(List arg0) throws XPathFunctionException {
            Double in1 = CheckConfigurableElements.getDoubleArg(arg0.get(0));
            Double in2 = CheckConfigurableElements.getDoubleArg(arg0.get(1));
            return Math.log(in2) / Math.log(in1);
        }
    }

    private static class SpiritPow
    implements XPathFunction {
        private SpiritPow() {
        }

        public Object evaluate(List arg0) throws XPathFunctionException {
            Double in1 = CheckConfigurableElements.getDoubleArg(arg0.get(0));
            Double in2 = CheckConfigurableElements.getDoubleArg(arg0.get(1));
            return Math.pow(in1, in2);
        }
    }

    private static class SpiritXPathFunctionResolver
    implements XPathFunctionResolver {
        private String ns;

        public SpiritXPathFunctionResolver(String namespace) {
            this.ns = namespace;
        }

        public XPathFunction resolveFunction(QName functionName, int arity) {
            if (functionName.getNamespaceURI().equals(this.ns)) {
                String localName = functionName.getLocalPart();
                if (localName.equals("containsToken") && arity == 2) {
                    return new SpiritContainsToken();
                }
                if (localName.equals("decode") && arity == 1) {
                    return new SpiritDecode();
                }
                if (localName.equals("pow") && arity == 2) {
                    return new SpiritPow();
                }
                if (localName.equals("log") && arity == 2) {
                    return new SpiritLog();
                }
            }
            return null;
        }
    }
}

