/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMData;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.dd.dsf.ui.concurrent.SimpleDisplayExecutor;
import org.eclipse.dd.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMModelProxy;
import org.eclipse.dd.dsf.ui.viewmodel.IVMModelProxyExtension;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenCountUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMHasChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.update.AllUpdateScope;
import org.eclipse.dd.dsf.ui.viewmodel.update.AutomaticUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.ICachingVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.ICachingVMProviderExtension;
import org.eclipse.dd.dsf.ui.viewmodel.update.IElementUpdateTester;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdateScope;
import org.eclipse.dd.dsf.ui.viewmodel.update.ManualUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.MultiLevelUpdateHandler;
import org.eclipse.dd.dsf.ui.viewmodel.update.VisibleUpdateScope;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class AbstractCachingVMProvider
extends AbstractVMProvider
implements ICachingVMProvider,
ICachingVMProviderExtension {
    private boolean fDelayEventHandleForViewUpdate = false;
    static boolean DEBUG_CACHE = false;
    private static final int MAX_CACHE_SIZE = 1000;
    protected static String SELECTED_UPDATE_MODE;
    protected static String SELECTED_UPDATE_SCOPE;
    private IVMUpdatePolicy[] fAvailableUpdatePolicies;
    private IVMUpdateScope[] fAvailableUpdateScopes;
    public Map<Object, RootElementMarkerKey> fRootMarkers = new HashMap<Object, RootElementMarkerKey>();
    private final Map<Object, Entry> fCacheData = Collections.synchronizedMap(new HashMap(200, 0.75f));
    private final Entry fCacheListHead;

    public AbstractCachingVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext) {
        super(adapter, presentationContext);
        this.fCacheListHead.fNext = this.fCacheListHead = new Entry(null){

            public String toString() {
                return "HEAD";
            }
        };
        this.fCacheListHead.fPrevious = this.fCacheListHead;
        this.fAvailableUpdatePolicies = this.createUpdateModes();
        this.fAvailableUpdateScopes = this.createUpdateScopes();
        this.setActiveUpdateScope(new VisibleUpdateScope());
    }

    protected IVMUpdatePolicy[] createUpdateModes() {
        return new IVMUpdatePolicy[]{new AutomaticUpdatePolicy()};
    }

    protected IVMUpdateScope[] createUpdateScopes() {
        return new IVMUpdateScope[]{new VisibleUpdateScope(), new AllUpdateScope()};
    }

    public IVMUpdatePolicy[] getAvailableUpdatePolicies() {
        return this.fAvailableUpdatePolicies;
    }

    public IVMUpdatePolicy getActiveUpdatePolicy() {
        String updateModeId = (String)this.getPresentationContext().getProperty(SELECTED_UPDATE_MODE);
        if (updateModeId != null) {
            for (IVMUpdatePolicy updateMode : this.getAvailableUpdatePolicies()) {
                if (!updateMode.getID().equals(updateModeId)) continue;
                return updateMode;
            }
        }
        return this.getAvailableUpdatePolicies()[0];
    }

    public void setActiveUpdatePolicy(IVMUpdatePolicy updatePolicy) {
        this.getPresentationContext().setProperty(SELECTED_UPDATE_MODE, (Object)updatePolicy.getID());
    }

    public void refresh() {
        IElementUpdateTester elementTester = this.getActiveUpdatePolicy().getElementUpdateTester(ManualUpdatePolicy.REFRESH_EVENT);
        for (IVMModelProxy proxyStrategy : this.getActiveModelProxies()) {
            this.flush(new FlushMarkerKey(proxyStrategy.getRootElement(), elementTester));
        }
        for (IVMModelProxy proxyStrategy : this.getActiveModelProxies()) {
            if (proxyStrategy.isDisposed()) continue;
            proxyStrategy.fireModelChanged((IModelDelta)new ModelDelta(proxyStrategy.getRootElement(), 1024));
        }
    }

    public void updateNode(final IVMNode node, IHasChildrenUpdate[] updates) {
        LinkedList<VMHasChildrenUpdate> missUpdates = new LinkedList<VMHasChildrenUpdate>();
        for (final IHasChildrenUpdate update : updates) {
            ElementDataKey key = this.makeEntryKey(node, (IViewerUpdate)update);
            final ElementDataEntry entry = this.getElementDataEntry(key);
            this.updateRootElementMarker(key.fRootElement, node, (IViewerUpdate)update);
            if (entry.fHasChildren != null) {
                if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                    DsfUIPlugin.debug("cacheHitHasChildren(node = " + node + ", update = " + update + ", " + entry.fHasChildren + ")");
                }
                update.setHasChilren(entry.fHasChildren.booleanValue());
                update.done();
                continue;
            }
            final int flushCounter = entry.fFlushCounter;
            missUpdates.add(new VMHasChildrenUpdate((IViewerUpdate)update, (DataRequestMonitor<Boolean>)new ViewerDataRequestMonitor<Boolean>(this.getExecutor(), (IViewerUpdate)update){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        if (flushCounter == entry.fFlushCounter) {
                            if (DEBUG_CACHE && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
                                DsfUIPlugin.debug("cacheSavedHasChildren(node = " + node + ", update = " + update + ", " + this.getData() + ")");
                            }
                            entry.fHasChildren = (Boolean)this.getData();
                        }
                        update.setHasChilren(((Boolean)this.getData()).booleanValue());
                    } else {
                        update.setStatus(this.getStatus());
                    }
                    update.done();
                }
            }));
        }
        if (!missUpdates.isEmpty()) {
            super.updateNode(node, missUpdates.toArray(new IHasChildrenUpdate[missUpdates.size()]));
        }
    }

    public void updateNode(final IVMNode node, final IChildrenCountUpdate update) {
        ElementDataKey key = this.makeEntryKey(node, (IViewerUpdate)update);
        final ElementDataEntry entry = this.getElementDataEntry(key);
        this.updateRootElementMarker(key.fRootElement, node, (IViewerUpdate)update);
        if (entry.fChildrenCount != null) {
            if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                DsfUIPlugin.debug("cacheHitChildrenCount(node = " + node + ", update = " + update + ", " + entry.fChildrenCount + ")");
            }
            update.setChildCount(entry.fChildrenCount.intValue());
            update.done();
        } else {
            final int flushCounter = entry.fFlushCounter;
            VMChildrenCountUpdate updateProxy = new VMChildrenCountUpdate((IViewerUpdate)update, (DataRequestMonitor<Integer>)new ViewerDataRequestMonitor<Integer>(this.getExecutor(), (IViewerUpdate)update){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        if (flushCounter == entry.fFlushCounter) {
                            if (DEBUG_CACHE && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
                                DsfUIPlugin.debug("cacheSavedChildrenCount(node = " + node + ", update = " + update + ", " + this.getData() + ")");
                            }
                            entry.fChildrenCount = (Integer)this.getData();
                        }
                        update.setChildCount(((Integer)this.getData()).intValue());
                    } else {
                        update.setStatus(this.getStatus());
                    }
                    update.done();
                }
            });
            super.updateNode(node, updateProxy);
        }
    }

    public void updateNode(final IVMNode node, final IChildrenUpdate update) {
        ElementDataKey key = this.makeEntryKey(node, (IViewerUpdate)update);
        final ElementDataEntry entry = this.getElementDataEntry(key);
        this.updateRootElementMarker(key.fRootElement, node, (IViewerUpdate)update);
        final int flushCounter = entry.fFlushCounter;
        if (entry.fChildren == null || update.getOffset() < 0 && !entry.fAllChildrenKnown) {
            VMChildrenUpdate updateProxy = new VMChildrenUpdate((IViewerUpdate)update, update.getOffset(), update.getLength(), (DataRequestMonitor<List<Object>>)new ViewerDataRequestMonitor<List<Object>>(this.getExecutor(), (IViewerUpdate)update){

                @Override
                protected void handleSuccess() {
                    int updateOffset = update.getOffset();
                    if (updateOffset < 0) {
                        updateOffset = 0;
                        if (entry.fFlushCounter == flushCounter) {
                            entry.fAllChildrenKnown = true;
                        }
                    }
                    if (DEBUG_CACHE && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
                        DsfUIPlugin.debug("cacheSavedChildren(node = " + node + ", update = " + update + ", children = {" + updateOffset + "->" + (updateOffset + ((List)this.getData()).size()) + "})");
                    }
                    if (flushCounter == entry.fFlushCounter) {
                        entry.ensureChildrenMap();
                    }
                    for (int j = 0; j < ((List)this.getData()).size(); ++j) {
                        int offset = updateOffset + j;
                        Object child = ((List)this.getData()).get(j);
                        if (child == null) continue;
                        if (flushCounter == entry.fFlushCounter) {
                            entry.fChildren.put(offset, child);
                        }
                        update.setChild(child, offset);
                    }
                    update.done();
                }

                @Override
                protected void handleCancel() {
                    if (DEBUG_CACHE && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
                        DsfUIPlugin.debug("cacheCanceledChildren(node = " + node + ", update = " + update + ")");
                    }
                    super.handleCancel();
                }
            });
            super.updateNode(node, updateProxy);
        } else if (update.getOffset() < 0) {
            if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                DsfUIPlugin.debug("cacheHitChildren(node = " + node + ", update = " + update + ", children = " + entry.fChildren.keySet() + ")");
            }
            assert (entry.fAllChildrenKnown);
            for (int position = 0; position < entry.fChildren.size(); ++position) {
                update.setChild(entry.fChildren.get(position), position);
            }
            update.done();
        } else {
            LinkedList<Integer> childrenMissingFromCache = new LinkedList<Integer>();
            for (int i = update.getOffset(); i < update.getOffset() + update.getLength(); ++i) {
                childrenMissingFromCache.add(i);
            }
            Integer position = update.getOffset();
            while (position < update.getOffset() + update.getLength()) {
                Object child = entry.fChildren.get(position);
                if (child != null) {
                    update.setChild(entry.fChildren.get(position), position.intValue());
                    childrenMissingFromCache.remove(position);
                }
                child = position;
                Integer n = position = Integer.valueOf(position + 1);
            }
            if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                DsfUIPlugin.debug("cachePartialHitChildren(node = " + node + ", update = " + update + ", missing = " + childrenMissingFromCache + ")");
            }
            if (childrenMissingFromCache.size() > 0) {
                ArrayList<VMChildrenUpdate> partialUpdates = new ArrayList<VMChildrenUpdate>(2);
                final ViewerCountingRequestMonitor multiRm = new ViewerCountingRequestMonitor(this.getExecutor(), (IViewerUpdate)update);
                while (childrenMissingFromCache.size() > 0) {
                    final int offset = (Integer)childrenMissingFromCache.get(0);
                    childrenMissingFromCache.remove(0);
                    int n = 1;
                    while (childrenMissingFromCache.size() > 0 && (Integer)childrenMissingFromCache.get(0) == offset + n) {
                        ++n;
                        childrenMissingFromCache.remove(0);
                    }
                    partialUpdates.add(new VMChildrenUpdate((IViewerUpdate)update, offset, n, new DataRequestMonitor<List<Object>>(this.getExecutor(), (RequestMonitor)multiRm){

                        protected void handleSuccess() {
                            if (flushCounter == entry.fFlushCounter) {
                                if (DEBUG_CACHE && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
                                    DsfUIPlugin.debug("cachePartialSaveChildren(node = " + node + ", update = " + update + ", saved = {" + offset + "->" + (offset + ((List)this.getData()).size()) + "})");
                                }
                                entry.ensureChildrenMap();
                            }
                            for (int i = 0; i < ((List)this.getData()).size(); ++i) {
                                if (((List)this.getData()).get(i) == null) continue;
                                update.setChild(((List)this.getData()).get(i), offset + i);
                                if (flushCounter != entry.fFlushCounter) continue;
                                entry.fChildren.put(offset + i, ((List)this.getData()).get(i));
                            }
                            multiRm.done();
                        }
                    }));
                }
                for (IChildrenUpdate iChildrenUpdate : partialUpdates) {
                    super.updateNode(node, iChildrenUpdate);
                }
                multiRm.setDoneCount(partialUpdates.size());
            } else {
                update.done();
            }
        }
    }

    private void flush(FlushMarkerKey flushKey) {
        if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
            DsfUIPlugin.debug("cacheFlushing(" + flushKey + ")");
        }
        Entry entry = this.fCacheListHead.fPrevious;
        while (entry != this.fCacheListHead) {
            if (entry.fKey instanceof FlushMarkerKey) {
                FlushMarkerKey entryFlushKey = (FlushMarkerKey)entry.fKey;
                if (flushKey.includes(entryFlushKey)) {
                    this.fCacheData.remove(entryFlushKey);
                    entry.remove();
                }
                if (entryFlushKey.includes(flushKey)) {
                    break;
                }
            } else if (entry instanceof ElementDataEntry) {
                ElementDataEntry elementDataEntry = (ElementDataEntry)entry;
                int updateFlags = flushKey.getUpdateFlags((ElementDataKey)elementDataEntry.fKey);
                if ((updateFlags & 1) != 0) {
                    if ((updateFlags & 3) == 3) {
                        for (Map.Entry<IDMContext, Object> dataOrStatusEntry : elementDataEntry.fDataOrStatus.entrySet()) {
                            if (!(dataOrStatusEntry.getValue() instanceof IDMData)) continue;
                            elementDataEntry.fArchiveData.put(dataOrStatusEntry.getKey(), (IDMData)dataOrStatusEntry.getValue());
                        }
                        elementDataEntry.fDataOrStatus.clear();
                        if (elementDataEntry.fArchiveData.isEmpty()) {
                            this.fCacheData.remove(entry.fKey);
                            entry.remove();
                        }
                    } else if (!elementDataEntry.fArchiveData.isEmpty()) {
                        elementDataEntry.fDataOrStatus.clear();
                    } else {
                        this.fCacheData.remove(entry.fKey);
                        entry.remove();
                    }
                    ++elementDataEntry.fFlushCounter;
                    elementDataEntry.fHasChildren = null;
                    elementDataEntry.fChildrenCount = null;
                    elementDataEntry.fChildren = null;
                    elementDataEntry.fAllChildrenKnown = false;
                    elementDataEntry.fDirty = false;
                } else if ((updateFlags & 4) != 0) {
                    elementDataEntry.fDirty = true;
                }
            }
            entry = entry.fPrevious;
        }
        Entry flushMarkerEntry = new Entry(flushKey);
        this.fCacheData.put(flushKey, flushMarkerEntry);
        flushMarkerEntry.insert(this.fCacheListHead);
    }

    protected void handleEvent(IVMModelProxy proxyStrategy, Object event, RequestMonitor rm) {
        IElementUpdateTester elementTester = this.getActiveUpdatePolicy().getElementUpdateTester(event);
        this.flush(new FlushMarkerKey(proxyStrategy.getRootElement(), elementTester));
        if (proxyStrategy instanceof IVMModelProxyExtension) {
            IVMModelProxyExtension proxyStrategyExtension = (IVMModelProxyExtension)proxyStrategy;
            CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getExecutor(), rm);
            super.handleEvent(proxyStrategy, event, (RequestMonitor)multiRm);
            int rmCount = 1;
            if (this.fDelayEventHandleForViewUpdate) {
                if (this.getActiveUpdateScope().getID().equals(AllUpdateScope.ALL_UPDATE_SCOPE_ID)) {
                    new MultiLevelUpdateHandler(this.getExecutor(), proxyStrategyExtension, this.getPresentationContext(), this, (RequestMonitor)multiRm).startUpdate();
                    ++rmCount;
                } else if (!proxyStrategy.isDisposed()) {
                    TreeViewer viewer = (TreeViewer)proxyStrategyExtension.getViewer();
                    Tree tree = viewer.getTree();
                    int count = tree.getSize().y / tree.getItemHeight();
                    TreeItem topItem = tree.getTopItem();
                    int index = AbstractCachingVMProvider.computeTreeIndex(topItem);
                    MultiLevelUpdateHandler handler = new MultiLevelUpdateHandler(this.getExecutor(), proxyStrategyExtension, this.getPresentationContext(), this, (RequestMonitor)multiRm);
                    handler.setRange(index, index + count);
                    handler.startUpdate();
                    ++rmCount;
                }
            } else if (this.getActiveUpdateScope().getID().equals(AllUpdateScope.ALL_UPDATE_SCOPE_ID)) {
                MultiLevelUpdateHandler handler = new MultiLevelUpdateHandler(this.getExecutor(), proxyStrategyExtension, this.getPresentationContext(), this, (RequestMonitor)multiRm);
                handler.startUpdate();
                ++rmCount;
            }
            multiRm.setDoneCount(rmCount);
        } else {
            super.handleEvent(proxyStrategy, event, rm);
        }
    }

    private static int computeTreeIndex(TreeItem child) {
        if (child != null) {
            if (child.getParentItem() != null) {
                int previous = 0;
                int index = child.getParentItem().indexOf(child);
                while (--index >= 0) {
                    previous += AbstractCachingVMProvider.computeTreeExtent(child.getParentItem().getItem(index));
                }
                return AbstractCachingVMProvider.computeTreeIndex(child.getParentItem()) + previous;
            }
            int previous = 0;
            int index = child.getParent().indexOf(child);
            while (--index >= 0) {
                previous += AbstractCachingVMProvider.computeTreeExtent(child.getParent().getItem(index));
            }
            return previous;
        }
        return 0;
    }

    private static int computeTreeExtent(TreeItem item) {
        int extent = 1;
        if (item.getExpanded()) {
            for (TreeItem i : item.getItems()) {
                extent += AbstractCachingVMProvider.computeTreeExtent(i);
            }
        }
        return extent;
    }

    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        IVMModelProxy proxy = null;
        for (IVMModelProxy next : this.getActiveModelProxies()) {
            if (next == null || !next.getRootElement().equals(element) || !next.isDisposed()) continue;
            proxy = next;
            break;
        }
        if (proxy == null) {
            proxy = this.createModelProxyStrategy(element);
            this.getActiveModelProxies().add(proxy);
        } else if (proxy.isDisposed()) {
            proxy.init(context);
        }
        return proxy;
    }

    protected void rootElementRemovedFromCache(Object rootElement) {
        this.fRootMarkers.remove(rootElement);
        Iterator<IVMModelProxy> proxiesItr = this.getActiveModelProxies().iterator();
        while (proxiesItr.hasNext()) {
            IVMModelProxy proxy = proxiesItr.next();
            if (!proxy.isDisposed() || !proxy.getRootElement().equals(rootElement)) continue;
            proxiesItr.remove();
        }
    }

    private ElementDataKey makeEntryKey(IVMNode node, IViewerUpdate update) {
        Object rootElement = update.getViewerInput();
        block0: for (IVMModelProxy proxy : this.getActiveModelProxies()) {
            Object proxyRoot = proxy.getRootElement();
            if (proxyRoot.equals(update.getViewerInput())) {
                rootElement = proxyRoot;
                break;
            }
            TreePath path = update.getElementPath();
            for (int i = 0; i < path.getSegmentCount(); ++i) {
                if (!proxyRoot.equals(path.getSegment(i))) continue;
                rootElement = proxyRoot;
                break block0;
            }
        }
        return new ElementDataKey(rootElement, node, update.getViewerInput(), update.getElementPath());
    }

    private ElementDataEntry getElementDataEntry(ElementDataKey key) {
        assert (key != null);
        ElementDataEntry entry = (ElementDataEntry)this.fCacheData.get(key);
        if (entry == null) {
            entry = new ElementDataEntry(key);
            this.addEntry(key, entry);
        } else {
            entry.reinsert(this.fCacheListHead);
        }
        return entry;
    }

    private void updateRootElementMarker(Object rootElement, IVMNode node, IViewerUpdate update) {
        Entry rootMarkerEntry;
        boolean created = false;
        RootElementMarkerKey rootMarker = this.fRootMarkers.get(rootElement);
        if (rootMarker == null) {
            rootMarker = new RootElementMarkerKey(rootElement);
            this.fRootMarkers.put(rootElement, rootMarker);
            created = true;
        }
        if ((rootMarkerEntry = this.fCacheData.get(rootMarker)) == null) {
            rootMarkerEntry = new RootElementMarkerEntry(rootMarker);
            this.addEntry(rootMarker, rootMarkerEntry);
        } else if (rootMarkerEntry.fNext != this.fCacheListHead) {
            rootMarkerEntry.reinsert(this.fCacheListHead);
        }
        if (created) {
            ElementDataKey rootElementDataKey = new ElementDataKey(rootElement, node, update.getViewerInput(), update.getElementPath());
            ElementDataEntry entry = this.getElementDataEntry(rootElementDataKey);
            Object[] rootElementChildren = this.getActiveUpdatePolicy().getInitialRootElementChildren(rootElement);
            if (rootElementChildren != null) {
                entry.fHasChildren = rootElementChildren.length > 0;
                entry.fChildrenCount = rootElementChildren.length;
                entry.fChildren = new HashMap<Integer, Object>(entry.fChildrenCount * 4 / 3);
                for (int i = 0; i < rootElementChildren.length; ++i) {
                    entry.fChildren.put(i, rootElementChildren[i]);
                }
                entry.fAllChildrenKnown = true;
                entry.fDirty = true;
            }
        }
    }

    private void addEntry(Object key, Entry entry) {
        this.fCacheData.put(key, entry);
        entry.insert(this.fCacheListHead);
        if (this.fCacheData.size() > 1000) {
            this.fCacheData.remove(this.fCacheListHead.fNext.fKey);
            this.fCacheListHead.fNext.remove();
        }
    }

    @Deprecated
    public void getModelData(final IVMNode node, final IViewerUpdate update, final IDMService service, final IDMContext dmc, final DataRequestMonitor rm, final Executor executor) {
        Executor vmExecutor = this.getExecutor();
        if (vmExecutor instanceof SimpleDisplayExecutor && Display.getDefault().getThread() == Thread.currentThread()) {
            this.getCacheModelData(node, update, service, dmc, rm, executor);
        } else {
            vmExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    AbstractCachingVMProvider.this.getCacheModelData(node, update, service, dmc, rm, executor);
                }
            });
        }
    }

    private void getCacheModelData(final IVMNode node, final IViewerUpdate update, final IDMService service, final IDMContext dmc, final DataRequestMonitor rm, final Executor executor) {
        ElementDataKey key = this.makeEntryKey(node, update);
        final ElementDataEntry entry = this.getElementDataEntry(key);
        Object dataOrStatus = entry.fDataOrStatus.get(dmc);
        if (dataOrStatus != null) {
            if (dataOrStatus instanceof IDMData) {
                rm.setData(dataOrStatus);
            } else {
                rm.setStatus((IStatus)dataOrStatus);
            }
            rm.done();
        } else {
            DsfExecutor dsfExecutor = service.getExecutor();
            if (dsfExecutor.isInExecutorThread()) {
                this.getModelDataFromService(node, update, service, dmc, rm, executor, entry);
            } else {
                try {
                    dsfExecutor.execute((Runnable)new DsfRunnable(){

                        public void run() {
                            AbstractCachingVMProvider.this.getModelDataFromService(node, update, service, dmc, rm, executor, entry);
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10001, "Service session's executor shut down.", null));
                    rm.done();
                }
            }
        }
    }

    private void getModelDataFromService(IVMNode node, IViewerUpdate update, IDMService service, final IDMContext dmc, final DataRequestMonitor rm, Executor executor, final ElementDataEntry entry) {
        service.getModelData(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IDMData>(executor, update){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    entry.fDataOrStatus.put(dmc, this.getData());
                    rm.setData(this.getData());
                } else {
                    if (!this.isCanceled()) {
                        entry.fDataOrStatus.put(dmc, this.getStatus());
                    }
                    rm.setStatus(this.getStatus());
                }
                rm.done();
            }
        });
    }

    @Deprecated
    public IDMData getArchivedModelData(IVMNode node, IViewerUpdate update, IDMContext dmc) {
        Map<IDMContext, IDMData> archiveData;
        ElementDataKey key = this.makeEntryKey(node, update);
        Entry entry = this.fCacheData.get(key);
        if (entry instanceof ElementDataEntry && (archiveData = ((ElementDataEntry)entry).fArchiveData) != null) {
            return archiveData.get(dmc);
        }
        return null;
    }

    public IVMUpdateScope[] getAvailableUpdateScopes() {
        return this.fAvailableUpdateScopes;
    }

    public IVMUpdateScope getActiveUpdateScope() {
        String updateScopeId = (String)this.getPresentationContext().getProperty(SELECTED_UPDATE_SCOPE);
        if (updateScopeId != null) {
            for (IVMUpdateScope updateScope : this.getAvailableUpdateScopes()) {
                if (!updateScope.getID().equals(updateScopeId)) continue;
                return updateScope;
            }
        }
        return this.getAvailableUpdateScopes()[0];
    }

    public void setActiveUpdateScope(IVMUpdateScope updateScope) {
        this.getPresentationContext().setProperty(SELECTED_UPDATE_SCOPE, (Object)updateScope.getID());
    }

    public boolean shouldWaitHandleEventToComplete() {
        return this.fDelayEventHandleForViewUpdate;
    }

    protected void setDelayEventHandleForViewUpdate(boolean on) {
        this.fDelayEventHandleForViewUpdate = on;
    }

    static {
        DEBUG_CACHE = DsfUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.dd.dsf.ui/debug/vm/cache"));
        SELECTED_UPDATE_MODE = "org.eclipse.dd.dsf.ui.viewmodel.update.selectedUpdateMode";
        SELECTED_UPDATE_SCOPE = "org.eclipse.dd.dsf.ui.viewmodel.update.selectedUpdateScope";
    }

    class RootElementMarkerEntry
    extends Entry {
        RootElementMarkerEntry(RootElementMarkerKey key) {
            super(key);
        }

        void remove() {
            super.remove();
            AbstractCachingVMProvider.this.rootElementRemovedFromCache(((RootElementMarkerKey)this.fKey).fRootElement);
        }

        public String toString() {
            return "ROOT MARKER " + this.fKey;
        }
    }

    private static class RootElementMarkerKey {
        private Object fRootElement;

        RootElementMarkerKey(Object rootElement) {
            this.fRootElement = rootElement;
        }

        public boolean equals(Object obj) {
            return obj instanceof RootElementMarkerKey && ((RootElementMarkerKey)obj).fRootElement.equals(this.fRootElement);
        }

        public int hashCode() {
            return this.fRootElement.hashCode();
        }

        public String toString() {
            return this.fRootElement.toString();
        }
    }

    private static class FlushMarkerKey {
        private Object fRootElement;
        private IElementUpdateTester fElementTester;

        FlushMarkerKey(Object rootElement, IElementUpdateTester pathTester) {
            this.fRootElement = rootElement;
            this.fElementTester = pathTester;
        }

        boolean includes(FlushMarkerKey key) {
            return this.fRootElement.equals(key.fRootElement) && this.fElementTester.includes(key.fElementTester);
        }

        int getUpdateFlags(ElementDataKey key) {
            if (this.fRootElement.equals(key.fRootElement)) {
                return this.fElementTester.getUpdateFlags(key.fViewerInput, key.fPath);
            }
            return 0;
        }

        public String toString() {
            return this.fElementTester.toString() + " " + this.fRootElement.toString();
        }
    }

    static class ElementDataEntry
    extends Entry {
        int fFlushCounter = 0;
        Boolean fDirty = false;
        Boolean fHasChildren = null;
        Integer fChildrenCount = null;
        boolean fAllChildrenKnown = false;
        Map<Integer, Object> fChildren = null;
        Map<IDMContext, Object> fDataOrStatus = new HashMap<IDMContext, Object>(1);
        Map<IDMContext, IDMData> fArchiveData = new HashMap<IDMContext, IDMData>(1);

        ElementDataEntry(ElementDataKey key) {
            super(key);
        }

        void ensureChildrenMap() {
            if (this.fChildren == null) {
                Integer childrenCount = this.fChildrenCount;
                childrenCount = childrenCount != null ? childrenCount : 0;
                int capacity = Math.max(childrenCount * 4 / 3, 32);
                this.fChildren = new HashMap<Integer, Object>(capacity);
            }
        }

        public String toString() {
            return this.fKey.toString() + " = " + "[hasChildren=" + this.fHasChildren + ", " + "childrenCount=" + this.fChildrenCount + ", children=" + this.fChildren + ", data/status=" + this.fDataOrStatus + ", oldData=" + this.fArchiveData + "]";
        }
    }

    private static class Entry {
        final Object fKey;
        Entry fNext;
        Entry fPrevious;

        Entry(Object key) {
            this.fKey = key;
        }

        void insert(Entry nextEntry) {
            this.fNext = nextEntry;
            this.fPrevious = nextEntry.fPrevious;
            this.fPrevious.fNext = this;
            this.fNext.fPrevious = this;
        }

        void remove() {
            this.fPrevious.fNext = this.fNext;
            this.fNext.fPrevious = this.fPrevious;
        }

        void reinsert(Entry nextEntry) {
            this.fPrevious.fNext = this.fNext;
            this.fNext.fPrevious = this.fPrevious;
            this.fNext = nextEntry;
            this.fPrevious = nextEntry.fPrevious;
            this.fPrevious.fNext = this;
            this.fNext.fPrevious = this;
        }
    }

    private static class ElementDataKey {
        final Object fRootElement;
        final IVMNode fNode;
        final Object fViewerInput;
        final TreePath fPath;

        ElementDataKey(Object rootElement, IVMNode node, Object viewerInput, TreePath path) {
            this.fRootElement = rootElement;
            this.fNode = node;
            this.fViewerInput = viewerInput;
            this.fPath = path;
        }

        public String toString() {
            return this.fNode.toString() + " " + (this.fPath.getSegmentCount() == 0 ? this.fViewerInput.toString() : this.fPath.getLastSegment().toString());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ElementDataKey)) {
                return false;
            }
            ElementDataKey key = (ElementDataKey)obj;
            return (this.fNode == null && key.fNode == null || this.fNode != null && this.fNode.equals(key.fNode)) && (this.fRootElement == null && key.fRootElement == null || this.fRootElement != null && this.fRootElement.equals(key.fRootElement)) && (this.fViewerInput == null && key.fViewerInput == null || this.fViewerInput != null && this.fViewerInput.equals(key.fViewerInput)) && (this.fPath == null && key.fPath == null || this.fPath != null && this.fPath.equals((Object)key.fPath));
        }

        public int hashCode() {
            return (this.fRootElement != null ? this.fRootElement.hashCode() : 0) + (this.fNode != null ? this.fNode.hashCode() : 0) + (this.fViewerInput != null ? this.fViewerInput.hashCode() : 0) + (this.fPath != null ? this.fPath.hashCode() : 0);
        }
    }
}

