/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.viewmodel.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dd.dsf.debug.internal.ui.viewmodel.actions.MessagesForVMActions;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RetargetDebugContextAction
implements IWorkbenchWindowActionDelegate,
IDebugContextListener,
IActionDelegate2 {
    private IWorkbenchWindow fWindow = null;
    private IAction fAction = null;
    private ISelection fDebugContext;
    private Object fTargetAdapter = null;

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
        IDebugContextService debugContextService = DebugUITools.getDebugContextManager().getContextService(this.fWindow);
        debugContextService.addPostDebugContextListener((IDebugContextListener)this);
        this.fDebugContext = debugContextService.getActiveContext();
        this.update();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fAction != action) {
            this.fAction = action;
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        if (this.fTargetAdapter != null) {
            try {
                this.performAction(this.fTargetAdapter, this.fDebugContext);
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.fWindow.getShell(), (String)MessagesForVMActions.RetargetDebugContextAction_ErrorDialog_title, (String)MessagesForVMActions.RetargetDebugContextAction_ErrorDialog_message, (IStatus)e.getStatus());
            }
        }
    }

    protected abstract boolean canPerformAction(Object var1, ISelection var2);

    protected abstract void performAction(Object var1, ISelection var2) throws CoreException;

    protected abstract Class<?> getAdapterClass();

    public void init(IAction action) {
        this.fAction = action;
    }

    public void update() {
        Object object;
        IStructuredSelection ss;
        if (this.fAction == null) {
            return;
        }
        this.fTargetAdapter = null;
        if (this.fDebugContext instanceof IStructuredSelection && !(ss = (IStructuredSelection)this.fDebugContext).isEmpty() && (object = ss.getFirstElement()) instanceof IAdaptable) {
            this.fTargetAdapter = this.getAdapter((IAdaptable)object);
            if (this.fTargetAdapter != null) {
                this.fAction.setEnabled(this.canPerformAction(this.fTargetAdapter, this.fDebugContext));
                return;
            }
        }
        this.fAction.setEnabled(false);
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.fWindow).removePostDebugContextListener((IDebugContextListener)this);
        this.fTargetAdapter = null;
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.fDebugContext = event.getContext();
        this.update();
    }

    protected Object getAdapter(IAdaptable adaptable) {
        IAdapterManager adapterManager;
        Object adapter = adaptable.getAdapter(this.getAdapterClass());
        if (adapter == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)adaptable, this.getAdapterClass().getName())) {
            this.fTargetAdapter = adapterManager.loadAdapter((Object)adaptable, this.getAdapterClass().getName());
        }
        return adapter;
    }
}

