/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AutoResizeTableLayout
extends TableLayout
implements ControlListener {
    private final Table table;
    private List<ColumnLayoutData> columns = new ArrayList<ColumnLayoutData>();
    private boolean autosizing = false;

    public AutoResizeTableLayout(Table table) {
        this.table = table;
        table.addControlListener((ControlListener)this);
    }

    public void addColumnData(ColumnLayoutData data) {
        this.columns.add(data);
        super.addColumnData(data);
    }

    public void controlMoved(ControlEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controlResized(ControlEvent e) {
        if (this.autosizing) {
            return;
        }
        this.autosizing = true;
        try {
            this.autoSizeColumns();
        }
        finally {
            this.autosizing = false;
        }
    }

    private void autoSizeColumns() {
        int i;
        int width = this.table.getClientArea().width;
        if (width <= 1) {
            return;
        }
        TableColumn[] tableColumns = this.table.getColumns();
        int size = Math.min(this.columns.size(), tableColumns.length);
        int[] widths = new int[size];
        int fixedWidth = 0;
        int numberOfWeightColumns = 0;
        int totalWeight = 0;
        for (i = 0; i < size; ++i) {
            ColumnLayoutData col = this.columns.get(i);
            if (col instanceof ColumnPixelData) {
                int pixels;
                widths[i] = pixels = ((ColumnPixelData)col).width;
                fixedWidth += pixels;
                continue;
            }
            if (col instanceof ColumnWeightData) {
                ColumnWeightData cw = (ColumnWeightData)col;
                ++numberOfWeightColumns;
                int weight = cw.weight;
                totalWeight += weight;
                continue;
            }
            throw new IllegalStateException(Messages.AutoResizeTableLayout_UnknownColumnLayoutData);
        }
        if (numberOfWeightColumns > 0) {
            int rest = width - fixedWidth;
            int totalDistributed = 0;
            for (int i2 = 0; i2 < size; ++i2) {
                int pixels;
                ColumnLayoutData col = this.columns.get(i2);
                if (!(col instanceof ColumnWeightData)) continue;
                ColumnWeightData cw = (ColumnWeightData)col;
                int weight = cw.weight;
                int n = pixels = totalWeight == 0 ? 0 : weight * rest / totalWeight;
                if (pixels < cw.minimumWidth) {
                    pixels = cw.minimumWidth;
                }
                totalDistributed += pixels;
                widths[i2] = pixels;
            }
            int diff = rest - totalDistributed;
            int i3 = 0;
            while (diff > 0) {
                ColumnLayoutData col;
                if (i3 == size) {
                    i3 = 0;
                }
                if ((col = this.columns.get(i3)) instanceof ColumnWeightData) {
                    int n = i3;
                    widths[n] = widths[n] + 1;
                    --diff;
                }
                ++i3;
            }
        }
        for (i = 0; i < size; ++i) {
            if (tableColumns[i].getWidth() == widths[i]) continue;
            tableColumns[i].setWidth(widths[i]);
        }
    }
}

