/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ImmediateExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.ui.viewmodel.IVMAdapterExtension;
import org.eclipse.dd.dsf.ui.viewmodel.IVMEventListener;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

@ThreadSafe
public abstract class AbstractVMAdapter
implements IVMAdapterExtension {
    private boolean fDisposed;
    private final Map<IPresentationContext, IVMProvider> fViewModelProviders = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public IVMProvider getVMProvider(IPresentationContext context) {
        Map<IPresentationContext, IVMProvider> map = this.fViewModelProviders;
        synchronized (map) {
            if (this.fDisposed) {
                return null;
            }
            IVMProvider provider = this.fViewModelProviders.get(context);
            if (provider == null && (provider = this.createViewModelProvider(context)) != null) {
                this.fViewModelProviders.put(context, provider);
            }
            return provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVMProvider[] getActiveProviders() {
        Map<IPresentationContext, IVMProvider> map = this.fViewModelProviders;
        synchronized (map) {
            return this.fViewModelProviders.values().toArray(new IVMProvider[this.fViewModelProviders.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        IVMProvider[] providers = new IVMProvider[]{};
        Map<IPresentationContext, IVMProvider> map = this.fViewModelProviders;
        synchronized (map) {
            providers = this.fViewModelProviders.values().toArray(new IVMProvider[this.fViewModelProviders.size()]);
            this.fViewModelProviders.clear();
            this.fDisposed = true;
        }
        for (final IVMProvider provider : providers) {
            try {
                provider.getExecutor().execute(new Runnable(){

                    public void run() {
                        provider.dispose();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                // empty catch block
            }
        }
    }

    public boolean isDisposed() {
        return this.fDisposed;
    }

    public void update(IHasChildrenUpdate[] updates) {
        this.handleUpdate((IViewerUpdate[])updates);
    }

    public void update(IChildrenCountUpdate[] updates) {
        this.handleUpdate((IViewerUpdate[])updates);
    }

    public void update(IChildrenUpdate[] updates) {
        this.handleUpdate((IViewerUpdate[])updates);
    }

    private void handleUpdate(IViewerUpdate[] updates) {
        IVMProvider provider = this.getVMProvider(updates[0].getPresentationContext());
        if (provider != null) {
            this.updateProvider(provider, updates);
        } else {
            for (IViewerUpdate update : updates) {
                update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10005, "No model provider for update " + update, null));
                update.done();
            }
        }
    }

    private void updateProvider(final IVMProvider provider, final IViewerUpdate[] updates) {
        try {
            provider.getExecutor().execute(new Runnable(){

                public void run() {
                    if (updates instanceof IHasChildrenUpdate[]) {
                        provider.update((IHasChildrenUpdate[])updates);
                    } else if (updates instanceof IChildrenCountUpdate[]) {
                        provider.update((IChildrenCountUpdate[])updates);
                    } else if (updates instanceof IChildrenUpdate[]) {
                        provider.update((IChildrenUpdate[])updates);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (IViewerUpdate update : updates) {
                update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10005, "Display is disposed, cannot complete update " + update, null));
                update.done();
            }
        }
    }

    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        IVMProvider provider = this.getVMProvider(context);
        if (provider != null) {
            return provider.createModelProxy(element, context);
        }
        return null;
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        IVMProvider provider = this.getVMProvider(context);
        if (provider != null) {
            return provider.createColumnPresentation(context, element);
        }
        return null;
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        IVMProvider provider = this.getVMProvider(context);
        if (provider != null) {
            return provider.getColumnPresentationId(context, element);
        }
        return null;
    }

    public void update(IViewerInputUpdate update) {
        IVMProvider provider = this.getVMProvider(update.getPresentationContext());
        if (provider != null) {
            provider.update(update);
        }
    }

    @ThreadSafe
    protected abstract IVMProvider createViewModelProvider(IPresentationContext var1);

    protected final void handleEvent(final Object event) {
        ArrayList<IVMEventListener> eventListeners = new ArrayList<IVMEventListener>();
        this.aboutToHandleEvent(event);
        for (IVMProvider vmProvider : this.getActiveProviders()) {
            if (!(vmProvider instanceof IVMEventListener)) continue;
            eventListeners.add((IVMEventListener)((Object)vmProvider));
        }
        if (!eventListeners.isEmpty()) {
            CountingRequestMonitor crm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), null){

                protected void handleCompleted() {
                    if (AbstractVMAdapter.this.isDisposed()) {
                        return;
                    }
                    AbstractVMAdapter.this.doneHandleEvent(event);
                }
            };
            int count = 0;
            for (final IVMEventListener vmEventListener : eventListeners) {
                CountingRequestMonitor listenerRm = null;
                if (vmEventListener.shouldWaitHandleEventToComplete()) {
                    listenerRm = crm;
                    ++count;
                } else {
                    listenerRm = new RequestMonitor(ImmediateExecutor.getInstance(), null);
                }
                CountingRequestMonitor finalListenerRm = listenerRm;
                vmEventListener.getExecutor().execute((Runnable)new DsfRunnable((RequestMonitor)finalListenerRm){
                    final /* synthetic */ RequestMonitor val$finalListenerRm;
                    {
                        this.val$finalListenerRm = requestMonitor;
                    }

                    public void run() {
                        vmEventListener.handleEvent(event, this.val$finalListenerRm);
                    }
                });
            }
            crm.setDoneCount(count);
        } else {
            this.doneHandleEvent(event);
        }
    }

    protected void aboutToHandleEvent(Object event) {
    }

    protected void doneHandleEvent(Object event) {
    }
}

