/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusTypeDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ActiveOrMonitorInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.BusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ComponentInstanceNode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ComponentSignal;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.HierarchicalConnectionNode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Utilities {
    public static SpiritComponentDocument getComponentDocumentForHierConnection(DocumentChecker checker, HierarchicalConnectionNode hierConnection) {
        SpiritLibrary library = checker.getLibrary();
        SchemaInfo.IpxactVersion v = hierConnection.schemaVersion();
        String componentRef = null;
        switch (v) {
            case BEFORE_V14: {
                componentRef = hierConnection.getUniqueChildText("componentRef");
                break;
            }
            case V14: {
                ActiveOrMonitorInterface activeInterface = (ActiveOrMonitorInterface)hierConnection.getUniqueDescendantElement("activeInterface", ActiveOrMonitorInterface.class);
                componentRef = activeInterface.getSpiritAttribute("componentRef");
            }
        }
        SpiritDesignDocument designDocument = hierConnection.getContainingDesign();
        ComponentInstanceNode componentInstanceNode = designDocument.getComponentInstance(componentRef);
        if (componentInstanceNode == null) {
            return null;
        }
        SpiritNode vlnvNode = componentInstanceNode.getComponentRef();
        Vlnv componentVlnv = new Vlnv(vlnvNode);
        if (componentVlnv == null) {
            return null;
        }
        SpiritDocument result = library.get(componentVlnv);
        if (result instanceof SpiritComponentDocument) {
            return (SpiritComponentDocument)result;
        }
        return null;
    }

    public static Vlnv getBusTypeVlnvForActiveInterface(SpiritLibrary library, ActiveOrMonitorInterface activeInterfaceNode) {
        BusInterface busInterface = activeInterfaceNode.getBusInterface(library);
        if (busInterface == null) {
            return null;
        }
        SpiritNode vlnvNode = busInterface.getBusType();
        return new Vlnv(vlnvNode);
    }

    public static boolean areBusesCompatible(DocumentChecker checker, Vlnv busTypeFirst, Vlnv busTypeSecond) {
        if (busTypeFirst.equals((Object)busTypeSecond)) {
            return true;
        }
        if (Utilities.busExtends(checker, busTypeFirst, busTypeSecond)) {
            return true;
        }
        return Utilities.busExtends(checker, busTypeSecond, busTypeFirst);
    }

    public static boolean busExtends(DocumentChecker checker, Vlnv busTypeFirst, Vlnv busTypeSecond) {
        SpiritLibrary library = checker.getLibrary();
        SpiritDocument busTypeDoc = library.get(busTypeFirst);
        if (busTypeDoc == null || !(busTypeDoc instanceof SpiritBusTypeDocument)) {
            return false;
        }
        SpiritNode extendsNode = ((SpiritBusTypeDocument)busTypeDoc).getExtensionElement();
        if (extendsNode == null) {
            return false;
        }
        Vlnv extendsVlnv = new Vlnv(extendsNode);
        return extendsVlnv.equals((Object)busTypeSecond);
    }

    public static Map<String, ComponentSignal> getComponentSignals(SpiritDocument componentDocument) {
        LinkedHashMap<String, ComponentSignal> componentSignals = new LinkedHashMap<String, ComponentSignal>();
        NodeList signalNodes = componentDocument.getDescendants("signal");
        int length = signalNodes.getLength();
        for (int index = 0; index < length; ++index) {
            Element signalNode = (Element)signalNodes.item(index);
            ComponentSignal componentSignal = new ComponentSignal(signalNode);
            componentSignals.put(componentSignal.getName(), componentSignal);
        }
        return componentSignals;
    }

    public static boolean compareNodes(Node left, Node right) {
        boolean isEqualNode = Utilities.isEqualNode(left, right);
        NodeList leftChildren = left.getChildNodes();
        int length = leftChildren.getLength();
        if (isEqualNode && length > 0) {
            NodeList rightChildren = right.getChildNodes();
            for (int index = 0; isEqualNode && index < length; isEqualNode &= Utilities.compareNodes(leftChildren.item(index), rightChildren.item(index)), ++index) {
            }
        }
        return isEqualNode;
    }

    private static boolean isEqualNode(Node left, Node right) {
        if (left == null || right == null) {
            return false;
        }
        if (left == right) {
            return true;
        }
        if (left.getNodeType() != right.getNodeType()) {
            return false;
        }
        if (!left.getNodeName().equals(right.getNodeName())) {
            return false;
        }
        if (left.getNamespaceURI() == null ? right.getNamespaceURI() != null : !left.getNamespaceURI().equals(right.getNamespaceURI())) {
            return false;
        }
        if (left.getPrefix() == null ? right.getPrefix() != null : !left.getPrefix().equals(right.getPrefix())) {
            return false;
        }
        if (left.getNodeValue() == null) {
            if (right.getNodeValue() != null) {
                return false;
            }
        } else {
            if (right.getNodeValue() == null) {
                return false;
            }
            if (!left.getNodeValue().trim().equals(right.getNodeValue().trim())) {
                return false;
            }
        }
        left.normalize();
        right.normalize();
        NamedNodeMap leftAttrs = left.getAttributes();
        NamedNodeMap rightAttrs = right.getAttributes();
        if (leftAttrs == null) {
            if (rightAttrs != null) {
                return false;
            }
        } else {
            if (rightAttrs == null) {
                return false;
            }
            if (leftAttrs.getLength() != rightAttrs.getLength()) {
                return false;
            }
            for (int index = 0; index < leftAttrs.getLength(); ++index) {
                if (Utilities.isEqualNode(leftAttrs.item(index), rightAttrs.item(index))) continue;
                return false;
            }
        }
        return left.getNodeType() != 1 || left.getChildNodes().getLength() == right.getChildNodes().getLength();
    }
}

