/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.ISourceLookup;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.internal.MIPlugin;
import org.eclipse.dd.mi.service.command.commands.MIEnvironmentDirectory;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSourceLookup
extends AbstractDsfService
implements ISourceLookup {
    private Map<ISourceLookup.ISourceLookupDMContext, CSourceLookupDirector> fDirectors = new HashMap<ISourceLookup.ISourceLookupDMContext, CSourceLookupDirector>();
    ICommandControl fConnection;

    public CSourceLookup(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return MIPlugin.getBundleContext();
    }

    public void setSourceLookupDirector(ISourceLookup.ISourceLookupDMContext ctx, CSourceLookupDirector director) {
        this.fDirectors.put(ctx, director);
    }

    public void setSourceLookupPath(ISourceLookup.ISourceLookupDMContext ctx, ISourceContainer[] containers, RequestMonitor rm) {
        List<String> pathList = this.getSourceLookupPath(containers);
        String[] paths = pathList.toArray(new String[pathList.size()]);
        this.fConnection.queueCommand((ICommand)new MIEnvironmentDirectory((IDMContext)ctx, paths, false), new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    private List<String> getSourceLookupPath(ISourceContainer[] containers) {
        ArrayList<String> list = new ArrayList<String>(containers.length);
        for (int i = 0; i < containers.length; ++i) {
            File dir;
            IContainer container;
            IProject project;
            if (containers[i] instanceof ProjectSourceContainer && (project = ((ProjectSourceContainer)containers[i]).getProject()) != null && project.exists()) {
                list.add(project.getLocation().toPortableString());
            }
            if (containers[i] instanceof FolderSourceContainer && (container = ((FolderSourceContainer)containers[i]).getContainer()) != null && container.exists()) {
                list.add(container.getLocation().toPortableString());
            }
            if (containers[i] instanceof DirectorySourceContainer && (dir = ((DirectorySourceContainer)containers[i]).getDirectory()) != null && dir.exists()) {
                Path path = new Path(dir.getAbsolutePath());
                list.add(path.toPortableString());
            }
            if (!containers[i].isComposite()) continue;
            try {
                list.addAll(this.getSourceLookupPath(containers[i].getSourceContainers()));
                continue;
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return list;
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                CSourceLookup.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.register(new String[]{CSourceLookup.class.getName(), ISourceLookup.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public void getDebuggerPath(ISourceLookup.ISourceLookupDMContext sourceLookupCtx, Object source, final DataRequestMonitor<String> rm) {
        if (!(source instanceof String)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Only string source element is supported", null));
            rm.done();
            return;
        }
        final String sourceString = (String)source;
        if (!this.fDirectors.containsKey(sourceLookupCtx)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "No source director configured for given context", null));
            rm.done();
            return;
        }
        final CSourceLookupDirector director = this.fDirectors.get(sourceLookupCtx);
        new Job("Lookup Debugger Path"){

            protected IStatus run(IProgressMonitor monitor) {
                IPath debuggerPath = director.getCompilationPath(sourceString);
                if (debuggerPath != null) {
                    rm.setData((Object)debuggerPath.toString());
                } else {
                    rm.setData((Object)sourceString);
                }
                rm.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void getSource(ISourceLookup.ISourceLookupDMContext sourceLookupCtx, final String debuggerPath, final DataRequestMonitor<Object> rm) {
        if (!this.fDirectors.containsKey(sourceLookupCtx)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "No source director configured for given context", null));
            rm.done();
            return;
        }
        final CSourceLookupDirector director = this.fDirectors.get(sourceLookupCtx);
        new Job("Lookup Source"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Object[] sources = director.findSourceElements((Object)debuggerPath);
                    if (sources == null || sources.length == 0) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "No sources found", null));
                    } else {
                        rm.setData(sources[0]);
                    }
                }
                catch (CoreException e) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Source lookup failed", (Throwable)e));
                }
                finally {
                    rm.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

