/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ImmediateExecutor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.service.IMIBackend;
import org.eclipse.dd.mi.service.command.AbstractCLIProcess;

public class MIBackendCLIProcess
extends AbstractCLIProcess {
    private IMIBackend fMIBackend;
    private AtomicInteger fExitCode = new AtomicInteger(-1);
    private BackedExitedEventListener fExitedEventListener;

    @ConfinedToDsfExecutor(value="getSession()#getExecutor")
    public MIBackendCLIProcess(ICommandControlService commandControl, IMIBackend backend) throws IOException {
        super(commandControl);
        this.fMIBackend = backend;
        if (this.fMIBackend.getState() == IMIBackend.State.TERMINATED) {
            this.fExitCode.set(this.fMIBackend.getExitCode());
        }
        this.fExitedEventListener = new BackedExitedEventListener();
        this.getSession().addServiceEventListener((Object)this.fExitedEventListener, null);
    }

    public int waitFor() throws InterruptedException {
        if (!DsfSession.isSessionActive((String)this.getSession().getId())) {
            return this.fExitCode.get();
        }
        try {
            Query<Object> query = new Query<Object>(){

                protected void execute(DataRequestMonitor<Object> rm) {
                    if (!DsfSession.isSessionActive((String)MIBackendCLIProcess.this.getSession().getId()) || MIBackendCLIProcess.this.isDisposed() || MIBackendCLIProcess.this.fMIBackend.getState() == IMIBackend.State.TERMINATED) {
                        rm.setData(new Object());
                        rm.done();
                    } else {
                        MIBackendCLIProcess.this.fExitedEventListener.fWaitForRMs.add(new RequestMonitor(ImmediateExecutor.getInstance(), (RequestMonitor)rm, (DataRequestMonitor)rm){
                            final /* synthetic */ DataRequestMonitor val$rm;
                            {
                                this.val$rm = dataRequestMonitor;
                                super(x0, x1);
                            }

                            protected void handleSuccess() {
                                this.val$rm.setData(new Object());
                                this.val$rm.done();
                            }
                        });
                    }
                }
            };
            this.getSession().getExecutor().execute((Runnable)query);
            query.get();
        }
        catch (RejectedExecutionException e) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return this.fExitCode.get();
    }

    public int exitValue() {
        block5: {
            if (!DsfSession.isSessionActive((String)this.getSession().getId())) {
                return this.fExitCode.get();
            }
            try {
                this.getSession().getExecutor().submit((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        if (MIBackendCLIProcess.this.fMIBackend.getState() != IMIBackend.State.TERMINATED) {
                            throw new IllegalThreadStateException("Backend Process has not exited");
                        }
                        return null;
                    }
                }).get();
            }
            catch (RejectedExecutionException e) {
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof RuntimeException)) break block5;
                throw (RuntimeException)e.getCause();
            }
        }
        return this.fExitCode.get();
    }

    public void destroy() {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (!DsfSession.isSessionActive((String)MIBackendCLIProcess.this.getSession().getId())) {
                        return;
                    }
                    if (MIBackendCLIProcess.this.isDisposed()) {
                        return;
                    }
                    MIBackendCLIProcess.this.fMIBackend.destroy();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void dispose() {
        this.fExitedEventListener.dispose();
        this.getSession().removeServiceEventListener((Object)this.fExitedEventListener);
        super.dispose();
    }

    public class BackedExitedEventListener {
        private final List<RequestMonitor> fWaitForRMs = new ArrayList<RequestMonitor>();

        @DsfServiceEventHandler
        public void eventDispatched(IMIBackend.BackendStateChangedEvent event) {
            if (event.getState() == IMIBackend.State.TERMINATED && event.getBackendId().equals(MIBackendCLIProcess.this.fMIBackend.getId())) {
                MIBackendCLIProcess.this.fExitCode.set(MIBackendCLIProcess.this.fMIBackend.getExitCode());
                for (RequestMonitor rm : this.fWaitForRMs) {
                    rm.done();
                }
                this.fWaitForRMs.clear();
            }
        }

        void dispose() {
            for (RequestMonitor rm : this.fWaitForRMs) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Backend terminate event never received", null));
                rm.done();
            }
            this.fWaitForRMs.clear();
        }
    }
}

