/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation;

import java.util.Collection;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.CSourceTag;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.ISourceTag;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.ISourceTagListener;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.ISourceTagProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSourceTagProvider
implements ISourceTagProvider {
    private ListenerList fListenerList = new ListenerList(1);
    private ITranslationUnit fUnit;

    public CSourceTagProvider(ITranslationUnit unit) {
        this.fUnit = unit;
    }

    @Override
    public void addSourceTagListener(ISourceTagListener listener) {
        this.fListenerList.add((Object)listener);
    }

    @Override
    public int[] getActiveCodePositions() {
        return null;
    }

    @Override
    public long getSnapshotTime() {
        return 0L;
    }

    @Override
    public void getSourceTags(Collection<ISourceTag> target) {
        try {
            this.convertToSourceTags(this.fUnit.getChildren(), target);
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
    }

    private ISourceTag convertToSourceTag(ICElement element) {
        if (element instanceof ISourceReference) {
            return new CSourceTag((ISourceReference)element, element.getElementType());
        }
        return null;
    }

    private void convertToSourceTags(ICElement[] children, Collection<ISourceTag> target) throws CModelException {
        for (int i = 0; i < children.length; ++i) {
            ICElement element = children[i];
            ISourceTag tag = this.convertToSourceTag(element);
            if (tag != null) {
                target.add(tag);
            }
            if (!(element instanceof IParent)) continue;
            this.convertToSourceTags(((IParent)element).getChildren(), target);
        }
    }

    @Override
    public void removeSourceTagListener(ISourceTagListener listener) {
        this.fListenerList.remove((Object)listener);
    }
}

