/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.document;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.ipxact.editor.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritSignal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpiritBusTypeDocument
extends SpiritDocument {
    public SpiritBusTypeDocument(Document xmlDoc) {
        super(xmlDoc);
    }

    public List<SpiritSignal> getSignals() {
        return this.getDescendants("signal", SpiritSignal.class);
    }

    public SpiritSignal getSignalByName(String name) {
        return this.getNamedSubitem("signal", name, SpiritSignal.class);
    }

    public List<SpiritSignal> resolveExtends(SpiritLibrary library) throws Exception {
        ArrayList<SpiritSignal> extendedSignalNodes;
        SpiritNode extendNode = this.getExtensionElement();
        if (extendNode != null) {
            Vlnv baseVlnv = new Vlnv(SpiritNode.createSpiritNode(extendNode));
            SpiritDocument doc = library.get(baseVlnv);
            if (doc == null) {
                throw new Exception(Messages.SpiritBusDefinitionDocument_UnableToLocateBusDefinition + baseVlnv);
            }
            if (!(doc instanceof SpiritBusTypeDocument)) {
                throw new Exception(Messages.SpiritBusDefinitionDocument_DoesNotReferToBusDefinition + baseVlnv);
            }
            extendedSignalNodes = ((SpiritBusTypeDocument)doc).resolveExtends(library);
        } else {
            extendedSignalNodes = new ArrayList();
        }
        String signalOrPort = SchemaInfo.getSpiritString("signal", this.getNamespaceURI());
        NodeList signalList = this.getDescendants(signalOrPort);
        for (int i = 0; i < signalList.getLength(); ++i) {
            SpiritSignal thisSignal = new SpiritSignal((Element)signalList.item(i));
            extendedSignalNodes.add(thisSignal);
        }
        return extendedSignalNodes;
    }

    public SpiritNode getExtensionElement() {
        return this.getUniqueChildElement("extends", SpiritNode.class);
    }
}

