/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.SpiritUiPlugin;
import org.eclipse.dd.ipxact.editor.ui.models.VlnvRefFilter;
import org.eclipse.dd.ipxact.editor.ui.models.VlnvReferencesModel;
import org.eclipse.dd.ipxact.editor.ui.utils.ExternalFileEditorInput;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAction;
import org.eclipse.wst.xml.core.internal.document.NodeContainer;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xml.core.internal.validation.eclipse.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class EditorHelper {
    public static String getEditorId(IPath location) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(location.lastSegment(), EditorHelper.getContentType(location));
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IContentType getContentType(IPath location) {
        if (location == null) {
            return null;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(location.toFile());
            IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor((InputStream)stream, location.lastSegment());
            return iContentType;
        }
        catch (IOException x) {
            SpiritUiPlugin.logError(x);
            IContentType iContentType = null;
            return iContentType;
        }
        finally {
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException x) {}
        }
    }

    public static IEditorInput createEditorInput(IPath location) {
        IFile workspaceFile = FileDetails.getWorkspaceFile((IPath)location);
        if (workspaceFile != null) {
            return new FileEditorInput(workspaceFile);
        }
        return new ExternalFileEditorInput(EFS.getLocalFileSystem().getStore(location));
    }

    public static IEditorPart openSpiritDocumentInEditor(IWorkbenchPage page, SpiritDocument spiritDocument) {
        IEditorPart editor = null;
        try {
            String docUriString;
            if (spiritDocument != null && (docUriString = spiritDocument.getBaseDocument().getDocumentURI()) != null) {
                URI uri = new URI(docUriString);
                IPath location = URIUtil.toPath((URI)uri);
                editor = EditorHelper.openLocationInEditor(page, location);
            }
        }
        catch (Throwable t) {
            SpiritUiPlugin.showError(page.getActivePart().getTitle(), 20001, Messages.EditorHelper_UnableToOpenDocumentEditor, t);
        }
        return editor;
    }

    public static IEditorPart openLocationInEditor(IWorkbenchPage page, IPath location) {
        IEditorPart editor = null;
        try {
            String editorId = EditorHelper.getEditorId(location);
            IEditorInput editorInput = EditorHelper.createEditorInput(location);
            editor = page.openEditor(editorInput, editorId);
        }
        catch (Throwable t) {
            SpiritUiPlugin.showError(page.getActivePart().getTitle(), 20001, Messages.EditorHelper_UnableToOpenDocumentEditor, t);
        }
        return editor;
    }

    public static Document getXmlDocument(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        return (Document)editor.getAdapter(Document.class);
    }

    public static void openSpecialSelectionInEditor(IWorkbenchPage page, Object selection) {
        File file = null;
        Element element = null;
        Vlnv vlnvRef = null;
        int orderIndex = -1;
        if (selection instanceof ResultElement) {
            file = ((ResultElement)selection).file;
        }
        if (selection instanceof VlnvReferencesModel.VlnvReferencesModelElement) {
            VlnvReferencesModel.VlnvReferencesModelElement vlnvReferencesModelElement = (VlnvReferencesModel.VlnvReferencesModelElement)selection;
            file = vlnvReferencesModelElement.owner;
            vlnvRef = vlnvReferencesModelElement.vlnv;
            element = vlnvReferencesModelElement.element;
            orderIndex = vlnvReferencesModelElement.orderIndex;
        }
        if (file != null) {
            try {
                Element matchElement;
                Vlnv matchingVlnvRef;
                Document xmlDocument;
                List<Element> elements;
                IPath location = Path.fromOSString((String)file.getAbsolutePath());
                String editorId = EditorHelper.getEditorId(location);
                IEditorInput editorInput = EditorHelper.createEditorInput(location);
                IEditorPart editor = page.openEditor(editorInput, editorId);
                if (editor != null && element != null && orderIndex < (elements = VlnvRefFilter.getVlnvRefElementList(xmlDocument = (Document)editor.getAdapter(Document.class))).size() && (matchingVlnvRef = new Vlnv(SpiritNode.createSpiritNode((Element)(matchElement = elements.get(orderIndex))))).equals((Object)vlnvRef) && matchElement instanceof NodeContainer) {
                    IStructuredDocumentRegion StructuredDocumentRegion = ((NodeContainer)matchElement).getStartStructuredDocumentRegion();
                    ITextEditor textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
                    textEditor.selectAndReveal(StructuredDocumentRegion.getStartOffset(), StructuredDocumentRegion.getLength());
                }
            }
            catch (Throwable t) {
                SpiritUiPlugin.showError(page.getActivePart().getTitle(), 20001, Messages.EditorHelper_UnableToOpenEditor, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element maybeInsertElementNS(Element parent, String namespaceURI, String prefix, String childElementName) {
        if (!(parent instanceof IDOMElement)) {
            return null;
        }
        try {
            NodeList nodeList;
            IDOMElement element = (IDOMElement)parent;
            ModelQuery modelQuery = null;
            IStructuredModel structuredModel = null;
            try {
                structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)element.getStructuredDocument());
                modelQuery = ModelQueryUtil.getModelQuery((IStructuredModel)structuredModel);
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
            if (modelQuery == null) {
                return null;
            }
            modelQuery.getCMDocumentManager().setPropertyEnabled("autoLoad", true);
            CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration((Element)element);
            if (cmElementDeclaration == null) {
                return null;
            }
            int editMode = modelQuery.getEditMode();
            int ic = 2;
            int vc = editMode == 2 ? 2 : 0;
            ArrayList modelQueryActionList = new ArrayList();
            modelQuery.getInsertActions((Element)element, cmElementDeclaration, -1, ic, vc, modelQueryActionList);
            for (ModelQueryAction modelQueryAction : modelQueryActionList) {
                String nodeName = modelQueryAction.getCMNode().getNodeName();
                if (!nodeName.equals(childElementName)) continue;
                Document document = parent.getOwnerDocument();
                String qualifiedName = prefix + childElementName;
                Element childElement = document.createElementNS(namespaceURI, qualifiedName);
                NodeList nodeList2 = parent.getChildNodes();
                int index = modelQueryAction.getEndIndex();
                if (index == -1) {
                    index = nodeList2.getLength();
                }
                Node refChild = index < nodeList2.getLength() ? nodeList2.item(index) : null;
                parent.insertBefore(childElement, refChild);
                break;
            }
            if ((nodeList = parent.getElementsByTagNameNS(namespaceURI, childElementName)).getLength() > 0) {
                return (Element)nodeList.item(0);
            }
        }
        catch (Exception e) {
            SpiritUiPlugin.logError(Messages.EditorHelper_ProblemWithContentModel, e);
        }
        SpiritUiPlugin.logErrorMessage(Messages.EditorHelper_ProblemWithContentModel + Messages.EditorHelper_ElementNotCreated);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginUndoRecording(Element parent, Object requester, String label) {
        if (!(parent instanceof IDOMElement)) {
            return;
        }
        IDOMElement element = (IDOMElement)parent;
        IStructuredModel structuredModel = null;
        try {
            structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)element.getStructuredDocument());
            structuredModel.beginRecording(requester, label);
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endUndoRecording(Element parent, Object requester) {
        if (!(parent instanceof IDOMElement)) {
            return;
        }
        IDOMElement element = (IDOMElement)parent;
        IStructuredModel structuredModel = null;
        try {
            structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)element.getStructuredDocument());
            structuredModel.endRecording(requester);
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
    }

    public static int getStartOffset(Node node) {
        if (node instanceof NodeContainer) {
            return ((NodeContainer)node).getStartStructuredDocumentRegion().getStartOffset();
        }
        return 0;
    }

    public static int getEndOffset(Node node) {
        if (node instanceof NodeContainer) {
            return ((NodeContainer)node).getStartStructuredDocumentRegion().getEndOffset();
        }
        return 0;
    }

    public static boolean isXmlValid(IEditorPart editor) {
        IPath location;
        File file;
        if (editor == null) {
            return false;
        }
        IEditorInput editorInput = editor.getEditorInput();
        ILocationProvider locationProvider = (ILocationProvider)editorInput.getAdapter(ILocationProvider.class);
        if (locationProvider != null && (file = EditorHelper.getFile(location = locationProvider.getPath((Object)editorInput))) != null) {
            try {
                String uri = file.toURI().toString();
                Document xmlDocument = EditorHelper.getXmlDocument(editor);
                IStructuredDocument structuredDocument = ((NodeContainer)xmlDocument.getDocumentElement()).getStructuredDocument();
                byte[] bytes = structuredDocument.get().getBytes("UTF-8");
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                Validator validator = new Validator();
                ValidationReport validationReport = validator.validate(uri, (InputStream)stream, null);
                ValidationMessage[] validationMessages = validationReport.getValidationMessages();
                return validationMessages.length == 0;
            }
            catch (Exception x) {
                SpiritUiPlugin.logError(x);
            }
        }
        return false;
    }

    public static File getFile(IPath location) {
        if (location == null) {
            return null;
        }
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getFile(location).getLocation();
        if (workspaceLocation != null) {
            return workspaceLocation.toFile();
        }
        return location.toFile();
    }

    public static class ResultElement {
        public final File file;
        public final String documentType;

        public ResultElement(File file, String documentType) {
            this.file = file;
            this.documentType = documentType;
        }
    }
}

