/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.CheckVisitor;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;

public class Check65Visitor
extends CheckVisitor {
    public Check65Visitor(ICheckerReporter reporter) {
        super(reporter);
    }

    public boolean visit(HierarchicalConnection hierarchicalConnection) {
        Map signalMapElements = hierarchicalConnection.busInterface.getSignalNames();
        Map refSignalNames = hierarchicalConnection.refBusInterface.getSignalNames();
        if (signalMapElements != null && refSignalNames != null) {
            String message = Messages.Check65Visitor_0;
            for (String busSignalName : signalMapElements.keySet()) {
                if (refSignalNames.containsKey(busSignalName)) continue;
                this.reporter.report(CheckList.CHECK_65, null, MessageFormat.format(message, hierarchicalConnection.busInterface, hierarchicalConnection.busInterfaceDoc.getVlnv(), busSignalName, hierarchicalConnection.refBusInterface, hierarchicalConnection.refBusInterfaceDoc.getVlnv()));
                ++this.problems;
            }
            for (String busSignalName : refSignalNames.keySet()) {
                if (signalMapElements.containsKey(busSignalName)) continue;
                this.reporter.report(CheckList.CHECK_65, null, MessageFormat.format(message, hierarchicalConnection.refBusInterface, hierarchicalConnection.refBusInterfaceDoc.getVlnv(), busSignalName, hierarchicalConnection.busInterface, hierarchicalConnection.busInterfaceDoc.getVlnv()));
                ++this.problems;
            }
        }
        return true;
    }
}

