/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.spiritnodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.GenericBusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusInterface
extends GenericBusInterface {
    static final HashMap<String, Mode> modeStrings = new HashMap<String, Mode>(){
        private static final long serialVersionUID = 4796052773072623023L;
        {
            this.put("master", Mode.MASTER);
            this.put("slave", Mode.SLAVE);
            this.put("system", Mode.SYSTEM);
            this.put("mirroredMaster", Mode.MIRRORED_MASTER);
            this.put("mirroredSlave", Mode.MIRRORED_SLAVE);
            this.put("mirroredSystem", Mode.MIRRORED_SYSTEM);
            this.put("monitor", Mode.MONITOR);
        }
    };
    private String modeString;
    private Mode mode;

    public BusInterface(Element node) {
        super(node);
    }

    @Override
    public String getModeString() {
        this.getMode();
        return this.modeString;
    }

    private Mode getMode() {
        if (this.mode == null) {
            try {
                for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() != 1 || !child.getNamespaceURI().equals(this.getNamespaceURI())) continue;
                    String localName = child.getLocalName();
                    this.mode = modeStrings.get(localName);
                    if (this.mode == null) continue;
                    this.modeString = localName;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.mode;
    }

    public boolean isMaster() {
        return this.getMode() == Mode.MASTER;
    }

    public boolean isSlave() {
        return this.getMode() == Mode.SLAVE;
    }

    public boolean isSystem() {
        return this.getMode() == Mode.SYSTEM;
    }

    public boolean isMirroredMaster() {
        return this.getMode() == Mode.MIRRORED_MASTER;
    }

    public boolean isMirroredSlave() {
        return this.getMode() == Mode.MIRRORED_SLAVE;
    }

    public boolean isMirroredSystem() {
        return this.getMode() == Mode.MIRRORED_SYSTEM;
    }

    @Override
    public boolean isMirrored() {
        return this.isMirroredMaster() || this.isMirroredSlave() || this.isMirroredSystem();
    }

    @Override
    public boolean isMonitor() {
        return this.getMode() == Mode.MONITOR;
    }

    public Vlnv getVlnv() {
        SpiritNode busTypeNode = this.getBusType();
        return new Vlnv(busTypeNode);
    }

    public List<String> getMasterRefs() {
        ArrayList<String> result = new ArrayList<String>();
        NodeList bridgeNodes = this.getDescendants("bridge");
        for (int mri = 0; mri < bridgeNodes.getLength(); ++mri) {
            Node n = bridgeNodes.item(mri);
            result.add(((Element)n).getAttributeNS(this.getNamespaceURI(), "masterRef").trim());
        }
        return result;
    }

    public String getMemoryMapRef() {
        SpiritNode memoryMapNode = this.getUniqueDescendantElement("memoryMapRef", SpiritNode.class);
        if (memoryMapNode != null) {
            return memoryMapNode.getSpiritAttribute("memoryMapRef").trim();
        }
        return "";
    }

    public String getAddressSpaceRef() {
        SpiritNode addressSpaceNode = this.getUniqueDescendantElement("addressSpaceRef", SpiritNode.class);
        if (addressSpaceNode != null) {
            return addressSpaceNode.getSpiritAttribute("addressSpaceRef").trim();
        }
        return "";
    }

    @Override
    public String getSystemGroup() {
        return this.getUniqueDescendantText("group");
    }

    @Override
    public String getMonitorInterfaceType() {
        if (this.isMonitor()) {
            SpiritNode e = this.getUniqueDescendantElement("monitor", SpiritNode.class);
            return e.getSpiritAttribute("interfaceType").trim();
        }
        return null;
    }

    public String getConnectionType() {
        return this.getUniqueDescendantText("connection");
    }

    public String getIndex() {
        return this.getUniqueDescendantText("index");
    }

    public String getBitSteering() {
        return this.getUniqueDescendantText("bitSteering");
    }

    public String getEndianness() {
        String endianness = this.getUniqueDescendantText("endianness");
        if (endianness.equals("")) {
            endianness = "little";
        }
        return endianness;
    }

    public SpiritNode getBusType() {
        return this.getUniqueChildElement("busType", SpiritNode.class);
    }

    @Override
    public Vlnv getAbstractionVlnv() {
        SpiritNode abstractionTypeNode = this.getUniqueDescendantElement("abstractionType", SpiritNode.class);
        if (abstractionTypeNode != null) {
            return new Vlnv(abstractionTypeNode);
        }
        return null;
    }

    public SpiritComponentDocument getContainingComponent() {
        return new SpiritComponentDocument(super.getOwnerDocument());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        MASTER,
        SLAVE,
        SYSTEM,
        MIRRORED_MASTER,
        MIRRORED_SLAVE,
        MIRRORED_SYSTEM,
        MONITOR;

    }
}

