/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel;

import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVMNode
implements IVMNode {
    private final AbstractVMProvider fProvider;
    private boolean fDisposed = false;

    public AbstractVMNode(AbstractVMProvider provider) {
        this.fProvider = provider;
    }

    protected Executor getExecutor() {
        return this.fProvider.getExecutor();
    }

    @Override
    public IVMProvider getVMProvider() {
        return this.fProvider;
    }

    @Override
    public void dispose() {
        this.fDisposed = true;
    }

    @Override
    public void getContextsForEvent(VMDelta parentDelta, Object event, DataRequestMonitor<IVMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10003, "", null));
        rm.done();
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    protected boolean checkUpdate(IViewerUpdate update) {
        if (update.isCanceled()) {
            update.done();
            return false;
        }
        if (this.fDisposed) {
            this.handleFailedUpdate(update);
            return false;
        }
        return true;
    }

    protected void handleFailedUpdate(IViewerUpdate update) {
        if (update instanceof IHasChildrenUpdate) {
            ((IHasChildrenUpdate)update).setHasChilren(false);
        } else if (update instanceof IChildrenCountUpdate) {
            ((IChildrenCountUpdate)update).setChildCount(0);
        } else if (update instanceof ILabelUpdate) {
            ILabelUpdate labelUpdate = (ILabelUpdate)update;
            String[] columns = labelUpdate.getColumnIds();
            for (int i = 0; i < (columns != null ? columns.length : 1); ++i) {
                labelUpdate.setLabel("...", i);
            }
        }
        update.done();
    }
}

