/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ActiveOrMonitorInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.BusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.MonitorInterconnection;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class CheckMonitorInterfaces {
    public static int checkMonitorConnections(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        SpiritLibrary library = checker.getLibrary();
        HashMap<String, BusInterface> activeBusInterfaceMap = new HashMap<String, BusInterface>();
        HashMap<String, BusInterface> monitorBusInterfaceMap = new HashMap<String, BusInterface>();
        NodeList nodes = theDoc.getDescendants("monitorInterconnection");
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            Element interconnectionNode = (Element)nodes.item(index);
            MonitorInterconnection interconnection = new MonitorInterconnection(interconnectionNode);
            ActiveOrMonitorInterface activeInterfaceNode = interconnection.getActiveInterface();
            BusInterface activeBusInterface = activeInterfaceNode.getBusInterface(library);
            if (activeBusInterface == null) continue;
            String activeInterfaceType = activeBusInterface.getModeString();
            String systemGroup = null;
            if (activeBusInterface.isSystem() || activeBusInterface.isMirroredSystem()) {
                systemGroup = activeBusInterface.getSystemGroup();
            }
            if (activeBusInterfaceMap.put(activeBusInterface.toString(), activeBusInterface) != null) {
                reporter.report(CheckList.CHECK_36, theDoc, MessageFormat.format(Messages.CheckMonitorInterfaces_3, activeBusInterface), interconnectionNode);
                ++nErrors;
            }
            ArrayList<BusInterface> monitorBusInterfaces = new ArrayList<BusInterface>();
            NodeList monitorInterfaceNodes = interconnection.getDescendants("monitorInterface");
            for (int mIndex = 0; mIndex < monitorInterfaceNodes.getLength(); ++mIndex) {
                ActiveOrMonitorInterface monitorInterfaceNode = (ActiveOrMonitorInterface)SpiritNode.createSpiritNode((Element)((Element)monitorInterfaceNodes.item(mIndex)));
                BusInterface monitorBusInterface = monitorInterfaceNode.getBusInterface(library);
                if (monitorBusInterface == null) continue;
                monitorBusInterface.setContext(SpiritNode.createSpiritNode((SpiritNode)monitorInterfaceNode).getSpiritAttribute("componentRef"));
                monitorBusInterfaces.add(monitorBusInterface);
                if (monitorBusInterfaceMap.put(monitorBusInterface.toString(), monitorBusInterface) == null) continue;
                reporter.report(CheckList.CHECK_36, theDoc, MessageFormat.format(Messages.CheckMonitorInterfaces_6, monitorBusInterface), interconnectionNode);
                ++nErrors;
            }
            if (monitorBusInterfaces.isEmpty()) {
                reporter.report(CheckList.CHECK_WARNING, theDoc, Messages.CheckMonitorInterfaces_7, interconnectionNode);
                ++nErrors;
                continue;
            }
            if (activeBusInterface.schemaVersion() == SchemaInfo.IpxactVersion.BEFORE_V14 && activeBusInterface.isMonitor()) {
                reporter.report(CheckList.CHECK_32, theDoc, MessageFormat.format(Messages.CheckMonitorInterfaces_8, activeBusInterface, activeInterfaceType), interconnectionNode);
                ++nErrors;
            }
            for (BusInterface monitorBusInterface : monitorBusInterfaces) {
                String monitorInterfaceType;
                if (!monitorBusInterface.isMonitor()) {
                    reporter.report(CheckList.CHECK_33, theDoc, MessageFormat.format(Messages.CheckMonitorInterfaces_9, monitorBusInterface), interconnectionNode);
                    ++nErrors;
                }
                if (!activeInterfaceType.equals(monitorInterfaceType = monitorBusInterface.getMonitorInterfaceType())) {
                    reporter.report(CheckList.CHECK_34, theDoc, MessageFormat.format(Messages.CheckMonitorInterfaces_10, monitorBusInterface, monitorInterfaceType, activeInterfaceType), interconnectionNode);
                    ++nErrors;
                }
                String monitorGroup = monitorBusInterface.getSystemGroup();
                if (systemGroup == null || systemGroup.equals(monitorGroup)) continue;
                reporter.report(CheckList.CHECK_35, theDoc, MessageFormat.format(Messages.CheckMonitorInterfaces_11, monitorBusInterface, monitorGroup, systemGroup), interconnectionNode);
                ++nErrors;
            }
        }
        return nErrors;
    }
}

