/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.disassembly;

import java.math.BigInteger;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.DisassemblyRulerColumn;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.AddressRangePosition;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.SourceFileInfo;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.SourcePosition;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;

public class AddressRulerColumn
extends DisassemblyRulerColumn
implements IVerticalRulerInfo,
IVerticalRulerInfoExtension,
IAnnotationHover {
    private int fRadix;
    private boolean fShowRadixPrefix;
    private String fRadixPrefix;
    private int fNumberOfDigits;
    private int fAddressSize;

    public AddressRulerColumn() {
        super(16384);
        this.setShowRadixPrefix(true);
        this.setAddressSize(32);
        this.setRadix(16);
    }

    protected String createDisplayString(int line) {
        DisassemblyDocument doc = (DisassemblyDocument)this.getParentRuler().getTextViewer().getDocument();
        try {
            int offset = doc.getLineOffset(line);
            AddressRangePosition pos = doc.getDisassemblyPosition(offset);
            if (pos != null && pos.length > 0 && pos.offset == offset) {
                if (pos.fValid) {
                    return this.getAddressText(pos.fAddressOffset);
                }
                return "......................................................................".substring(0, this.computeNumberOfCharacters());
            }
            SourcePosition srcPos = doc.getSourcePosition(offset);
            if (srcPos != null && srcPos.fValid && srcPos.length > 0) {
                int nLines;
                int srcLine;
                if (srcPos.fFileInfo.fSource == null) {
                    srcLine = srcPos.fLine;
                    nLines = srcLine + 1;
                } else {
                    int delta = offset - srcPos.offset;
                    int baseOffset = srcPos.fFileInfo.fSource.getLineOffset(srcPos.fLine);
                    srcLine = srcPos.fFileInfo.fSource.getLineOfOffset(baseOffset + delta);
                    nLines = srcPos.fFileInfo.fSource.getNumberOfLines();
                }
                String digitStr = Integer.toString(srcLine + 1);
                int maxDigits = (int)(Math.log(nLines) / Math.log(10.0)) + 1;
                return "                                                                      ".substring(0, maxDigits - digitStr.length()) + digitStr;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return "";
    }

    protected int computeNumberOfCharacters() {
        return this.fNumberOfDigits + (this.fRadixPrefix != null ? this.fRadixPrefix.length() : 0) + 1;
    }

    public void setAddressSize(int bits) {
        this.fAddressSize = bits;
        this.calculateNumberOfDigits();
    }

    public void setRadix(int radix) {
        this.fRadix = radix;
        this.calculateNumberOfDigits();
        this.setShowRadixPrefix(this.fShowRadixPrefix);
    }

    private void calculateNumberOfDigits() {
        this.fNumberOfDigits = BigInteger.ONE.shiftLeft(this.fAddressSize).subtract(BigInteger.ONE).toString(this.fRadix).length();
    }

    public void setShowRadixPrefix(boolean showRadixPrefix) {
        this.fShowRadixPrefix = showRadixPrefix;
        this.fRadixPrefix = !this.fShowRadixPrefix ? null : (this.fRadix == 16 ? "0x" : (this.fRadix == 8 ? "0" : null));
    }

    private String getAddressText(BigInteger address) {
        StringBuffer buf = new StringBuffer(this.fNumberOfDigits + 3);
        if (this.fRadixPrefix != null) {
            buf.append(this.fRadixPrefix);
        }
        String str = address.toString(this.fRadix);
        for (int i = str.length(); i < this.fNumberOfDigits; ++i) {
            buf.append('0');
        }
        buf.append(str);
        buf.append(':');
        return buf.toString();
    }

    public int getLineOfLastMouseButtonActivity() {
        return this.getParentRuler().getLineOfLastMouseButtonActivity();
    }

    public int toDocumentLineNumber(int y_coordinate) {
        return this.getParentRuler().toDocumentLineNumber(y_coordinate);
    }

    public IAnnotationHover getHover() {
        return this;
    }

    public IAnnotationModel getModel() {
        return null;
    }

    public void addVerticalRulerListener(IVerticalRulerListener listener) {
    }

    public void removeVerticalRulerListener(IVerticalRulerListener listener) {
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int line) {
        BigInteger address;
        DisassemblyDocument doc = (DisassemblyDocument)this.getParentRuler().getTextViewer().getDocument();
        SourceFileInfo info = doc.getSourceInfo(address = doc.getAddressOfLine(line));
        if (info != null) {
            return info.fFile.getFullPath().toOSString();
        }
        return null;
    }
}

