/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritAbstractionDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritAbstractorDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusTypeDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.AbstractorInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.BusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ComponentSignal;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.GenericBusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.OnMode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SignalMapElement;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritSignal;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CheckSignals {
    public static int checkSignalsDefinedForComponent(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList nodes = theDoc.getDescendants("signal");
        if (nodes.getLength() < 1) {
            reporter.report(CheckList.CHECK_INFORMATION, theDoc, Messages.CheckSignals_7);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkNoDuplicateSignalsInBusDefinition(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList nodes = theDoc.getDescendants("logicalName");
        HashMap<String, Node> signals = new HashMap<String, Node>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node signalNameNode = nodes.item(i);
            String signalName = SpiritNode.getTextContent((Node)signalNameNode);
            Node oldNode = signals.put(signalName, signalNameNode);
            if (oldNode == null) continue;
            reporter.report(CheckList.CHECK_ERROR, theDoc, MessageFormat.format(Messages.CheckSignals_4, signalName), signalNameNode);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkSignalsDefinedForBusDefinition(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList nodes = theDoc.getDescendants("signal");
        if (nodes.getLength() < 1) {
            reporter.report(CheckList.CHECK_INFORMATION, theDoc, Messages.CheckSignals_6);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkBusInterfaceSignals(DocumentChecker checker) {
        int nErrors = 0;
        SpiritComponentDocument documentNode = (SpiritComponentDocument)checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        SpiritLibrary library = checker.getLibrary();
        List busInterfaces = documentNode.getBusInterfaces();
        for (BusInterface busInterface : busInterfaces) {
            SpiritDocument doc = library.get(busInterface.getVlnv());
            if (doc == null) {
                reporter.report(CheckList.CHECK_INFORMATION, (SpiritDocument)documentNode, MessageFormat.format(Messages.CheckChannels_1, busInterface.getVlnv(), busInterface));
                ++nErrors;
                continue;
            }
            if (!(doc instanceof SpiritBusDefinitionDocument)) {
                reporter.report(CheckList.CHECK_INFORMATION, (SpiritDocument)documentNode, MessageFormat.format(Messages.CheckChannels_2, busInterface.getVlnv()), (SpiritNode)busInterface);
                ++nErrors;
                continue;
            }
            SpiritBusDefinitionDocument busDefDoc = (SpiritBusDefinitionDocument)doc;
            Vlnv busDefVlnv = busDefDoc.getVlnv();
            SpiritAbstractionDefinitionDocument absDoc = null;
            Vlnv abstractionVlnv = busInterface.getAbstractionVlnv();
            try {
                if (abstractionVlnv != null) {
                    absDoc = (SpiritAbstractionDefinitionDocument)library.get(abstractionVlnv);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            SpiritBusDefinitionDocument busSignalsDoc = absDoc == null ? busDefDoc : absDoc;
            String modeName = null;
            if (busInterface.isMaster() || busInterface.isMirroredMaster()) {
                modeName = "master";
            } else if (busInterface.isSlave() || busInterface.isMirroredSlave()) {
                modeName = "slave";
            } else if (busInterface.isSystem() || busInterface.isMirroredSystem()) {
                modeName = "system";
            } else if (busInterface.isMonitor()) {
                modeName = busInterface.getMonitorInterfaceType().equals("master") || busInterface.getMonitorInterfaceType().equals("mirroredMaster") ? "master" : (busInterface.getMonitorInterfaceType().equals("slave") || busInterface.getMonitorInterfaceType().equals("mirroredSlave") ? "slave" : "system");
            }
            if (modeName == null) continue;
            nErrors += CheckSignals.checkSignalsOnOneInterface((SpiritDocument)documentNode, reporter, (GenericBusInterface)busInterface, abstractionVlnv == null ? busDefVlnv : abstractionVlnv, (SpiritBusTypeDocument)busSignalsDoc, modeName);
        }
        return nErrors;
    }

    public static int checkAbstractorInterfaceSignals(DocumentChecker checker) {
        int nErrors = 0;
        SpiritAbstractorDocument theDocument = (SpiritAbstractorDocument)checker.getSpiritDocument();
        AbstractorInterface primaryInterface = theDocument.getPrimaryAbstractorInterface();
        nErrors += CheckSignals.checkOneAbstractorInterfaceSignals(checker, primaryInterface);
        AbstractorInterface secondaryInterface = theDocument.getSecondaryAbstractorInterface();
        return nErrors += CheckSignals.checkOneAbstractorInterfaceSignals(checker, secondaryInterface);
    }

    private static int checkOneAbstractorInterfaceSignals(DocumentChecker checker, AbstractorInterface abstractorInterface) {
        int nErrors = 0;
        SpiritDocument documentNode = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        Vlnv abstractorVlnv = abstractorInterface.getAbstractionVlnv();
        try {
            SpiritAbstractionDefinitionDocument abstractionDefinition = (SpiritAbstractionDefinitionDocument)checker.getLibrary().get(abstractorVlnv);
            if (abstractionDefinition != null) {
                nErrors += CheckSignals.checkSignalsOnOneInterface(documentNode, reporter, (GenericBusInterface)abstractorInterface, abstractorVlnv, (SpiritBusTypeDocument)abstractionDefinition, abstractorInterface.getModeString());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return nErrors;
    }

    private static int checkSignalsOnOneInterface(SpiritDocument documentNode, ICheckerReporter reporter, GenericBusInterface busInterface, Vlnv busDefVlnv, SpiritBusTypeDocument busSignalsDoc, String modeName) {
        int nErrors = 0;
        List signalMap = busInterface.getSignalMap();
        if (signalMap != null) {
            HashSet<String> logicalSignalNames = new HashSet<String>();
            for (SignalMapElement signalMapElement : signalMap) {
                logicalSignalNames.add(signalMapElement.getBusSignalName());
            }
            List busSignals = busSignalsDoc.getSignals();
            for (SpiritSignal busSignal : busSignals) {
                OnMode onMode = busSignal.getModeInfoForBusInterface(busInterface);
                if (onMode == null || !onMode.isRequired() || logicalSignalNames.contains(busSignal.getName())) continue;
                reporter.report(CheckList.CHECK_V14_608, documentNode, MessageFormat.format("The port {0}, which is required in by the abstraction definition {1}, is missing from the bus interface {2}", busSignal.getName(), busDefVlnv, busInterface.getName()), busInterface.getUniqueDescendantElement("signalMap", SpiritNode.class));
                ++nErrors;
            }
            for (SignalMapElement signalMapEntry : signalMap) {
                ComponentSignal signal = signalMapEntry.getComponentSignal();
                if (signal == null) {
                    reporter.report(CheckList.CHECK_WARNING, documentNode, MessageFormat.format(Messages.CheckChannels_19, signalMapEntry.getName()), (SpiritNode)signalMapEntry);
                    ++nErrors;
                    continue;
                }
                String busDefSignalName = signalMapEntry.getBusSignalName();
                SpiritSignal busDefSignal = busSignalsDoc.getSignalByName(busDefSignalName);
                if (busDefSignal == null) {
                    reporter.report(CheckList.CHECK_49, documentNode, MessageFormat.format(Messages.CheckChannels_21, busDefSignalName, busDefVlnv), (SpiritNode)signalMapEntry);
                    ++nErrors;
                    continue;
                }
                String modelDirection = signal.getDirection();
                OnMode modeInfo = busDefSignal.getModeInfoForBusInterface(busInterface);
                if (modeInfo == null) {
                    reporter.report(CheckList.CHECK_WARNING, documentNode, MessageFormat.format("Signal {0} not defined for a {1} interface in bus definition {2}", busDefSignalName, modeName, busDefVlnv), (SpiritNode)signalMapEntry);
                    ++nErrors;
                }
                if (signal.isWireSignal()) {
                    String busDirection;
                    if (busInterface.isMonitor()) {
                        busDirection = "in";
                    } else {
                        busDirection = modeInfo == null ? "" : modeInfo.getDirection();
                        if (busInterface.isMirrored()) {
                            if (busDirection.equals("in")) {
                                busDirection = "out";
                            } else if (busDirection.equals("out")) {
                                busDirection = "in";
                            }
                        }
                    }
                    if (!(modelDirection.length() <= 0 || busDirection.length() <= 0 || modelDirection.equals("inout") || modelDirection.equals("phantom") || signal.allLogicalDirectionsAllowed() || modelDirection.equals(busDirection))) {
                        reporter.report(CheckList.CHECK_49, documentNode, MessageFormat.format(Messages.CheckChannels_32, busDefSignalName, busDefVlnv), (SpiritNode)signalMapEntry);
                        ++nErrors;
                    }
                    String busWidth = "";
                    if (modeInfo != null) {
                        busWidth = modeInfo.getWidth();
                    }
                    try {
                        LeftRightEvaluator signalMapBounds = new LeftRightEvaluator((SpiritNode)signalMapEntry);
                        LeftRightEvaluator modelBounds = new LeftRightEvaluator((SpiritNode)signal);
                        if (busWidth == null || busWidth.length() <= 0) continue;
                        int busWidthAsInt = Integer.parseInt(busWidth);
                        if (signalMapBounds.isDefined()) {
                            if (signalMapBounds.getWidth() > busWidthAsInt) {
                                reporter.report(CheckList.CHECK_ERROR, documentNode, MessageFormat.format(Messages.CheckChannels_36, busDefSignalName, new Integer(signalMapBounds.getWidth()), busDefVlnv, new Integer(busWidthAsInt)), (SpiritNode)signalMapEntry);
                                ++nErrors;
                            }
                            if (!modelBounds.isDefined()) continue;
                            if (modelBounds.getMsb() < signalMapBounds.getMsb()) {
                                reporter.report(CheckList.CHECK_ERROR, documentNode, MessageFormat.format(Messages.CheckChannels_37, busDefSignalName, new Integer(signalMapBounds.getMsb()), new Integer(modelBounds.getMsb())), (SpiritNode)signal);
                                ++nErrors;
                            }
                            if (modelBounds.getLsb() <= signalMapBounds.getLsb()) continue;
                            reporter.report(CheckList.CHECK_ERROR, documentNode, MessageFormat.format(Messages.CheckChannels_38, busDefSignalName, new Integer(signalMapBounds.getLsb()), new Integer(modelBounds.getLsb())), (SpiritNode)signal);
                            ++nErrors;
                            continue;
                        }
                        if (modelBounds.isDefined()) {
                            if (modelBounds.getWidth() <= busWidthAsInt) continue;
                            reporter.report(CheckList.CHECK_ERROR, documentNode, MessageFormat.format(Messages.CheckChannels_39, busDefSignalName, new Integer(modelBounds.getWidth()), busDefVlnv, new Integer(busWidthAsInt)), (SpiritNode)signal);
                            ++nErrors;
                            continue;
                        }
                        if (busWidthAsInt <= 1) continue;
                        reporter.report(CheckList.CHECK_ERROR, documentNode, MessageFormat.format(Messages.CheckChannels_40, busDefSignalName), (SpiritNode)signal);
                        ++nErrors;
                    }
                    catch (NumberFormatException e) {
                        reporter.report(CheckList.CHECK_WARNING, documentNode, MessageFormat.format(Messages.CheckChannels_41, busDefSignalName, busWidth), (SpiritNode)signal);
                        ++nErrors;
                    }
                    continue;
                }
                if (signal.allLogicalInitiativesAllowed()) continue;
                String busInitiative = modeInfo.getInitiative();
                if (busInterface.isMirrored()) {
                    if ("requires".equals(busInitiative)) {
                        busInitiative = "provides";
                    } else if ("provides".equals(busInitiative)) {
                        busInitiative = "requires";
                    }
                }
                String componentInitiative = signal.getInitiative();
                if ("requires".equals(busInitiative) && "provides".equals(componentInitiative)) {
                    if (busInterface.isMirrored()) {
                        reporter.report(CheckList.CHECK_V14_602, documentNode, MessageFormat.format("Logical port {0} has initiative provides, but mirrored physical port {1} has initiative provides", busDefSignalName, signalMapEntry.getName()), (SpiritNode)signalMapEntry);
                    } else {
                        reporter.report(CheckList.CHECK_V14_602, documentNode, MessageFormat.format("Logical port {0} has initiative requires, but physical port {1} has initiative provides", busDefSignalName, signalMapEntry.getName()), (SpiritNode)signalMapEntry);
                    }
                    ++nErrors;
                    continue;
                }
                if ("provides".equals(busInitiative) && "requires".equals(componentInitiative)) {
                    if (busInterface.isMirrored()) {
                        reporter.report(CheckList.CHECK_V14_603, documentNode, MessageFormat.format("Logical port {0} has initiative requires, but mirrored physical port {1} has initiative requires", busDefSignalName, signalMapEntry.getName()), (SpiritNode)signalMapEntry);
                    } else {
                        reporter.report(CheckList.CHECK_V14_603, documentNode, MessageFormat.format("Logical port {0} has initiative provides, but physical port {1} has initiative requires", busDefSignalName, signalMapEntry.getName()), (SpiritNode)signalMapEntry);
                    }
                    ++nErrors;
                    continue;
                }
                if (!"both".equals(busInitiative) || !"requires".equals(componentInitiative) && !"provides".equals(componentInitiative)) continue;
                reporter.report(CheckList.CHECK_V14_604, documentNode, MessageFormat.format("Logical port {0} has initiative both, but physical port {1} has initiative {2}", busDefSignalName, signalMapEntry.getName(), componentInitiative), (SpiritNode)signalMapEntry);
                ++nErrors;
            }
        }
        return nErrors;
    }

    static class LeftRightEvaluator {
        private boolean isDefined = false;
        private int left;
        private int right;

        public LeftRightEvaluator(SpiritNode node) {
            String leftAsString = node.getUniqueDescendantText("left");
            String rightAsString = node.getUniqueDescendantText("right");
            if (leftAsString.length() != 0 && rightAsString.length() != 0) {
                this.right = Integer.parseInt(rightAsString);
                this.left = Integer.parseInt(leftAsString);
                this.isDefined = true;
            }
        }

        public boolean isDefined() {
            return this.isDefined;
        }

        int getLeft() {
            return this.left;
        }

        int getRight() {
            return this.right;
        }

        int getWidth() {
            return Math.abs(this.right - this.left) + 1;
        }

        int getLsb() {
            return Math.min(this.left, this.right);
        }

        int getMsb() {
            return Math.max(this.left, this.right);
        }
    }
}

