/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.disassembly.text;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.CharBuffer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.text.IFileRider;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.text.REDFile;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.text.REDFileRider;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.text.REDRun;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.text.StringRider;
import org.eclipse.jface.text.ITextStore;

public final class REDTextStore
implements ITextStore {
    private static final int SCRATCH_FILE_THRESHOLD = 0x100000;
    private static final int MAX_SCRATCH_FILES = 4;
    private static final int RECYCLE_THRESHOLD = 20;
    private static final int IN_MEMORY_LIMIT = 32768;
    private static final int CHUNK_SIZE = 4096;
    private REDFileRider[] fScratchFiles = new REDFileRider[4];
    private LinkedRun fHead;
    private LinkedRun fSpare;
    private LinkedRun fCache;
    private int fCachePos;
    private int fLength;
    private int fDeadLength;
    private final RunSpec fRunSpec = new RunSpec();
    private Job fSwapper;

    public REDTextStore() {
    }

    public REDTextStore(String text) {
        this.set(text);
    }

    protected void finalize() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        RunSpec runSpec = this.fRunSpec;
        synchronized (runSpec) {
            if (this.fSwapper != null) {
                this.fSwapper.cancel();
                this.fSwapper = null;
            }
            for (int i = 0; i < this.fScratchFiles.length; ++i) {
                if (this.fScratchFiles[i] == null) continue;
                this.fScratchFiles[i].getFile().dispose();
                this.fScratchFiles[i] = null;
            }
            this.fHead = null;
            this.fCache = null;
            this.fSpare = null;
            this.fRunSpec.fRun = null;
            this.fCachePos = 0;
            this.fLength = 0;
            this.fDeadLength = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char get(int offset) {
        RunSpec runSpec = this.fRunSpec;
        synchronized (runSpec) {
            RunSpec spec = this.findNextRun(offset, null);
            if (spec.fRun != null) {
                return spec.fRun.charAt(spec.fOff);
            }
            return '\u0000';
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(int offset, int length) {
        RunSpec runSpec = this.fRunSpec;
        synchronized (runSpec) {
            if (length == this.fLength && this.fSwapper != null && this.fHead != null && this.fHead.fNext == null) {
                ((StringRider)this.fHead.fRider).fBuffer.position(0);
                return ((StringRider)this.fHead.fRider).fBuffer.toString();
            }
            return this.toString(offset, offset + length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        RunSpec runSpec = this.fRunSpec;
        synchronized (runSpec) {
            return this.fLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String text) {
        RunSpec runSpec = this.fRunSpec;
        synchronized (runSpec) {
            this.dispose();
            if (text != null) {
                this.fHead = new LinkedRun(new StringRider(text), 0, text.length());
                this.fLength = text.length();
                if (this.fLength > 32768) {
                    this.fSwapper = new TextStoreSwapper(this.fHead.fRider, text);
                    this.fSwapper.schedule(1000L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int offset, int length, String text) {
        RunSpec runSpec = this.fRunSpec;
        synchronized (runSpec) {
            if (text == null || text.length() == 0) {
                this.replace(offset, length, null, 0, 0);
            } else {
                this.replace(offset, length, text, 0, text.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        RunSpec runSpec = this.fRunSpec;
        synchronized (runSpec) {
            return this.toString(0, this.getLength());
        }
    }

    private String toString(int from, int to) {
        assert (from >= 0 && from <= to && to <= this.fLength);
        int len = to - from;
        StringBuffer strBuf = new StringBuffer(len);
        if (len > 0) {
            RunSpec spec = this.findPrevRun(from, this.fRunSpec);
            try {
                for (int done = spec.fRun.appendTo(strBuf, len, spec.fOff); done < len; done += spec.fRun.appendTo(strBuf, len - done, 0)) {
                    spec.fRun = spec.fRun.fNext;
                    assert (spec.fRun != null);
                }
            }
            catch (IOException e) {
                this.internalError(e);
            }
        }
        assert (strBuf.length() == len);
        return strBuf.toString();
    }

    private void replace(int from, int deleteLen, Object buf, int off, int insertLen) {
        assert (from >= 0 && from <= this.fLength);
        assert (deleteLen >= 0);
        assert (from + deleteLen <= this.fLength);
        RunPair split = null;
        if (deleteLen > 0) {
            split = this.delete(from, from + deleteLen);
        }
        if (buf == null || insertLen == 0) {
            return;
        }
        if (split == null) {
            split = this.splitRun(from);
        }
        RunPair insert = this.makeRuns(split.fBefore, buf, off, insertLen);
        this.insertRuns(split, insert.fBefore, insert.fAfter);
        this.fLength += insertLen;
        this.fCache = insert.fAfter;
        this.fCachePos = from + insertLen - insert.fAfter.fLength;
        if (split.fBefore != null) {
            this.mergeRuns(split.fBefore, split.fAfter);
        } else {
            this.mergeRuns(this.fHead, split.fAfter);
        }
        if (this.fDeadLength > this.fLength / 10) {
            this.reconcile();
        }
    }

    public void reconcile() {
        LinkedRun run = this.fHead;
        REDFileRider[] scratchFiles = this.fScratchFiles;
        this.fScratchFiles = new REDFileRider[4];
        this.fHead = null;
        this.fCache = null;
        this.fCachePos = -1;
        this.fSpare = null;
        this.fLength = 0;
        this.fDeadLength = 0;
        char[] buf = new char[4096];
        int offset = 0;
        int runOffset = 0;
        while (run != null) {
            try {
                int n;
                do {
                    n = run.copyInto(buf, 0, buf.length, runOffset);
                    this.replace(offset, 0, buf, 0, n);
                    offset += n;
                } while ((runOffset += n) < run.fLength);
            }
            catch (IOException e) {
                this.internalError(e);
            }
            run = run.fNext;
            runOffset = 0;
        }
        for (int i = 0; i < scratchFiles.length; ++i) {
            if (scratchFiles[i] == null) continue;
            scratchFiles[i].getFile().dispose();
            scratchFiles[i] = null;
        }
    }

    private LinkedRun createRun(LinkedRun before, int n) {
        IFileRider scratchFile = before != null && before.fRider.length() == before.fOffset + before.fLength && before.fRider.limit() >= before.fRider.length() + n ? before.fRider : this.getScratchFile();
        return new LinkedRun(scratchFile, scratchFile.length(), n);
    }

    private REDFileRider getScratchFile() {
        REDFileRider rider = null;
        for (int i = 0; i < this.fScratchFiles.length; ++i) {
            rider = this.fScratchFiles[i];
            if (rider == null) {
                try {
                    rider = new REDFileRider(new REDFile());
                }
                catch (IOException e) {
                    this.internalError(e);
                }
                this.fScratchFiles[i] = rider;
                break;
            }
            if (rider.length() < 0x100000) break;
        }
        return rider;
    }

    private void spareRun(LinkedRun run, LinkedRun last) {
        if (last != null) {
            last.fNext = null;
        }
        LinkedRun cur = run;
        LinkedRun prev = null;
        while (cur != null) {
            if (cur.fRider.isReadonly()) {
                if (prev != null) {
                    prev.fNext = cur.fNext;
                } else {
                    run = cur.fNext;
                }
                if (cur.fNext != null) {
                    cur.fNext.fPrev = prev;
                }
            } else {
                prev = cur;
            }
            cur = cur.fNext;
        }
        if (run == null) {
            return;
        }
        last = prev;
        if (last != null) {
            last.fNext = this.fSpare;
        }
        if (this.fSpare != null) {
            this.fSpare.fPrev = last;
        }
        this.fSpare = run;
        this.fSpare.fPrev = null;
    }

    private LinkedRun recycleRun() {
        LinkedRun recycled = this.fSpare;
        this.fSpare = null;
        return recycled;
    }

    private void internalError(Exception e) {
        throw new Error("Internal error", e);
    }

    private RunPair delete(int from, int to) {
        RunPair start = this.splitRun(from);
        RunPair end = this.splitRun(to);
        if (start.fBefore != null) {
            start.fBefore.fNext = end.fAfter;
        } else {
            this.fHead = end.fAfter;
        }
        if (end.fAfter != null) {
            end.fAfter.fPrev = start.fBefore;
        }
        if (end.fAfter != null) {
            this.fCache = end.fAfter;
            this.fCachePos = from;
        } else {
            this.fCache = this.fHead;
            this.fCachePos = 0;
        }
        this.fLength -= to - from;
        if (this.fLength == 0) {
            this.dispose();
            return null;
        }
        this.spareRun(start.fAfter, end.fBefore);
        start.fAfter = end.fAfter;
        return start;
    }

    private RunSpec findPrevRun(int pos, RunSpec spec) {
        int curPos;
        LinkedRun cur;
        assert (pos >= 0 && pos <= this.fLength);
        if (this.fCache != null && this.fCachePos - pos < pos) {
            assert (this.fCache != null);
            cur = this.fCache;
            curPos = this.fCachePos;
        } else {
            cur = this.fHead;
            curPos = 0;
        }
        while (cur != null && pos - curPos > cur.fLength) {
            curPos += cur.fLength;
            cur = cur.fNext;
        }
        if (pos != 0) {
            while (pos - curPos <= 0) {
                cur = cur.fPrev;
                curPos -= cur.fLength;
            }
        }
        this.fCache = cur;
        this.fCachePos = curPos;
        if (spec == null) {
            spec = this.fRunSpec;
        }
        spec.fRun = cur;
        spec.fOrg = curPos;
        spec.fOff = pos - curPos;
        return spec;
    }

    private RunSpec findNextRun(int pos, RunSpec spec) {
        if (pos < this.fLength) {
            spec = this.findPrevRun(pos + 1, spec);
            --spec.fOff;
        } else {
            spec = this.findPrevRun(pos, spec);
        }
        return spec;
    }

    private RunPair splitRun(int pos) {
        RunPair p = new RunPair();
        if (pos == 0) {
            p.fBefore = null;
            p.fAfter = this.fHead;
        } else {
            RunSpec spec = this.findPrevRun(pos, null);
            assert (spec.isValid());
            p.fBefore = spec.fRun;
            int len = spec.fRun.length();
            if (spec.fOff != len) {
                p.fAfter = new LinkedRun(p.fBefore.fRider, p.fBefore.fOffset + spec.fOff, p.fBefore.fLength - spec.fOff);
                p.fBefore.fLength = spec.fOff;
                p.fAfter.fNext = p.fBefore.fNext;
                if (p.fAfter.fNext != null) {
                    p.fAfter.fNext.fPrev = p.fAfter;
                }
                p.fBefore.fNext = p.fAfter;
                p.fAfter.fPrev = p.fBefore;
            } else {
                p.fAfter = p.fBefore.fNext;
            }
        }
        return p;
    }

    private void mergeRuns(LinkedRun start, LinkedRun end) {
        LinkedRun cur = start;
        LinkedRun next = cur.fNext;
        while (cur != end && next != null) {
            if (cur.isMergeableWith(next)) {
                if (next == this.fCache) {
                    this.fCache = cur;
                    this.fCachePos -= cur.fLength;
                }
                cur.fLength += next.fLength;
                cur.fNext = next.fNext;
                if (cur.fNext != null) {
                    cur.fNext.fPrev = cur;
                }
                if (next == end) {
                    break;
                }
            } else {
                cur = next;
            }
            next = cur.fNext;
        }
    }

    private RunPair makeRuns(LinkedRun before, Object buf, int off, int n) {
        LinkedRun run;
        RunPair result = new RunPair();
        LinkedRun recycled = this.recycleRun();
        if (recycled != null) {
            int count;
            result.fBefore = recycled;
            run = recycled;
            do {
                count = Math.min(run.fLength, n);
                try {
                    assert (!run.fRider.isReadonly());
                    if (run.fRider.isReadonly()) {
                        run = null;
                        break;
                    }
                    run.fRider.seek(run.fOffset);
                    if (buf instanceof char[]) {
                        run.fRider.writeChars((char[])buf, off, count);
                    } else {
                        run.fRider.writeChars((String)buf, off, count);
                    }
                    if (run.fLength - count >= 20) {
                        LinkedRun next = run.fNext;
                        LinkedRun newRun = new LinkedRun(run.fRider, run.fOffset + count, run.fLength - count);
                        this.joinRuns(run, newRun);
                        this.joinRuns(newRun, next);
                    } else {
                        this.fDeadLength += run.fLength - count;
                    }
                    run.fLength = count;
                    off += count;
                    before = run;
                    run = run.fNext;
                }
                catch (IOException e) {
                    run = null;
                    break;
                }
            } while (run != null && (n -= count) > 0);
            if (run != null) {
                this.fSpare = run;
            }
        }
        if (n > 0) {
            run = this.createRun(before, n);
            if (buf instanceof char[]) {
                try {
                    run.fRider.seek(run.fOffset);
                    run.fRider.writeChars((char[])buf, off, n);
                }
                catch (IOException e) {
                    run = new LinkedRun(new StringRider(CharBuffer.wrap((char[])buf, off, off + n)), 0, n);
                }
            } else {
                try {
                    run.fRider.seek(run.fOffset);
                    run.fRider.writeChars((String)buf, off, n);
                }
                catch (IOException e) {
                    run = new LinkedRun(new StringRider(CharBuffer.wrap((String)buf, off, off + n)), 0, n);
                }
            }
            if (result.fBefore == null) {
                result.fBefore = run;
            } else {
                this.joinRuns(before, run);
            }
            result.fAfter = run;
        } else {
            result.fAfter = before;
        }
        return result;
    }

    private void joinRuns(LinkedRun start, LinkedRun next) {
        assert (start != next);
        start.fNext = next;
        if (next != null) {
            next.fPrev = start;
        }
    }

    private void insertRuns(RunPair pos, LinkedRun start, LinkedRun end) {
        assert (pos.fBefore == null || pos.fBefore != pos.fAfter);
        start.fPrev = pos.fBefore;
        if (pos.fBefore != null) {
            pos.fBefore.fNext = start;
        } else {
            this.fHead = start;
        }
        end.fNext = pos.fAfter;
        if (pos.fAfter != null) {
            pos.fAfter.fPrev = end;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private REDFileRider swap(IFileRider oldRider, REDFileRider newRider) {
        RunSpec runSpec = this.fRunSpec;
        synchronized (runSpec) {
            LinkedRun cur = this.fHead;
            while (cur != null) {
                if (cur.fRider == oldRider) {
                    cur.fRider = newRider;
                }
                cur = cur.fNext;
            }
            for (int i = 0; i < this.fScratchFiles.length; ++i) {
                if (this.fScratchFiles[i] != null) continue;
                this.fScratchFiles[i] = newRider;
                newRider = null;
            }
            if (newRider != null) {
                REDFileRider[] scratchFiles = new REDFileRider[this.fScratchFiles.length + 1];
                System.arraycopy(this.fScratchFiles, 0, scratchFiles, 0, this.fScratchFiles.length);
                scratchFiles[this.fScratchFiles.length] = newRider;
                this.fScratchFiles = scratchFiles;
                newRider = null;
            }
            this.fRunSpec.fRun = null;
            this.fSwapper = null;
        }
        return newRider;
    }

    public void printStatistics(PrintStream out) {
        int nRuns = 0;
        int nSpare = 0;
        int spareLength = 0;
        LinkedRun run = this.fHead;
        while (run != null) {
            ++nRuns;
            run = run.fNext;
        }
        run = this.fSpare;
        while (run != null) {
            ++nSpare;
            spareLength += run.fLength;
            run = run.fNext;
        }
        double runMean = nRuns > 0 ? (double)this.fLength / (double)nRuns : Double.NaN;
        double spareMean = nSpare > 0 ? (double)(spareLength / nSpare) : Double.NaN;
        out.println("Length: " + this.fLength);
        out.println("Number of runs: " + nRuns);
        out.println("Mean length of runs: " + runMean);
        out.println("Length of spare runs: " + spareLength);
        out.println("Number of spare runs: " + nSpare);
        out.println("Mean length of spare runs: " + spareMean);
        out.println("Length of dead runs: " + this.fDeadLength);
    }

    String getStructure() {
        LinkedRun cur = this.fHead;
        String structure = "";
        while (cur != null) {
            try {
                structure = structure + cur.asString() + "->\n";
            }
            catch (IOException e) {
                this.internalError(e);
            }
            cur = cur.fNext;
        }
        structure = structure + "null";
        return structure;
    }

    boolean checkConsistency() {
        LinkedRun run = this.fHead;
        int length = 0;
        while (run != null) {
            LinkedRun prev = run.fPrev;
            LinkedRun next = run.fNext;
            assert (prev != run);
            assert (next != run);
            assert (prev == null || prev.fNext == run);
            assert (next == null || next.fPrev == run);
            while (prev != null) {
                prev = prev.fPrev;
                assert (run != prev);
            }
            LinkedRun spare = this.fSpare;
            while (spare != null) {
                assert (run != spare);
                spare = spare.fPrev;
            }
            length += run.fLength;
            run = next;
        }
        assert (length == this.fLength);
        if (this.fCache != null) {
            int pos = this.fCachePos;
            run = this.fCache;
            while (run.fPrev != null) {
                run = run.fPrev;
                pos -= run.fLength;
            }
            assert (pos == 0);
            pos = this.fCachePos;
            run = this.fCache;
            while (run != null) {
                pos += run.fLength;
                run = run.fNext;
            }
            assert (pos == this.fLength);
        }
        return true;
    }

    int runLength(LinkedRun first, LinkedRun last) {
        LinkedRun run = first;
        int length = 0;
        while (run != null) {
            length += run.fLength;
            if (run == last) break;
            run = run.fNext;
        }
        return length;
    }

    private static final class RunPair {
        public LinkedRun fBefore;
        public LinkedRun fAfter;

        private RunPair() {
        }
    }

    private static final class RunSpec {
        public LinkedRun fRun = null;
        public int fOrg = -1;
        public int fOff = -1;

        private RunSpec() {
        }

        public boolean isValid() {
            return this.fRun != null;
        }
    }

    private static final class LinkedRun
    extends REDRun {
        LinkedRun fNext;
        LinkedRun fPrev;

        LinkedRun(IFileRider rider, String str) throws IOException {
            super(rider, str);
        }

        LinkedRun(IFileRider rider, char[] buf, int off, int n) throws IOException {
            super(rider, buf, off, n);
        }

        LinkedRun(IFileRider rider, int offset, int length) {
            super(rider, offset, length);
        }
    }

    private final class TextStoreSwapper
    extends Job {
        private IFileRider fRider;
        private String fText;

        private TextStoreSwapper(IFileRider rider, String text) {
            super("");
            this.fRider = rider;
            this.fText = text;
            this.setName("Swapping editor buffer to disk");
            this.setPriority(30);
        }

        public IStatus run(IProgressMonitor monitor) {
            REDFileRider fileRider = null;
            if (!monitor.isCanceled()) {
                try {
                    int n;
                    fileRider = new REDFileRider(new REDFile());
                    int size = this.fText.length();
                    monitor.beginTask(this.getName(), size + 1);
                    for (int written = 0; written < size && !monitor.isCanceled(); written += n) {
                        n = Math.min(size - written, 4096);
                        fileRider.writeChars(this.fText, written, n);
                        monitor.worked(n);
                    }
                }
                catch (IOException e) {
                    this.cancel();
                }
            }
            if (!monitor.isCanceled()) {
                fileRider = REDTextStore.this.swap(this.fRider, fileRider);
                monitor.done();
            }
            if (fileRider != null) {
                fileRider.getFile().dispose();
            }
            this.fText = null;
            this.fRider = null;
            return Status.OK_STATUS;
        }
    }
}

